/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.testing.TestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.Path;

public class JvmTestExecutionSpec
implements TestExecutionSpec {
    private final TestFramework testFramework;
    private final Iterable<? extends File> classpath;
    private final Iterable<? extends File> modulePath;
    private final FileTree candidateClassFiles;
    private final boolean scanForTestClasses;
    private final FileCollection testClassesDirs;
    private final String path;
    private final Path identityPath;
    private final long forkEvery;
    private final JavaForkOptions javaForkOptions;
    private final int maxParallelForks;
    private final Set<String> previousFailedTestClasses;
    private final boolean testIsModule;

    public JvmTestExecutionSpec(TestFramework testFramework, Iterable<? extends File> classpath, FileTree candidateClassFiles, boolean scanForTestClasses, FileCollection testClassesDirs, String path, Path identityPath, long forkEvery, JavaForkOptions javaForkOptions, int maxParallelForks, Set<String> previousFailedTestClasses) {
        this(testFramework, classpath, Collections.emptyList(), candidateClassFiles, scanForTestClasses, testClassesDirs, path, identityPath, forkEvery, javaForkOptions, maxParallelForks, previousFailedTestClasses);
    }

    public JvmTestExecutionSpec(TestFramework testFramework, Iterable<? extends File> classpath, Iterable<? extends File> modulePath, FileTree candidateClassFiles, boolean scanForTestClasses, FileCollection testClassesDirs, String path, Path identityPath, long forkEvery, JavaForkOptions javaForkOptions, int maxParallelForks, Set<String> previousFailedTestClasses) {
        this(testFramework, classpath, modulePath, candidateClassFiles, scanForTestClasses, testClassesDirs, path, identityPath, forkEvery, javaForkOptions, maxParallelForks, previousFailedTestClasses, false);
    }

    public JvmTestExecutionSpec(TestFramework testFramework, Iterable<? extends File> classpath, Iterable<? extends File> modulePath, FileTree candidateClassFiles, boolean scanForTestClasses, FileCollection testClassesDirs, String path, Path identityPath, long forkEvery, JavaForkOptions javaForkOptions, int maxParallelForks, Set<String> previousFailedTestClasses, boolean testIsModule) {
        this.testFramework = testFramework;
        this.classpath = classpath;
        this.modulePath = modulePath;
        this.candidateClassFiles = candidateClassFiles;
        this.scanForTestClasses = scanForTestClasses;
        this.testClassesDirs = testClassesDirs;
        this.path = path;
        this.identityPath = identityPath;
        this.forkEvery = forkEvery;
        this.javaForkOptions = javaForkOptions;
        this.maxParallelForks = maxParallelForks;
        this.previousFailedTestClasses = previousFailedTestClasses;
        this.testIsModule = testIsModule;
    }

    public JvmTestExecutionSpec copyWithTestFramework(TestFramework testFramework) {
        return new JvmTestExecutionSpec(testFramework, this.classpath, this.modulePath, this.candidateClassFiles, this.scanForTestClasses, this.testClassesDirs, this.path, this.identityPath, this.forkEvery, this.javaForkOptions, this.maxParallelForks, this.previousFailedTestClasses, this.testIsModule);
    }

    public TestFramework getTestFramework() {
        return this.testFramework;
    }

    public Iterable<? extends File> getClasspath() {
        return this.classpath;
    }

    public Iterable<? extends File> getModulePath() {
        return this.modulePath;
    }

    public FileTree getCandidateClassFiles() {
        return this.candidateClassFiles;
    }

    public boolean isScanForTestClasses() {
        return this.scanForTestClasses;
    }

    public FileCollection getTestClassesDirs() {
        return this.testClassesDirs;
    }

    public String getPath() {
        return this.path;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public long getForkEvery() {
        return this.forkEvery;
    }

    public JavaForkOptions getJavaForkOptions() {
        return this.javaForkOptions;
    }

    public int getMaxParallelForks() {
        return this.maxParallelForks;
    }

    public Set<String> getPreviousFailedTestClasses() {
        return this.previousFailedTestClasses;
    }

    public boolean getTestIsModule() {
        return this.testIsModule;
    }
}

