/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.services.ServiceReference;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.extensibility.ConventionAwareHelper;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.AbstractClassGenerator;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ManagedObjectFactory;
import org.gradle.internal.instantiation.generator.MixInExtensibleDynamicObject;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ModelObject;
import org.gradle.internal.state.OwnerAware;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.asm.BytecodeFragment;
import org.gradle.model.internal.asm.ClassGeneratorSuffixRegistry;
import org.gradle.model.internal.asm.ClassVisitorScope;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import sun.reflect.ReflectionFactory;

public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    private static final ThreadLocal<ObjectCreationDetails> SERVICES_FOR_NEXT_OBJECT = new ThreadLocal();
    private static final AtomicReference<CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl>> GENERATED_CLASSES_CACHES = new AtomicReference();
    private final boolean decorate;
    private final String suffix;
    private final int factoryId;
    private static final String GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME = "getDisplayNameForNext";
    private static final String GET_SERVICES_FOR_NEXT_METHOD_NAME = "getServicesForNext";
    private static final String GET_FACTORY_FOR_NEXT_METHOD_NAME = "getFactoryForNext";

    @Nullable
    public static Describable getDisplayNameForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        if (details == null) {
            return null;
        }
        return details.displayName;
    }

    public static ServiceLookup getServicesForNext() {
        return AsmBackedClassGenerator.SERVICES_FOR_NEXT_OBJECT.get().services;
    }

    public static ManagedObjectFactory getFactoryForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        return new ManagedObjectFactory(details.services, details.instantiator, details.roleHandler);
    }

    private AsmBackedClassGenerator(boolean decorate, String suffix, Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledInjectAnnotations, PropertyRoleAnnotationHandler roleHandler, CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses, int factoryId) {
        super(allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses);
        this.decorate = decorate;
        this.suffix = suffix;
        this.factoryId = factoryId;
    }

    static ClassGenerator decorateAndInject(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses;
        String suffix;
        if (enabledInjectAnnotations.isEmpty()) {
            suffix = "_Decorated";
            if (GENERATED_CLASSES_CACHES.get() == null && GENERATED_CLASSES_CACHES.compareAndSet(null, cacheFactory.newClassMap())) {
                ClassGeneratorSuffixRegistry.register(suffix);
            }
            generatedClasses = GENERATED_CLASSES_CACHES.get();
        } else {
            suffix = ClassGeneratorSuffixRegistry.assign("$Decorated");
            generatedClasses = cacheFactory.newClassMap();
        }
        return new AsmBackedClassGenerator(true, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses, factoryId);
    }

    static ClassGenerator injectOnly(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        String suffix = ClassGeneratorSuffixRegistry.assign("$Inject");
        return new AsmBackedClassGenerator(false, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, cacheFactory.newClassMap(), factoryId);
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createUsingConstructor(Constructor<?> constructor) {
        return new InvokeConstructorStrategy(constructor, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createForSerialization(Class<?> generatedType, Class<?> baseClass) {
        Constructor<?> constructor;
        try {
            constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(generatedType, baseClass.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        Method method = (Method)CollectionUtils.findFirst((Object[])generatedType.getDeclaredMethods(), m -> m.getName().equals("$gradleInit"));
        assert (method != null);
        method.setAccessible(true);
        return new InvokeSerializationConstructorAndInitializeFieldsStrategy(constructor, method, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.ClassInspectionVisitor start(Class<?> type) {
        if (type.isAnnotation() || type.isEnum()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append((CharSequence)" is not a class or interface.");
            throw new ClassGenerationException(formatter.toString());
        }
        return new ClassInspectionVisitorImpl(type, this.decorate, this.suffix, this.factoryId);
    }

    @Nullable
    private static String getBuildServiceName(AbstractClassGenerator.PropertyMetadata property) {
        ServiceReference annotation = property.findAnnotation(ServiceReference.class);
        if (annotation != null) {
            return StringUtils.trimToNull((String)annotation.value());
        }
        return null;
    }

    @Nonnull
    private static String descriptorOf(Class<?> type) {
        return org.objectweb.asm.Type.getType(type).getDescriptor();
    }

    private static String propFieldName(AbstractClassGenerator.PropertyMetadata property) {
        return AsmBackedClassGenerator.propFieldName(property.getName());
    }

    public static String propFieldName(String name) {
        return "__" + name + "__";
    }

    private static Class<?> rawTypeParam(AbstractClassGenerator.PropertyMetadata property, int paramNum) {
        Type type = property.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Declaration of property " + property.getName() + " does not include any type arguments in its property type " + type);
        }
        Type argument = ((ParameterizedType)type).getActualTypeArguments()[paramNum];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        return (Class)((ParameterizedType)argument).getRawType();
    }

    private static class InvokeSerializationConstructorAndInitializeFieldsStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final PropertyRoleAnnotationHandler roleHandler;
        private final Constructor<?> constructor;
        private final Method initMethod;

        public InvokeSerializationConstructorAndInitializeFieldsStrategy(Constructor<?> constructor, Method initMethod, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.initMethod = initMethod;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object instance = this.constructor.newInstance(new Object[0]);
                this.initMethod.invoke(instance, new Object[0]);
                Object obj = instance;
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class InvokeConstructorStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final Constructor<?> constructor;
        private final PropertyRoleAnnotationHandler roleHandler;

        public InvokeConstructorStrategy(Constructor<?> constructor, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object obj = this.constructor.newInstance(params);
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class NoOpBuilder
    implements AbstractClassGenerator.ClassGenerationVisitor {
        private final Class<?> type;

        public NoOpBuilder(Class<?> type) {
            this.type = type;
        }

        @Override
        public void addConstructor(Constructor<?> constructor, boolean addNameParameter) {
        }

        @Override
        public void addDefaultConstructor() {
        }

        @Override
        public void addNameConstructor() {
        }

        @Override
        public void mixInDynamicAware() {
        }

        @Override
        public void mixInConventionAware() {
        }

        @Override
        public void mixInGroovyObject() {
        }

        @Override
        public void addDynamicMethods() {
        }

        @Override
        public void addExtensionsProperty() {
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter, boolean applyRole) {
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void addManagedMethods(List<AbstractClassGenerator.PropertyMetadata> mutableProperties, List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter, boolean attachOwner, boolean applyRole) {
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata propertyMetaData, Method setter) {
        }

        @Override
        public void addActionMethod(Method method) {
        }

        @Override
        public void addPropertySetterOverloads(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void addNameProperty() {
        }

        @Override
        public Class<?> generate() {
            return this.type;
        }
    }

    private static class ObjectCreationDetails {
        final InstanceGenerator instantiator;
        final ServiceLookup services;
        @Nullable
        final Describable displayName;
        PropertyRoleAnnotationHandler roleHandler;

        ObjectCreationDetails(InstanceGenerator instantiator, ServiceLookup services, @Nullable Describable displayName, PropertyRoleAnnotationHandler roleHandler) {
            this.instantiator = instantiator;
            this.services = services;
            this.displayName = displayName;
            this.roleHandler = roleHandler;
        }
    }

    private static class ClassBuilderImpl
    extends ClassVisitorScope
    implements AbstractClassGenerator.ClassGenerationVisitor {
        public static final int PV_FINAL_STATIC = 4122;
        private static final Set<? extends Class<?>> PRIMITIVE_TYPES = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, (Object[])new Class[]{Float.TYPE, Double.TYPE});
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "_gr_dyn_";
        private static final String MAPPING_FIELD = "_gr_map_";
        private static final String META_CLASS_FIELD = "_gr_mc_";
        private static final String SERVICES_FIELD = "_gr_svcs_";
        private static final String NAME_FIELD = "_gr_n_";
        private static final String DISPLAY_NAME_FIELD = "_gr_dn_";
        private static final String OWNER_FIELD = "_gr_owner_";
        private static final String FACTORY_ID_FIELD = "_gr_fid_";
        private static final String FACTORY_FIELD = "_gr_f_";
        private static final String SERVICES_METHOD = "$gradleServices";
        private static final String FACTORY_METHOD = "$gradleFactory";
        private static final String INIT_METHOD = "$gradleInit";
        private static final String CONVENTION_MAPPING_FIELD_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(ConventionMapping.class);
        private static final String META_CLASS_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(MetaClass.class);
        private static final org.objectweb.asm.Type META_CLASS_TYPE = org.objectweb.asm.Type.getType(MetaClass.class);
        private static final org.objectweb.asm.Type GENERATED_SUBCLASS_TYPE = org.objectweb.asm.Type.getType(GeneratedSubclass.class);
        private static final org.objectweb.asm.Type MODEL_OBJECT_TYPE = org.objectweb.asm.Type.getType(ModelObject.class);
        private static final org.objectweb.asm.Type OWNER_AWARE_TYPE = org.objectweb.asm.Type.getType(OwnerAware.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_TYPE = org.objectweb.asm.Type.getType(IConventionAware.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_HELPER_TYPE = org.objectweb.asm.Type.getType(ConventionAwareHelper.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_AWARE_TYPE = org.objectweb.asm.Type.getType(DynamicObjectAware.class);
        private static final org.objectweb.asm.Type EXTENSION_AWARE_TYPE = org.objectweb.asm.Type.getType(ExtensionAware.class);
        private static final org.objectweb.asm.Type HAS_CONVENTION_TYPE = org.objectweb.asm.Type.getType(HasConvention.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(DynamicObject.class);
        private static final org.objectweb.asm.Type CONVENTION_MAPPING_TYPE = org.objectweb.asm.Type.getType(ConventionMapping.class);
        private static final org.objectweb.asm.Type GROOVY_OBJECT_TYPE = org.objectweb.asm.Type.getType(GroovyObject.class);
        private static final org.objectweb.asm.Type CONVENTION_TYPE = org.objectweb.asm.Type.getType(Convention.class);
        private static final org.objectweb.asm.Type ASM_BACKED_CLASS_GENERATOR_TYPE = org.objectweb.asm.Type.getType(AsmBackedClassGenerator.class);
        private static final org.objectweb.asm.Type ABSTRACT_DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(AbstractDynamicObject.class);
        private static final org.objectweb.asm.Type EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(MixInExtensibleDynamicObject.class);
        private static final org.objectweb.asm.Type NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(BeanDynamicObject.class);
        private static final String JAVA_REFLECT_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Type.class);
        private static final org.objectweb.asm.Type CONFIGURE_UTIL_TYPE = org.objectweb.asm.Type.getType(ConfigureUtil.class);
        private static final org.objectweb.asm.Type CLOSURE_TYPE = org.objectweb.asm.Type.getType(Closure.class);
        private static final org.objectweb.asm.Type SERVICE_REGISTRY_TYPE = org.objectweb.asm.Type.getType(ServiceRegistry.class);
        private static final org.objectweb.asm.Type SERVICE_LOOKUP_TYPE = org.objectweb.asm.Type.getType(ServiceLookup.class);
        private static final org.objectweb.asm.Type MANAGED_OBJECT_FACTORY_TYPE = org.objectweb.asm.Type.getType(ManagedObjectFactory.class);
        private static final org.objectweb.asm.Type DEFAULT_PROPERTY_TYPE = org.objectweb.asm.Type.getType(DefaultProperty.class);
        private static final org.objectweb.asm.Type BUILD_SERVICE_PROVIDER_TYPE = org.objectweb.asm.Type.getType((String)"Lorg/gradle/api/services/internal/BuildServiceProvider;");
        private static final org.objectweb.asm.Type JAVA_LANG_REFLECT_TYPE = org.objectweb.asm.Type.getType(Type.class);
        private static final org.objectweb.asm.Type OBJECT_TYPE = org.objectweb.asm.Type.getType(Object.class);
        private static final org.objectweb.asm.Type CLASS_TYPE = org.objectweb.asm.Type.getType(Class.class);
        private static final org.objectweb.asm.Type METHOD_TYPE = org.objectweb.asm.Type.getType(Method.class);
        private static final org.objectweb.asm.Type STRING_TYPE = org.objectweb.asm.Type.getType(String.class);
        private static final org.objectweb.asm.Type CLASS_ARRAY_TYPE = org.objectweb.asm.Type.getType(Class[].class);
        private static final org.objectweb.asm.Type GROOVY_SYSTEM_TYPE = org.objectweb.asm.Type.getType(GroovySystem.class);
        private static final org.objectweb.asm.Type META_CLASS_REGISTRY_TYPE = org.objectweb.asm.Type.getType(MetaClassRegistry.class);
        private static final org.objectweb.asm.Type OBJECT_ARRAY_TYPE = org.objectweb.asm.Type.getType(Object[].class);
        private static final org.objectweb.asm.Type ACTION_TYPE = org.objectweb.asm.Type.getType(Action.class);
        private static final org.objectweb.asm.Type PROPERTY_INTERNAL_TYPE = org.objectweb.asm.Type.getType(PropertyInternal.class);
        private static final org.objectweb.asm.Type MANAGED_TYPE = org.objectweb.asm.Type.getType(Managed.class);
        private static final org.objectweb.asm.Type EXTENSION_CONTAINER_TYPE = org.objectweb.asm.Type.getType(ExtensionContainer.class);
        private static final org.objectweb.asm.Type DESCRIBABLE_TYPE = org.objectweb.asm.Type.getType(Describable.class);
        private static final org.objectweb.asm.Type DISPLAY_NAME_TYPE = org.objectweb.asm.Type.getType(DisplayName.class);
        private static final org.objectweb.asm.Type INJECT_TYPE = org.objectweb.asm.Type.getType(Inject.class);
        private static final String RETURN_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)STRING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_DESCRIBABLE = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DESCRIBABLE_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, CLASS_TYPE, DYNAMIC_OBJECT_TYPE, SERVICE_LOOKUP_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, STRING_TYPE, org.objectweb.asm.Type.BOOLEAN_TYPE});
        private static final String RETURN_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CONVENTION_AWARE_TYPE, CONVENTION_TYPE});
        private static final String RETURN_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_CONVENTION_MAPPING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_EXTENSION_CONTAINER = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)EXTENSION_CONTAINER_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_DYNAMIC_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DYNAMIC_OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_BOOLEAN_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_META_CLASS_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_LOOKUP_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_MANAGED_OBJECT_FACTORY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)MANAGED_OBJECT_FACTORY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{META_CLASS_TYPE});
        private static final String GET_DECLARED_METHOD_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)METHOD_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, CLASS_ARRAY_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_MODEL_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_DEFAULT_PROPERTY_SERVICE_LOOKUP_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{DEFAULT_PROPERTY_TYPE, SERVICE_LOOKUP_TYPE, STRING_TYPE});
        private static final String RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, DISPLAY_NAME_TYPE});
        private static final String RETURN_OBJECT_FROM_TYPE = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE});
        private static final String RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE, STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_VOID_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String[] EMPTY_STRINGS = new String[0];
        private static final org.objectweb.asm.Type[] EMPTY_TYPES = new org.objectweb.asm.Type[0];
        private final Class<?> type;
        private final boolean managed;
        private final org.objectweb.asm.Type generatedType;
        private final org.objectweb.asm.Type superclassType;
        private final Map<Type, ReturnTypeEntry> genericReturnTypeConstantsIndex = Maps.newHashMap();
        private final AsmClassGenerator classGenerator;
        private final int factoryId;
        private boolean hasMappingField;
        private final boolean conventionAware;
        private final boolean mixInDsl;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;
        private final boolean requiresToString;
        private final List<AttachedProperty> propertiesToAttach;
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties;
        private final boolean requiresServicesMethod;
        private final boolean requiresFactory;

        private ClassBuilderImpl(AsmClassGenerator classGenerator, boolean decorated, int factoryId, boolean extensible, boolean conventionAware, boolean managed, boolean providesOwnDynamicObject, boolean requiresToString, boolean requiresServicesMethod, boolean requiresFactory, List<AttachedProperty> propertiesToAttach, List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties) {
            super((ClassVisitor)classGenerator.getVisitor());
            this.classGenerator = classGenerator;
            this.type = classGenerator.getTargetType();
            this.generatedType = classGenerator.getGeneratedType();
            this.factoryId = factoryId;
            this.managed = managed;
            this.requiresToString = requiresToString;
            this.propertiesToAttach = propertiesToAttach;
            this.superclassType = org.objectweb.asm.Type.getType(this.type);
            this.mixInDsl = decorated;
            this.extensible = extensible;
            this.conventionAware = conventionAware;
            this.providesOwnDynamicObject = providesOwnDynamicObject;
            this.requiresServicesMethod = requiresServicesMethod;
            this.requiresFactory = requiresFactory;
            this.ineligibleProperties = ineligibleProperties;
        }

        public void startClass() {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            org.objectweb.asm.Type superclass = this.superclassType;
            if (this.type.isInterface()) {
                interfaceTypes.add(this.superclassType.getInternalName());
                superclass = OBJECT_TYPE;
            }
            interfaceTypes.add(GENERATED_SUBCLASS_TYPE.getInternalName());
            interfaceTypes.add(MODEL_OBJECT_TYPE.getInternalName());
            interfaceTypes.add(OWNER_AWARE_TYPE.getInternalName());
            if (this.conventionAware) {
                interfaceTypes.add(CONVENTION_AWARE_TYPE.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(EXTENSION_AWARE_TYPE.getInternalName());
                interfaceTypes.add(HAS_CONVENTION_TYPE.getInternalName());
            }
            if (this.mixInDsl) {
                interfaceTypes.add(DYNAMIC_OBJECT_AWARE_TYPE.getInternalName());
                interfaceTypes.add(GROOVY_OBJECT_TYPE.getInternalName());
            }
            if (this.managed) {
                interfaceTypes.add(MANAGED_TYPE.getInternalName());
            }
            this.includeNotInheritedAnnotations();
            this.visit(52, 4097, this.generatedType.getInternalName(), null, superclass.getInternalName(), interfaceTypes.toArray(EMPTY_STRINGS));
            this.generateInitMethod();
            this.generateGeneratedSubtypeMethods();
            this.generateModelObjectMethods();
            if (this.requiresToString) {
                this.generateToStringSupport();
            }
            if (this.requiresServicesMethod) {
                this.generateServiceRegistrySupport();
            }
            if (this.requiresFactory) {
                this.generateManagedPropertyCreationSupport();
            }
        }

        @Override
        public void addDefaultConstructor() {
            this.publicMethod("<init>", RETURN_VOID, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "<init>", RETURN_VOID);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addNameConstructor() {
            this.publicMethod("<init>", RETURN_VOID_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.visitAnnotation(INJECT_TYPE.getDescriptor(), true).visitEnd();
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "<init>", RETURN_VOID);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addConstructor(final Constructor<?> constructor, final boolean addNameParameter) {
            String methodDescriptor;
            final List<org.objectweb.asm.Type> paramTypes = this.paramTypesOf(constructor, addNameParameter);
            final String superMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(EMPTY_TYPES));
            if (addNameParameter) {
                paramTypes.add(0, STRING_TYPE);
                methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(EMPTY_TYPES));
            } else {
                methodDescriptor = superMethodDescriptor;
            }
            this.publicMethod("<init>", methodDescriptor, AsmClassGeneratorUtils.signature(constructor, addNameParameter), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    int stackVar;
                    super(methodVisitor);
                    this.visitDeclaredAnnotationsOf(constructor, this.mv);
                    this._ALOAD(0);
                    int n = stackVar = addNameParameter ? 2 : 1;
                    for (int typeVar = addNameParameter ? 1 : 0; typeVar < paramTypes.size(); ++typeVar) {
                        org.objectweb.asm.Type argType = (org.objectweb.asm.Type)paramTypes.get(typeVar);
                        this._ILOAD_OF(argType, stackVar);
                        stackVar += argType.getSize();
                    }
                    this._INVOKESPECIAL(superclassType, "<init>", superMethodDescriptor);
                    if (addNameParameter) {
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                    }
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Nonnull
        private List<org.objectweb.asm.Type> paramTypesOf(Constructor<?> constructor, boolean addNameParameter) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            ArrayList<org.objectweb.asm.Type> paramTypes = new ArrayList<org.objectweb.asm.Type>(parameterTypes.length + (addNameParameter ? 1 : 0));
            for (Class<?> paramType : parameterTypes) {
                paramTypes.add(org.objectweb.asm.Type.getType(paramType));
            }
            return paramTypes;
        }

        private void visitDeclaredAnnotationsOf(Constructor<?> constructor, MethodVisitor methodVisitor) {
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotationType.getAnnotation(Retention.class);
                methodVisitor.visitAnnotation(AsmBackedClassGenerator.descriptorOf(annotationType), retention != null && retention.value() == RetentionPolicy.RUNTIME).visitEnd();
            }
        }

        private void generateInitMethod() {
            this.privateSyntheticMethod(INIT_METHOD, RETURN_VOID, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    if (requiresServicesMethod) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.SERVICES_FIELD, SERVICE_LOOKUP_TYPE);
                    }
                    if (requiresFactory) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE);
                    }
                    for (AttachedProperty entry : propertiesToAttach) {
                        AbstractClassGenerator.PropertyMetadata property = entry.property;
                        boolean applyRole = entry.applyRole;
                        AbstractClassGenerator.MethodMetadata getter = property.getMainGetter();
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(generatedType, getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                        if (applyRole) {
                            this._DUP();
                        }
                        this._ALOAD(0);
                        this._LDC(property.getName());
                        this._INVOKESTATIC(MANAGED_OBJECT_FACTORY_TYPE, "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING);
                        if (!applyRole) continue;
                        this.applyRole();
                    }
                    if (conventionAware && IConventionAware.class.isAssignableFrom(type)) {
                        for (AbstractClassGenerator.PropertyMetadata property : ineligibleProperties) {
                            this._ALOAD(0);
                            this._INVOKEVIRTUAL(generatedType, "getConventionMapping", RETURN_CONVENTION_MAPPING);
                            this._LDC(property.getName());
                            this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "ineligible", RETURN_VOID_FROM_STRING);
                        }
                    }
                    this._RETURN();
                }
            });
        }

        @Override
        public void addExtensionsProperty() {
            this.addGetter("getExtensions", EXTENSION_CONTAINER_TYPE, RETURN_EXTENSION_CONTAINER, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getConvention", RETURN_CONVENTION);
                }
            });
        }

        @Override
        public void mixInDynamicAware() {
            if (!this.mixInDsl) {
                return;
            }
            this.addField(130, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE);
            if (this.extensible) {
                this.addGetter("getConvention", CONVENTION_TYPE, RETURN_CONVENTION, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                        this._CHECKCAST(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._INVOKEVIRTUAL(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "getConvention", RETURN_CONVENTION);
                    }
                });
            }
            this.addLazyGetter("getAsDynamicObject", DYNAMIC_OBJECT_TYPE, RETURN_DYNAMIC_OBJECT, null, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (extensible) {
                        this._NEW(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._DUP();
                        this._ALOAD(0);
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(generatedType, "getClass", RETURN_CLASS);
                        this._INVOKEVIRTUAL(CLASS_TYPE, "getSuperclass", RETURN_CLASS);
                        if (providesOwnDynamicObject) {
                            this._ALOAD(0);
                            this._INVOKESPECIAL(org.objectweb.asm.Type.getType((Class)type), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                        } else {
                            this._ACONST_NULL();
                        }
                        this.putServiceRegistryOnStack();
                        this._INVOKESPECIAL(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "<init>", RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP);
                    } else {
                        this._NEW(NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._DUP();
                        this._ALOAD(0);
                        this._INVOKESPECIAL(NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "<init>", RETURN_VOID_FROM_OBJECT);
                    }
                }
            });
        }

        @Override
        public void mixInConventionAware() {
            this.addField(130, MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
            this.hasMappingField = true;
            this.addLazyGetter("getConventionMapping", CONVENTION_MAPPING_TYPE, RETURN_CONVENTION_MAPPING, null, MAPPING_FIELD, CONVENTION_MAPPING_TYPE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._NEW(CONVENTION_AWARE_HELPER_TYPE);
                    this._DUP();
                    this._ALOAD(0);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getConvention", RETURN_CONVENTION);
                    this._INVOKESPECIAL(CONVENTION_AWARE_HELPER_TYPE, "<init>", RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION);
                    for (AbstractClassGenerator.PropertyMetadata property : ineligibleProperties) {
                        this._DUP();
                        this._LDC(property.getName());
                        this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "ineligible", RETURN_VOID_FROM_STRING);
                    }
                }
            });
        }

        @Override
        public void mixInGroovyObject() {
            if (!this.mixInDsl) {
                return;
            }
            this.addField(130, META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
            this.addLazyGetter("getMetaClass", META_CLASS_TYPE, RETURN_META_CLASS, null, META_CLASS_FIELD, META_CLASS_TYPE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._INVOKESTATIC(GROOVY_SYSTEM_TYPE, "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(OBJECT_TYPE, "getClass", RETURN_CLASS);
                    this._INVOKEINTERFACE(META_CLASS_REGISTRY_TYPE, "getMetaClass", RETURN_META_CLASS_FROM_CLASS);
                }
            });
            this.addSetter("setMetaClass", RETURN_VOID_FROM_META_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
                }
            });
        }

        private void addSetter(String methodName, String methodDescriptor, BytecodeFragment body) {
            this.addSetter(methodName, methodDescriptor, null, body);
        }

        private void addSetter(String methodName, String methodDescriptor, String signature, final BytecodeFragment body) {
            this.publicMethod(methodName, methodDescriptor, signature, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.emit(body);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addPropertySetterOverloads(AbstractClassGenerator.PropertyMetadata property, final AbstractClassGenerator.MethodMetadata getter) {
            if (!this.mixInDsl) {
                return;
            }
            this.addSetter(MetaProperty.getSetterName((String)property.getName()), RETURN_VOID_FROM_OBJECT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                    this._CHECKCAST(PROPERTY_INTERNAL_TYPE);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(PROPERTY_INTERNAL_TYPE, "setFromAnyValue", RETURN_VOID_FROM_OBJECT);
                }
            });
        }

        private void addLazyGetter(String methodName, org.objectweb.asm.Type returnType, String methodDescriptor, @Nullable String signature, final String fieldName, final org.objectweb.asm.Type fieldType, final BytecodeFragment initializer) {
            this.addGetter(methodName, returnType, methodDescriptor, signature, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, fieldName, fieldType);
                    this._ASTORE(1);
                    this._ALOAD(1);
                    Label returnValue = new Label();
                    this._IFNONNULL(returnValue);
                    this.emit(initializer);
                    this._ASTORE(1);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, fieldName, fieldType);
                    this.visitLabel(returnValue);
                    this._ALOAD(1);
                }
            });
        }

        @Override
        public void addDynamicMethods() {
            if (!this.mixInDsl) {
                return;
            }
            this.addGetter("getProperty", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "getProperty", RETURN_OBJECT_FROM_STRING);
                }
            });
            this.publicMethod("hasProperty", RETURN_BOOLEAN_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "hasProperty", RETURN_BOOLEAN_FROM_STRING);
                    this._IRETURN();
                }
            });
            this.addSetter("setProperty", RETURN_VOID_FROM_STRING_OBJECT, setter -> new MethodVisitorScope(setter){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._ALOAD(2);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "setProperty", RETURN_VOID_FROM_STRING_OBJECT);
                }
            });
            this.addGetter("invokeMethod", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING_OBJECT, getter -> new MethodVisitorScope(getter){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    Label end = new Label();
                    Label notArray = new Label();
                    this._ALOAD(2);
                    this._INSTANCEOF(OBJECT_ARRAY_TYPE);
                    this._IFEQ(notArray);
                    this._ALOAD(2);
                    this._CHECKCAST(OBJECT_ARRAY_TYPE);
                    this._GOTO(end);
                    this.visitLabel(notArray);
                    this._ICONST_1();
                    this._ANEWARRAY(OBJECT_TYPE);
                    this._DUP();
                    this._ICONST_0();
                    this._ALOAD(2);
                    this._AASTORE();
                    this.visitLabel(end);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "invokeMethod", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_ARRAY_TYPE}));
                }
            });
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
            this.addField(130, AsmBackedClassGenerator.propFieldName(property), property.getType());
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
            this.applyServiceInjectionToGetter(property, null, getter);
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, final @Nullable Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
            final String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            final org.objectweb.asm.Type serviceType = org.objectweb.asm.Type.getType(property.getType());
            final Type genericServiceType = property.getGenericType();
            String propFieldName = AsmBackedClassGenerator.propFieldName(property);
            String signature = AsmClassGeneratorUtils.getterSignature(getter.getGenericReturnType());
            this.addLazyGetter(getterName, returnType, methodDescriptor, signature, propFieldName, serviceType, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.putServiceRegistryOnStack();
                    if (genericServiceType instanceof Class) {
                        this._LDC(org.objectweb.asm.Type.getType((Class)((Class)genericServiceType)));
                    } else {
                        String constantFieldName = this.getConstantNameForGenericReturnType(genericServiceType, getterName);
                        this._GETSTATIC(generatedType, constantFieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                    }
                    if (annotation == null) {
                        this._INVOKEINTERFACE(SERVICE_LOOKUP_TYPE, "get", RETURN_OBJECT_FROM_TYPE);
                    } else {
                        this._LDC(org.objectweb.asm.Type.getType((Class)annotation));
                        this._INVOKEINTERFACE(SERVICE_LOOKUP_TYPE, "get", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE, CLASS_TYPE}));
                    }
                    this._CHECKCAST(serviceType);
                }
            });
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
            this.applyServiceInjectionToSetter(property, setter);
        }

        private String getConstantNameForGenericReturnType(Type genericReturnType, String getterName) {
            ReturnTypeEntry entry = this.genericReturnTypeConstantsIndex.get(genericReturnType);
            if (entry == null) {
                String fieldName = "_GENERIC_RETURN_TYPE_" + this.genericReturnTypeConstantsIndex.size();
                entry = new ReturnTypeEntry(fieldName, getterName);
                this.genericReturnTypeConstantsIndex.put(genericReturnType, entry);
            }
            return entry.fieldName;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
            this.addField(2, AsmBackedClassGenerator.propFieldName(property), property.getType());
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(final AbstractClassGenerator.PropertyMetadata property, Method getter, final boolean applyRole) {
            final org.objectweb.asm.Type propType = org.objectweb.asm.Type.getType(property.getType());
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String descriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            String fieldName = AsmBackedClassGenerator.propFieldName(property);
            this.addLazyGetter(getter.getName(), returnType, descriptor, null, fieldName, propType, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    String buildServiceName;
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY);
                    this._ALOAD(0);
                    this._LDC(property.getName());
                    switch (property.getType().getTypeParameters().length) {
                        case 1: {
                            org.objectweb.asm.Type elementType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 0));
                            this._LDC(propType);
                            this._LDC(elementType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS);
                            break;
                        }
                        case 2: {
                            org.objectweb.asm.Type keyType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 0));
                            org.objectweb.asm.Type valueType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 1));
                            this._LDC(propType);
                            this._LDC(keyType);
                            this._LDC(valueType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS);
                            break;
                        }
                        default: {
                            this._LDC(propType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS);
                        }
                    }
                    if (applyRole) {
                        this._DUP();
                        this.applyRole();
                    }
                    if ((buildServiceName = AsmBackedClassGenerator.getBuildServiceName(property)) != null) {
                        this._DUP();
                        this.setBuildServiceConvention(buildServiceName);
                    }
                    this._CHECKCAST(propType);
                }
            });
        }

        @Override
        public void applyManagedStateToGetter(final AbstractClassGenerator.PropertyMetadata property, Method getter) {
            final org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            this.addGetter(getter.getName(), returnType, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property), returnType);
                }
            });
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        private void addSetterForProperty(final AbstractClassGenerator.PropertyMetadata property, Method setter) {
            final org.objectweb.asm.Type fieldType = org.objectweb.asm.Type.getType(property.getType());
            this.addSetter(setter.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)setter), AsmClassGeneratorUtils.signature(setter), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(fieldType, 1);
                    this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property), fieldType);
                }
            });
        }

        private void generateGeneratedSubtypeMethods() {
            this.publicMethod("publicType", RETURN_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(superclassType);
                    this._ARETURN();
                }
            });
            this.addMethod(9, "generatedFrom", RETURN_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(superclassType);
                    this._ARETURN();
                }
            });
        }

        private void generateModelObjectMethods() {
            this.addField(4098, DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
            this.addField(4098, OWNER_FIELD, MODEL_OBJECT_TYPE);
            this.publicMethod("hasUsefulDisplayName", RETURN_BOOLEAN, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (requiresToString) {
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                        Label label = new Label();
                        this._IFNULL(label);
                        this._LDC(true);
                        this._IRETURN_OF(org.objectweb.asm.Type.BOOLEAN_TYPE);
                        this.visitLabel(label);
                        this._LDC(false);
                        this._IRETURN_OF(org.objectweb.asm.Type.BOOLEAN_TYPE);
                    } else {
                        this._LDC(true);
                        this._IRETURN_OF(org.objectweb.asm.Type.BOOLEAN_TYPE);
                    }
                }
            });
            this.publicMethod("getModelIdentityDisplayName", RETURN_DESCRIBABLE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._ARETURN();
                }
            });
            this.publicMethod("getTaskThatOwnsThisObject", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Task.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (Task.class.isAssignableFrom(type)) {
                        this._ALOAD(0);
                    } else {
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, ClassBuilderImpl.OWNER_FIELD, MODEL_OBJECT_TYPE);
                        this._DUP();
                        Label useNull = new Label();
                        this._IFNULL(useNull);
                        this._INVOKEINTERFACE(MODEL_OBJECT_TYPE, "getTaskThatOwnsThisObject", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Task.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                        this.visitLabel(useNull);
                    }
                    this._ARETURN();
                }
            });
            this.publicMethod("attachOwner", RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.OWNER_FIELD, MODEL_OBJECT_TYPE);
                    this._ALOAD(0);
                    this._ALOAD(2);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addManagedMethods(final List<AbstractClassGenerator.PropertyMetadata> mutableProperties, final List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
            this.addField(10, FACTORY_ID_FIELD, org.objectweb.asm.Type.INT_TYPE);
            final int mutablePropertySize = mutableProperties.size();
            final int readOnlyPropertySize = readOnlyProperties.size();
            this.addMethod(4097, "initFromState", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_ARRAY_TYPE}), methodVisitor -> new MethodVisitorScope(methodVisitor){
                int propertyIndex;
                {
                    super(methodVisitor);
                    this.loadPropertiesFromState(mutableProperties);
                    this.loadPropertiesFromState(readOnlyProperties);
                    this._RETURN();
                    this.propertyIndex = 0;
                }

                private void loadPropertiesFromState(List<AbstractClassGenerator.PropertyMetadata> properties) {
                    for (AbstractClassGenerator.PropertyMetadata property : properties) {
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._LDC(this.propertyIndex);
                        this._AALOAD();
                        org.objectweb.asm.Type propertyType = org.objectweb.asm.Type.getType(property.getType());
                        this._UNBOX(propertyType);
                        this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property), propertyType);
                        ++this.propertyIndex;
                    }
                }
            });
            this.publicMethod("isImmutable", RETURN_BOOLEAN, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(mutablePropertySize == 0 && readOnlyPropertySize == 0);
                    this._IRETURN();
                }
            });
            this.publicMethod("unpackState", RETURN_OBJECT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    org.objectweb.asm.Type propertyType;
                    super(methodVisitor);
                    this._LDC(mutablePropertySize + readOnlyPropertySize);
                    this._ANEWARRAY(OBJECT_TYPE);
                    int propertyIndex = 0;
                    for (AbstractClassGenerator.PropertyMetadata property : mutableProperties) {
                        String propFieldName = AsmBackedClassGenerator.propFieldName(property);
                        this._DUP();
                        this._LDC(propertyIndex);
                        this._ALOAD(0);
                        propertyType = org.objectweb.asm.Type.getType(property.getType());
                        this._GETFIELD(generatedType, propFieldName, propertyType);
                        this._AUTOBOX(property.getType(), propertyType);
                        this._AASTORE();
                        ++propertyIndex;
                    }
                    for (AbstractClassGenerator.PropertyMetadata property : readOnlyProperties) {
                        this._DUP();
                        this._LDC(propertyIndex);
                        this._ALOAD(0);
                        AbstractClassGenerator.MethodMetadata getter = property.getMainGetter();
                        this._INVOKEVIRTUAL(generatedType, getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                        propertyType = org.objectweb.asm.Type.getType(property.getType());
                        this._AUTOBOX(property.getType(), propertyType);
                        this._AASTORE();
                        ++propertyIndex;
                    }
                    this._ARETURN();
                }
            });
            this.publicMethod("getFactoryId", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.INT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._GETSTATIC(generatedType, ClassBuilderImpl.FACTORY_ID_FIELD, org.objectweb.asm.Type.INT_TYPE);
                    this._IRETURN();
                }
            });
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
            if (!this.conventionAware) {
                return;
            }
            this.addField(130, AsmBackedClassGenerator.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE);
        }

        @Override
        public void applyConventionMappingToGetter(final AbstractClassGenerator.PropertyMetadata property, final AbstractClassGenerator.MethodMetadata getter, final boolean attachOwner, final boolean applyRole) {
            if (!this.conventionAware && !attachOwner) {
                return;
            }
            final String getterName = getter.getName();
            final org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            final String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            this.publicMethod(getterName, methodDescriptor, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (conventionAware) {
                        Label finish = new Label();
                        if (hasMappingField) {
                            this._ALOAD(0);
                            this._GETFIELD(generatedType, ClassBuilderImpl.MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
                            Label useConvention = new Label();
                            this._IFNONNULL(useConvention);
                            this._ALOAD(0);
                            this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                            this._GOTO(finish);
                            this.visitLabel(useConvention);
                        }
                        this._ALOAD(0);
                        this._INVOKEINTERFACE(CONVENTION_AWARE_TYPE, "getConventionMapping", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                        this._ALOAD(0);
                        this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                        this._AUTOBOX(getter.getReturnType(), returnType);
                        this._LDC(property.getName());
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE);
                        this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "getConventionValue", RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN);
                        this._UNBOX(returnType);
                        this.visitLabel(finish);
                    } else {
                        this._ALOAD(0);
                        this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                    }
                    if (attachOwner) {
                        this._DUP();
                        this._ALOAD(0);
                        this._LDC(property.getName());
                        this._INVOKESTATIC(MANAGED_OBJECT_FACTORY_TYPE, "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING);
                        this._POP();
                        if (applyRole) {
                            this._DUP();
                            this.applyRole();
                        }
                    }
                    this._IRETURN_OF(returnType);
                }
            });
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata property, final Method setter) {
            if (!this.mixInDsl) {
                return;
            }
            final org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            final String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            this.addSetter(property.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType}), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(paramType, 1);
                    this._INVOKEVIRTUAL(generatedType, setter.getName(), setterDescriptor);
                }
            });
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.conventionAware) {
                return;
            }
            this.addConventionSetter(setter, property);
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.mixInDsl || !this.conventionAware) {
                return;
            }
            this.addConventionSetter(setter, property);
        }

        private void addConventionSetter(final Method setter, final AbstractClassGenerator.PropertyMetadata property) {
            final org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            final org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            final String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            this.publicMethod(setter.getName(), methodDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(paramType, 1);
                    this._INVOKESPECIAL(superclassType, setter.getName(), methodDescriptor);
                    this._ALOAD(0);
                    this._LDC(true);
                    this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE);
                    this._IRETURN_OF(returnType);
                }
            });
        }

        @Override
        public void addActionMethod(final Method method) {
            if (!this.mixInDsl) {
                return;
            }
            final org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            final org.objectweb.asm.Type[] originalParameterTypes = (org.objectweb.asm.Type[])CollectionUtils.collectArray((Object[])method.getParameterTypes(), org.objectweb.asm.Type.class, org.objectweb.asm.Type::getType);
            final int numParams = originalParameterTypes.length;
            final org.objectweb.asm.Type[] closurisedParameterTypes = new org.objectweb.asm.Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = CLOSURE_TYPE;
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])closurisedParameterTypes);
            this.publicMethod(method.getName(), methodDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    int stackVar = 1;
                    for (int typeVar = 0; typeVar < numParams - 1; ++typeVar) {
                        org.objectweb.asm.Type argType = closurisedParameterTypes[typeVar];
                        this._ILOAD_OF(argType, stackVar);
                        stackVar += argType.getSize();
                    }
                    this._ALOAD(stackVar);
                    this._INVOKESTATIC(CONFIGURE_UTIL_TYPE, "configureUsing", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)ACTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLOSURE_TYPE}));
                    this._INVOKEVIRTUAL(generatedType, method.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(method.getReturnType()), (org.objectweb.asm.Type[])originalParameterTypes));
                    this._IRETURN_OF(returnType);
                }
            });
        }

        private void generateToStringSupport() {
            this.publicMethod("toString", RETURN_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._DUP();
                    Label label1 = new Label();
                    this._IFNULL(label1);
                    this._INVOKEINTERFACE(DESCRIBABLE_TYPE, "getDisplayName", RETURN_STRING);
                    this._ARETURN();
                    this.visitLabel(label1);
                    this._ALOAD(0);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE);
                    this._DUP();
                    Label label2 = new Label();
                    this._IFNULL(label2);
                    this._INVOKEINTERFACE(DESCRIBABLE_TYPE, "getDisplayName", RETURN_STRING);
                    this._ARETURN();
                    this.visitLabel(label2);
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "toString", RETURN_STRING);
                    this._ARETURN();
                }
            });
        }

        private void generateServiceRegistrySupport() {
            this.addServiceSupport(SERVICES_FIELD, SERVICE_LOOKUP_TYPE, SERVICES_METHOD, AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP);
        }

        private void generateManagedPropertyCreationSupport() {
            this.addServiceSupport(FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE, FACTORY_METHOD, AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY);
        }

        private void addServiceSupport(String fieldName, org.objectweb.asm.Type fieldType, String getterName, String runtimeGetterName, String getterDescriptor) {
            this.addField(4226, fieldName, fieldType);
            this.addServiceGetter(getterName, fieldName, fieldType, runtimeGetterName, getterDescriptor);
        }

        private void includeNotInheritedAnnotations() {
            for (Annotation annotation : this.type.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                boolean visible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
                AnnotationVisitor annotationVisitor = this.visitAnnotation(AsmBackedClassGenerator.descriptorOf(annotation.annotationType()), visible);
                this.visitAnnotationValues(annotation, annotationVisitor);
                annotationVisitor.visitEnd();
            }
        }

        private void visitAnnotationValues(Annotation annotation, AnnotationVisitor annotationVisitor) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (returnType.isEnum()) {
                    annotationVisitor.visitEnum(name, AsmBackedClassGenerator.descriptorOf(returnType), this.getAnnotationParameterValue(annotation, method).toString());
                    continue;
                }
                if (returnType.isArray() && !PRIMITIVE_TYPES.contains(returnType.getComponentType())) {
                    AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                    Object[] elements = (Object[])this.getAnnotationParameterValue(annotation, method);
                    this.visitArrayElements(arrayVisitor, returnType.getComponentType(), elements);
                    arrayVisitor.visitEnd();
                    continue;
                }
                if (returnType.equals(Class.class)) {
                    Class clazz = (Class)this.getAnnotationParameterValue(annotation, method);
                    annotationVisitor.visit(name, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                    continue;
                }
                if (returnType.isAnnotation()) {
                    Annotation nestedAnnotation = (Annotation)this.getAnnotationParameterValue(annotation, method);
                    AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(name, AsmBackedClassGenerator.descriptorOf(returnType));
                    this.visitAnnotationValues(nestedAnnotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                    continue;
                }
                annotationVisitor.visit(name, this.getAnnotationParameterValue(annotation, method));
            }
        }

        private void visitArrayElements(AnnotationVisitor arrayVisitor, Class<?> arrayElementType, Object[] arrayElements) {
            if (arrayElementType.isEnum()) {
                String enumDescriptor = AsmBackedClassGenerator.descriptorOf(arrayElementType);
                for (Object value : arrayElements) {
                    arrayVisitor.visitEnum(null, enumDescriptor, value.toString());
                }
            } else if (arrayElementType.equals(Class.class)) {
                for (Object value : arrayElements) {
                    Class clazz = (Class)value;
                    arrayVisitor.visit(null, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                }
            } else if (arrayElementType.isAnnotation()) {
                for (Object annotation : arrayElements) {
                    AnnotationVisitor nestedAnnotationVisitor = arrayVisitor.visitAnnotation(null, AsmBackedClassGenerator.descriptorOf(arrayElementType));
                    this.visitAnnotationValues((Annotation)annotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                }
            } else {
                for (Object value : arrayElements) {
                    arrayVisitor.visit(null, value);
                }
            }
        }

        private Object getAnnotationParameterValue(Annotation annotation, Method method) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private void attachFactoryIdToImplType(Class<?> implClass, int id) {
            try {
                Field factoryField = implClass.getDeclaredField(FACTORY_ID_FIELD);
                factoryField.setAccessible(true);
                factoryField.set(null, id);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public void addNameProperty() {
            this.addField(4114, NAME_FIELD, STRING_TYPE);
            this.addGetter("getName", STRING_TYPE, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)STRING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                }
            });
        }

        @Override
        public Class<?> generate() {
            this.writeGenericReturnTypeFields();
            this.visitEnd();
            Class generatedClass = this.classGenerator.define();
            if (this.managed) {
                this.attachFactoryIdToImplType(generatedClass, this.factoryId);
            }
            return generatedClass;
        }

        private void writeGenericReturnTypeFields() {
            if (!this.genericReturnTypeConstantsIndex.isEmpty()) {
                this.addMethod(8, "<clinit>", "()V", methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        for (Map.Entry entry : genericReturnTypeConstantsIndex.entrySet()) {
                            ReturnTypeEntry returnType = (ReturnTypeEntry)entry.getValue();
                            this.addField(4122, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                            this._LDC(generatedType);
                            this._LDC(returnType.getterName);
                            this._ICONST_0();
                            this._ANEWARRAY(CLASS_TYPE);
                            this._INVOKEVIRTUAL(CLASS_TYPE, "getDeclaredMethod", GET_DECLARED_METHOD_DESCRIPTOR);
                            this._INVOKEVIRTUAL(METHOD_TYPE, "getGenericReturnType", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)JAVA_LANG_REFLECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]));
                            this._PUTSTATIC(generatedType, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                        }
                        this._RETURN();
                    }
                });
            }
        }

        private void addServiceGetter(String name, final String fieldName, final org.objectweb.asm.Type fieldType, final String runtimeGetterName, final String getterDescriptor) {
            this.privateSyntheticMethod(name, getterDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, fieldName, fieldType);
                    this._DUP();
                    Label label = new Label();
                    this._IFNULL(label);
                    this._ARETURN();
                    this.visitLabel(label);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, runtimeGetterName, getterDescriptor);
                    this._ARETURN();
                }
            });
        }

        private static final class ReturnTypeEntry {
            private final String fieldName;
            private final String getterName;

            private ReturnTypeEntry(String fieldName, String getterName) {
                this.fieldName = fieldName;
                this.getterName = getterName;
            }
        }

        private class LocalMethodVisitorScope
        extends MethodVisitorScope {
            public LocalMethodVisitorScope(MethodVisitor methodVisitor) {
                super(methodVisitor);
            }

            protected void applyRole() {
                this._ALOAD(0);
                this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, ClassBuilderImpl.FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY);
                this._SWAP();
                this._ALOAD(0);
                this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "applyRole", RETURN_VOID_FROM_OBJECT_MODEL_OBJECT);
            }

            protected void setBuildServiceConvention(String serviceName) {
                this._CHECKCAST(DEFAULT_PROPERTY_TYPE);
                this.putServiceRegistryOnStack();
                this._LDC(serviceName);
                this._INVOKESTATIC(BUILD_SERVICE_PROVIDER_TYPE, "setBuildServiceAsConvention", RETURN_VOID_FROM_DEFAULT_PROPERTY_SERVICE_LOOKUP_STRING);
            }

            protected void putServiceRegistryOnStack() {
                if (ClassBuilderImpl.this.requiresServicesMethod) {
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, ClassBuilderImpl.SERVICES_METHOD, RETURN_SERVICE_LOOKUP);
                } else {
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, "getServices", RETURN_SERVICE_REGISTRY);
                }
            }
        }
    }

    private static class ClassInspectionVisitorImpl
    implements AbstractClassGenerator.ClassInspectionVisitor {
        private final Class<?> type;
        private final boolean decorate;
        private final String suffix;
        private final int factoryId;
        private boolean extensible;
        private boolean serviceInjection;
        private boolean conventionAware;
        private boolean managed;
        private boolean providesOwnDynamicObjectImplementation;
        private boolean providesOwnServicesImplementation;
        private boolean providesOwnToStringImplementation;
        private boolean requiresFactory;
        private final List<AttachedProperty> propertiesToAttach = new ArrayList<AttachedProperty>();
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties = new ArrayList<AbstractClassGenerator.PropertyMetadata>();

        public ClassInspectionVisitorImpl(Class<?> type, boolean decorate, String suffix, int factoryId) {
            this.type = type;
            this.decorate = decorate;
            this.suffix = suffix;
            this.factoryId = factoryId;
        }

        @Override
        public void mixInServiceInjection() {
            this.serviceInjection = true;
        }

        @Override
        public void mixInExtensible() {
            if (this.decorate) {
                this.extensible = true;
            }
        }

        @Override
        public void mixInConventionAware() {
            if (this.decorate) {
                this.conventionAware = true;
            }
        }

        @Override
        public void mixInFullyManagedState() {
            this.managed = true;
        }

        @Override
        public void providesOwnServicesImplementation() {
            this.providesOwnServicesImplementation = true;
        }

        @Override
        public void providesOwnDynamicObjectImplementation() {
            this.providesOwnDynamicObjectImplementation = true;
        }

        @Override
        public void providesOwnToString() {
            this.providesOwnToStringImplementation = true;
        }

        @Override
        public void instantiatesNestedObjects() {
            this.requiresFactory = true;
        }

        @Override
        public void attachDuringConstruction(AbstractClassGenerator.PropertyMetadata property, boolean applyRole) {
            this.propertiesToAttach.add(AttachedProperty.of(property, applyRole));
            if (applyRole) {
                this.requiresFactory = true;
            }
        }

        @Override
        public void markPropertyAsIneligibleForConventionMapping(AbstractClassGenerator.PropertyMetadata property) {
            this.ineligibleProperties.add(property);
        }

        @Override
        public AbstractClassGenerator.ClassGenerationVisitor builder() {
            if (!(this.decorate || this.serviceInjection || Modifier.isAbstract(this.type.getModifiers()))) {
                return new NoOpBuilder(this.type);
            }
            int modifiers = this.type.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is private.");
                throw new ClassGenerationException(formatter.toString());
            }
            if (Modifier.isFinal(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is final.");
                throw new ClassGenerationException(formatter.toString());
            }
            boolean requiresServicesMethod = (this.extensible || this.serviceInjection) && !this.providesOwnServicesImplementation;
            boolean requiresToString = !this.providesOwnToStringImplementation;
            ClassBuilderImpl builder = new ClassBuilderImpl(new AsmClassGenerator(this.type, this.suffix), this.decorate, this.factoryId, this.extensible, this.conventionAware, this.managed, this.providesOwnDynamicObjectImplementation, requiresToString, requiresServicesMethod, this.requiresFactory, this.propertiesToAttach, this.ineligibleProperties);
            builder.startClass();
            return builder;
        }
    }

    private static class AttachedProperty {
        public final AbstractClassGenerator.PropertyMetadata property;
        public final boolean applyRole;

        public static AttachedProperty of(AbstractClassGenerator.PropertyMetadata property, boolean applyRole) {
            return new AttachedProperty(property, applyRole);
        }

        private AttachedProperty(AbstractClassGenerator.PropertyMetadata property, boolean applyRole) {
            this.property = property;
            this.applyRole = applyRole;
        }
    }
}

