/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskRequiredServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.PropertyWalker;

public class DefaultTaskRequiredServices
implements TaskRequiredServices {
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final PropertyWalker propertyWalker;
    @Nullable
    private Set<Provider<? extends BuildService<?>>> registeredServices;
    @Nullable
    private Set<Provider<? extends BuildService<?>>> requiredServices;

    public DefaultTaskRequiredServices(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.propertyWalker = propertyWalker;
    }

    @Override
    public Set<Provider<? extends BuildService<?>>> getElements() {
        if (this.requiredServices == null) {
            this.requiredServices = this.collectRequiredServices();
        }
        return this.requiredServices;
    }

    @Override
    public boolean isServiceRequired(Provider<? extends BuildService<?>> toCheck) {
        return this.getElements().stream().anyMatch(it -> BuildServiceProvider.isSameService(it, toCheck));
    }

    private Set<Provider<? extends BuildService<?>>> collectRequiredServices() {
        Set<Object> registeredServices = this.registeredServices != null ? this.registeredServices : Collections.emptySet();
        LinkedHashSet requiredServices = new LinkedHashSet(registeredServices);
        this.visitServiceReferences(referenceProvider -> requiredServices.add(this.asBuildServiceProvider((Provider<? extends BuildService<?>>)referenceProvider)));
        return requiredServices;
    }

    private Provider<? extends BuildService<?>> asBuildServiceProvider(Provider<? extends BuildService<?>> referenceProvider) {
        if (referenceProvider instanceof DefaultProperty) {
            DefaultProperty asProperty = (DefaultProperty)Cast.uncheckedNonnullCast(referenceProvider);
            return (Provider)Cast.uncheckedNonnullCast((Object)asProperty.getProvider());
        }
        return referenceProvider;
    }

    private void visitServiceReferences(final Consumer<Provider<? extends BuildService<?>>> visitor) {
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new PropertyVisitor(){

            public void visitServiceReference(String propertyName, boolean optional, PropertyValue value, @Nullable String serviceName) {
                visitor.accept((Provider)Cast.uncheckedCast((Object)value.call()));
            }
        });
    }

    @Override
    public void registerServiceUsage(Provider<? extends BuildService<?>> service) {
        this.taskMutator.mutate("Task.usesService(Provider)", () -> {
            if (this.registeredServices == null) {
                this.registeredServices = new HashSet();
            }
            this.registeredServices.add(service);
        });
    }
}

