/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Project.class)
public class ProjectLifecycleController {
    private ProjectInternal project;
    private final StateTransitionController<State> controller;

    public ProjectLifecycleController(DisplayName displayName, StateTransitionControllerFactory factory) {
        this.controller = factory.newController(displayName, State.NotCreated);
    }

    public boolean isCreated() {
        return this.controller.isInStateOrLater(State.Created);
    }

    public void createMutableModel(DefaultProjectDescriptor descriptor, BuildState build, ProjectState owner, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope, IProjectFactory projectFactory) {
        this.controller.transition(State.NotCreated, State.Created, () -> {
            ProjectState parent = owner.getBuildParent();
            ProjectInternal parentModel = parent == null ? null : parent.getMutableModel();
            this.project = projectFactory.createProject(build.getMutableModel(), descriptor, owner, parentModel, selfClassLoaderScope, baseClassLoaderScope);
        });
    }

    public ProjectInternal getMutableModel() {
        this.controller.assertInStateOrLater(State.Created);
        return this.project;
    }

    public void ensureSelfConfigured() {
        this.controller.maybeTransitionIfNotCurrentlyTransitioning(State.Created, State.Configured, () -> this.project.evaluate());
    }

    public void ensureTasksDiscovered() {
        this.ensureSelfConfigured();
        this.project.getTasks().discoverTasks();
        this.project.bindAllModelRules();
    }

    private static enum State implements StateTransitionController.State
    {
        NotCreated,
        Created,
        Configured;

    }
}

