/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.internal.GFileUtils;

public class TarFileTree
extends AbstractArchiveFileTree {
    private final Provider<File> tarFileProvider;
    private final Provider<ReadableResourceInternal> resource;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final File tmpDir;
    private final FileHasher fileHasher;

    public TarFileTree(Provider<File> tarFileProvider, Provider<ReadableResourceInternal> resource, File tmpDir, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher) {
        this.tarFileProvider = tarFileProvider;
        this.resource = resource;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.tmpDir = tmpDir;
        this.fileHasher = fileHasher;
    }

    public String getDisplayName() {
        return String.format("TAR '%s'", ((ReadableResourceInternal)this.resource.get()).getDisplayName());
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(((ReadableResourceInternal)this.resource.get()).read());
        }
        catch (ResourceException e) {
            throw this.cannotExpand((Exception)((Object)e));
        }
        try {
            try {
                Objects.requireNonNull(visitor);
                this.visitImpl(visitor, inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            String message = "Unable to expand " + this.getDisplayName() + "\n  The tar might be corrupted or it is compressed in an unexpected way.\n  By default the tar tree tries to guess the compression based on the file extension.\n  If you need to specify the compression explicitly please refer to the DSL reference.";
            throw new GradleException(message, (Throwable)e);
        }
    }

    private void visitImpl(FileVisitor visitor, InputStream inputStream) throws IOException {
        TarArchiveEntry entry;
        this.checkFormat(inputStream);
        AtomicBoolean stopFlag = new AtomicBoolean();
        NoCloseTarArchiveInputStream tar = new NoCloseTarArchiveInputStream(inputStream);
        File expandedDir = this.getExpandedDir();
        ReadableResourceInternal resource = (ReadableResourceInternal)this.resource.get();
        while (!stopFlag.get() && (entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                visitor.visitDir((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
                continue;
            }
            visitor.visitFile((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
        }
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.tarFileProvider;
    }

    private File getExpandedDir() {
        File tarFile = (File)this.tarFileProvider.get();
        HashCode fileHash = this.hashFile(tarFile);
        String expandedDirName = tarFile.getName() + "_" + fileHash;
        return new File(this.tmpDir, expandedDirName);
    }

    private HashCode hashFile(File tarFile) {
        try {
            return this.fileHasher.hash(tarFile);
        }
        catch (Exception e) {
            throw this.cannotExpand(e);
        }
    }

    private RuntimeException cannotExpand(Exception e) {
        throw new InvalidUserDataException(String.format("Cannot expand %s.", this.getDisplayName()), (Throwable)e);
    }

    private void checkFormat(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("TAR input stream does not support mark/reset.");
        }
        int tarHeaderSize = 512;
        inputStream.mark(tarHeaderSize);
        byte[] tarHeader = new byte[tarHeaderSize];
        int signatureLength = IOUtils.readFully((InputStream)inputStream, (byte[])tarHeader);
        inputStream.reset();
        if (TarArchiveInputStream.matches((byte[])tarHeader, (int)signatureLength)) {
            return;
        }
        if (signatureLength >= tarHeaderSize) {
            try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarHeader));){
                if (tais.getNextTarEntry() == null) {
                    return;
                }
                if (tais.getNextTarEntry().isCheckSumOK()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException("Not a TAR archive");
    }

    private static class NoCloseTarArchiveInputStream
    extends TarArchiveInputStream {
        public NoCloseTarArchiveInputStream(InputStream is) {
            super(is);
        }

        public void close() throws IOException {
        }
    }

    private static class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final TarArchiveEntry entry;
        private final NoCloseTarArchiveInputStream tar;
        private final AtomicBoolean stopFlag;
        private final ReadableResourceInternal resource;
        private final File expandedDir;
        private File file;
        private boolean read;

        public DetailsImpl(ReadableResourceInternal resource, File expandedDir, TarArchiveEntry entry, NoCloseTarArchiveInputStream tar, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.resource = resource;
            this.expandedDir = expandedDir;
            this.entry = entry;
            this.tar = tar;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("tar entry %s!%s", this.resource.getDisplayName(), this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.expandedDir, this.entry.getName());
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                }
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getLastModifiedDate().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            if (this.read && this.file != null) {
                return GFileUtils.openInputStream((File)this.file);
            }
            if (this.read || this.tar.getCurrentEntry() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", new Object[]{this}));
            }
            this.read = true;
            return this.tar;
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        public int getMode() {
            return this.entry.getMode() & 0x1FF;
        }
    }
}

