/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.cache.CacheResourceConfiguration;
import org.gradle.api.cache.Cleanup;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.CleanupInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.GradleUserHomeCacheCleanupActionDecorator;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.cache.MonitoredCleanupAction;

public abstract class DefaultCacheConfigurations
implements CacheConfigurationsInternal {
    private final CacheResourceConfiguration releasedWrappersConfiguration;
    private final CacheResourceConfiguration snapshotWrappersConfiguration;
    private final CacheResourceConfiguration downloadedResourcesConfiguration;
    private final CacheResourceConfiguration createdResourcesConfiguration;
    private final GradleUserHomeCacheCleanupActionDecorator delegate;

    @Inject
    public DefaultCacheConfigurations(ObjectFactory objectFactory, GradleUserHomeDirProvider gradleUserHomeDirProvider) {
        this.releasedWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, 30);
        this.snapshotWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, 7);
        this.downloadedResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, 30);
        this.createdResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, 7);
        this.delegate = new GradleUserHomeCacheCleanupActionDecorator(gradleUserHomeDirProvider);
        this.getCleanup().convention((Object)Cleanup.DEFAULT);
    }

    private static CacheResourceConfiguration createResourceConfiguration(ObjectFactory objectFactory, int defaultDays) {
        CacheResourceConfiguration resourceConfiguration = (CacheResourceConfiguration)objectFactory.newInstance(CacheResourceConfiguration.class, new Object[0]);
        resourceConfiguration.getRemoveUnusedEntriesAfterDays().convention((Object)defaultDays);
        return resourceConfiguration;
    }

    public void releasedWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.releasedWrappersConfiguration);
    }

    public CacheResourceConfiguration getReleasedWrappers() {
        return this.releasedWrappersConfiguration;
    }

    public void snapshotWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.snapshotWrappersConfiguration);
    }

    public CacheResourceConfiguration getSnapshotWrappers() {
        return this.snapshotWrappersConfiguration;
    }

    public void downloadedResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.downloadedResourcesConfiguration);
    }

    public CacheResourceConfiguration getDownloadedResources() {
        return this.downloadedResourcesConfiguration;
    }

    public void createdResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.createdResourcesConfiguration);
    }

    public CacheResourceConfiguration getCreatedResources() {
        return this.createdResourcesConfiguration;
    }

    public Provider<CleanupFrequency> getCleanupFrequency() {
        return this.getCleanup().map(cleanup -> ((CleanupInternal)cleanup).getCleanupFrequency());
    }

    public void finalizeConfigurations() {
        this.releasedWrappersConfiguration.getRemoveUnusedEntriesAfterDays().finalizeValue();
        this.snapshotWrappersConfiguration.getRemoveUnusedEntriesAfterDays().finalizeValue();
        this.downloadedResourcesConfiguration.getRemoveUnusedEntriesAfterDays().finalizeValue();
        this.createdResourcesConfiguration.getRemoveUnusedEntriesAfterDays().finalizeValue();
        this.getCleanup().finalizeValue();
    }

    public MonitoredCleanupAction decorate(MonitoredCleanupAction cleanupAction) {
        final MonitoredCleanupAction decoratedCleanupAction = this.delegate.decorate(cleanupAction);
        return new MonitoredCleanupAction(){

            public boolean execute(CleanupProgressMonitor progressMonitor) {
                return DefaultCacheConfigurations.this.isEnabled() && decoratedCleanupAction.execute(progressMonitor);
            }

            public String getDisplayName() {
                return decoratedCleanupAction.getDisplayName();
            }
        };
    }

    public CleanupAction decorate(CleanupAction cleanupAction) {
        CleanupAction decoratedCleanupAction = this.delegate.decorate(cleanupAction);
        return (cleanableStore, progressMonitor) -> {
            if (this.isEnabled()) {
                decoratedCleanupAction.clean(cleanableStore, progressMonitor);
            }
        };
    }

    private boolean isEnabled() {
        return this.getCleanupFrequency().get() != CleanupFrequency.NEVER;
    }
}

