/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPluginConvention;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.internal.DefaultEarPluginConvention;

public abstract class EarPlugin
implements Plugin<Project> {
    public static final String EAR_TASK_NAME = "ear";
    public static final String DEPLOY_CONFIGURATION_NAME = "deploy";
    public static final String EARLIB_CONFIGURATION_NAME = "earlib";
    static final String DEFAULT_LIB_DIR_NAME = "lib";
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public EarPlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices, TaskDependencyFactory taskDependencyFactory) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        EarPluginConvention earPluginConvention = (EarPluginConvention)this.objectFactory.newInstance(DefaultEarPluginConvention.class, new Object[0]);
        project.getConvention().getPlugins().put(EAR_TASK_NAME, earPluginConvention);
        earPluginConvention.setLibDirName(DEFAULT_LIB_DIR_NAME);
        earPluginConvention.setAppDirName("src/main/application");
        this.configureConfigurations(project);
        PluginContainer plugins = project.getPlugins();
        this.setupEarTask(project, earPluginConvention, plugins);
        this.wireEarTaskConventions(project, earPluginConvention);
        this.wireEarTaskConventionsWithJavaPluginApplied(project, plugins);
    }

    private void wireEarTaskConventionsWithJavaPluginApplied(Project project, PluginContainer plugins) {
        plugins.withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
            project.getTasks().withType(Ear.class).configureEach(task -> {
                task.dependsOn(new Object[]{() -> this.mainSourceSetOf(javaPluginExtension).getRuntimeClasspath()});
                task.from(new Object[]{() -> this.mainSourceSetOf(javaPluginExtension).getOutput()});
            });
        });
    }

    private SourceSet mainSourceSetOf(JavaPluginExtension javaPluginExtension) {
        return (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
    }

    private void setupEarTask(final Project project, final EarPluginConvention convention, final PluginContainer plugins) {
        TaskProvider ear = project.getTasks().register(EAR_TASK_NAME, Ear.class, (Action)new Action<Ear>(){

            public void execute(Ear ear) {
                ear.setDescription("Generates a ear archive with all the modules, the application descriptor and the libraries.");
                ear.setGroup("build");
                ear.getGenerateDeploymentDescriptor().convention(convention.getGenerateDeploymentDescriptor());
                plugins.withType(JavaPlugin.class, javaPlugin -> {
                    JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
                    SourceSet sourceSet = EarPlugin.this.mainSourceSetOf(javaPluginExtension);
                    sourceSet.getResources().srcDir((Object)ear.getAppDirectory());
                });
            }
        });
        DeploymentDescriptor deploymentDescriptor = convention.getDeploymentDescriptor();
        if (deploymentDescriptor != null) {
            if (deploymentDescriptor.getDisplayName() == null) {
                deploymentDescriptor.setDisplayName(project.getName());
            }
            if (deploymentDescriptor.getDescription() == null) {
                deploymentDescriptor.setDescription(project.getDescription());
            }
        }
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)new LazyPublishArtifact((Provider)ear, ((ProjectInternal)project).getFileResolver(), this.taskDependencyFactory));
        project.getTasks().withType(Ear.class).configureEach((Action)new Action<Ear>(){

            public void execute(Ear task) {
            }
        });
    }

    private void wireEarTaskConventions(final Project project, final EarPluginConvention earConvention) {
        project.getTasks().withType(Ear.class).configureEach((Action)new Action<Ear>(){

            public void execute(Ear task) {
                task.getAppDirectory().convention(project.provider(() -> project.getLayout().getProjectDirectory().dir(earConvention.getAppDirName())));
                task.getConventionMapping().map("libDirName", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return earConvention.getLibDirName();
                    }
                });
                task.getConventionMapping().map("deploymentDescriptor", (Callable)new Callable<DeploymentDescriptor>(){

                    @Override
                    public DeploymentDescriptor call() throws Exception {
                        return earConvention.getDeploymentDescriptor();
                    }
                });
                task.from(new Object[]{() -> {
                    if (project.getPlugins().hasPlugin(JavaPlugin.class)) {
                        return null;
                    }
                    return task.getAppDirectory().getAsFileTree();
                }});
                task.getLib().from(new Object[]{new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.EARLIB_CONFIGURATION_NAME).minus((FileCollection)project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME));
                    }
                }});
                task.from(new Object[]{new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME);
                    }
                }});
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration moduleConfiguration = ((Configuration)configurations.create(DEPLOY_CONFIGURATION_NAME)).setVisible(false).setTransitive(false).setDescription("Classpath for deployable modules, not transitive.");
        this.jvmPluginServices.configureAttributes((HasConfigurableAttributes)moduleConfiguration, details -> details.library().runtimeUsage().withExternalDependencies());
        Configuration earlibConfiguration = ((Configuration)configurations.create(EARLIB_CONFIGURATION_NAME)).setVisible(false).setDescription("Classpath for module dependencies.");
        this.jvmPluginServices.configureAttributes((HasConfigurableAttributes)earlibConfiguration, details -> details.library().runtimeUsage().withExternalDependencies());
        configurations.getByName("default").extendsFrom(new Configuration[]{moduleConfiguration, earlibConfiguration});
    }
}

