/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.util.concurrent.TimeUnit;
import org.gradle.api.Incubating;

@Incubating
public enum CleanupFrequency {
    DAILY{

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            long duration = System.currentTimeMillis() - lastCleanupTimestamp;
            long timeInHours = TimeUnit.MILLISECONDS.toHours(duration);
            return timeInHours >= 24L;
        }
    }
    ,
    NEVER{

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            return false;
        }
    };


    public abstract boolean requiresCleanup(long var1);
}

