/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryDelegate;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.notations.DependencyNotationParser;
import org.gradle.api.internal.notations.ProjectDependencyFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.NotationParser;

@ServiceScope(value=Scopes.Build.class)
public class DefaultDependencyFactory
implements DependencyFactoryInternal {
    private final Instantiator instantiator;
    private final DependencyNotationParser dependencyNotationParser;
    private final NotationParser<Object, DependencyConstraint> dependencyConstraintNotationParser;
    private final NotationParser<Object, ClientModule> clientModuleNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ProjectDependencyFactory projectDependencyFactory;
    private final ImmutableAttributesFactory attributesFactory;

    public DefaultDependencyFactory(Instantiator instantiator, DependencyNotationParser dependencyNotationParser, NotationParser<Object, DependencyConstraint> dependencyConstraintNotationParser, NotationParser<Object, ClientModule> clientModuleNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ProjectDependencyFactory projectDependencyFactory, ImmutableAttributesFactory attributesFactory) {
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
        this.dependencyConstraintNotationParser = dependencyConstraintNotationParser;
        this.clientModuleNotationParser = clientModuleNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.projectDependencyFactory = projectDependencyFactory;
        this.attributesFactory = attributesFactory;
    }

    public Dependency createDependency(Object dependencyNotation) {
        Dependency dependency = dependencyNotation instanceof Dependency && !(dependencyNotation instanceof MinimalExternalModuleDependency) ? (Dependency)dependencyNotation : (Dependency)this.dependencyNotationParser.getNotationParser().parseNotation(dependencyNotation);
        this.injectServices(dependency);
        return dependency;
    }

    private void injectServices(Dependency dependency) {
        if (dependency instanceof AbstractModuleDependency) {
            AbstractModuleDependency moduleDependency = (AbstractModuleDependency)dependency;
            moduleDependency.setAttributesFactory(this.attributesFactory);
            moduleDependency.setCapabilityNotationParser(this.capabilityNotationParser);
        }
    }

    public DependencyConstraint createDependencyConstraint(Object dependencyNotation) {
        DependencyConstraint dependencyConstraint = (DependencyConstraint)this.dependencyConstraintNotationParser.parseNotation(dependencyNotation);
        this.injectServices(dependencyConstraint);
        return dependencyConstraint;
    }

    private void injectServices(DependencyConstraint dependency) {
        if (dependency instanceof DefaultDependencyConstraint) {
            ((DefaultDependencyConstraint)dependency).setAttributesFactory(this.attributesFactory);
        }
    }

    public ClientModule createModule(Object dependencyNotation, Closure configureClosure) {
        ClientModule clientModule = (ClientModule)this.clientModuleNotationParser.parseNotation(dependencyNotation);
        if (configureClosure != null) {
            this.configureModule(clientModule, configureClosure);
        }
        return clientModule;
    }

    public ProjectDependency createProjectDependencyFromMap(ProjectFinder projectFinder, Map<? extends String, ? extends Object> map) {
        return this.projectDependencyFactory.createFromMap(projectFinder, map);
    }

    private void configureModule(ClientModule clientModule, Closure configureClosure) {
        ModuleFactoryDelegate moduleFactoryDelegate = new ModuleFactoryDelegate(clientModule, this);
        moduleFactoryDelegate.prepareDelegation(configureClosure);
        configureClosure.call();
    }

    public ExternalModuleDependency create(CharSequence dependencyNotation) {
        return (ExternalModuleDependency)this.dependencyNotationParser.getStringNotationParser().parseNotation((Object)dependencyNotation.toString());
    }

    public ExternalModuleDependency create(@Nullable String group, String name, @Nullable String version) {
        return this.create(group, name, version, null, null);
    }

    public ExternalModuleDependency create(@Nullable String group, String name, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
        DefaultExternalModuleDependency dependency = (DefaultExternalModuleDependency)((Object)this.instantiator.newInstance(DefaultExternalModuleDependency.class, new Object[]{group, name, version}));
        ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)dependency, extension, classifier);
        return dependency;
    }

    public FileCollectionDependency create(FileCollection fileCollection) {
        return (FileCollectionDependency)this.dependencyNotationParser.getFileCollectionNotationParser().parseNotation((Object)fileCollection);
    }

    public ProjectDependency create(Project project) {
        return (ProjectDependency)this.dependencyNotationParser.getProjectNotationParser().parseNotation((Object)project);
    }

    public Dependency gradleApi() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.GRADLE_API);
    }

    public Dependency gradleTestKit() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT);
    }

    public Dependency localGroovy() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    }
}

