/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.apache.groovy.json.internal.CharBuf;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.configurationcache.DefaultConfigurationCacheKt;
import org.gradle.configurationcache.problems.DiagnosticKind;
import org.gradle.configurationcache.problems.HtmlReportWriter;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J/\u0010\r\u001a\u00020\f2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\u0002\b\u0010H\u0082\b\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0013J/\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;", "Ljava/io/Closeable;", "executorFactory", "Lorg/gradle/internal/concurrent/ExecutorFactory;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "(Lorg/gradle/internal/concurrent/ExecutorFactory;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;)V", "state", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State;", "stateLock", "Ljava/lang/Object;", "close", "", "modifyState", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onInput", "input", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "onProblem", "problem", "writeReportFileTo", "Ljava/io/File;", "outputDirectory", "cacheAction", "", "requestedTasks", "totalProblemCount", "", "writeReportFileTo$configuration_cache", "State", "configuration-cache"})
public final class ConfigurationCacheReport
implements Closeable {
    @NotNull
    private State state;
    @NotNull
    private final Object stateLock;

    public ConfigurationCacheReport(@NotNull ExecutorFactory executorFactory, @NotNull TemporaryFileProvider temporaryFileProvider) {
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
        this.state = new State.Idle(executorFactory, temporaryFileProvider);
        this.stateLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void close() {
        ConfigurationCacheReport this_$iv = this;
        boolean $i$f$modifyState = false;
        Object object = this_$iv.stateLock;
        synchronized (object) {
            void $this$close_u24lambda_u240;
            boolean bl = false;
            State state2 = this_$iv.state;
            ConfigurationCacheReport configurationCacheReport = this_$iv;
            boolean bl2 = false;
            configurationCacheReport.state = $this$close_u24lambda_u240.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onProblem(@NotNull PropertyProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        ConfigurationCacheReport this_$iv = this;
        boolean $i$f$modifyState = false;
        Object object = this_$iv.stateLock;
        synchronized (object) {
            void $this$onProblem_u24lambda_u241;
            boolean bl = false;
            State state2 = this_$iv.state;
            ConfigurationCacheReport configurationCacheReport = this_$iv;
            boolean bl2 = false;
            configurationCacheReport.state = $this$onProblem_u24lambda_u241.onDiagnostic(DiagnosticKind.PROBLEM, problem);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onInput(@NotNull PropertyProblem input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ConfigurationCacheReport this_$iv = this;
        boolean $i$f$modifyState = false;
        Object object = this_$iv.stateLock;
        synchronized (object) {
            void $this$onInput_u24lambda_u242;
            boolean bl = false;
            State state2 = this_$iv.state;
            ConfigurationCacheReport configurationCacheReport = this_$iv;
            boolean bl2 = false;
            configurationCacheReport.state = $this$onInput_u24lambda_u242.onDiagnostic(DiagnosticKind.INPUT, input);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final File writeReportFileTo$configuration_cache(@NotNull File outputDirectory, @NotNull String cacheAction, @NotNull String requestedTasks, int totalProblemCount) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
        Intrinsics.checkNotNullParameter((Object)requestedTasks, (String)"requestedTasks");
        File reportFile = null;
        ConfigurationCacheReport this_$iv = this;
        boolean $i$f$modifyState = false;
        Object object = this_$iv.stateLock;
        synchronized (object) {
            File outputFile;
            void $this$writeReportFileTo_u24lambda_u243;
            boolean bl = false;
            State state2 = this_$iv.state;
            ConfigurationCacheReport configurationCacheReport = this_$iv;
            boolean bl2 = false;
            Pair<State, File> pair = $this$writeReportFileTo_u24lambda_u243.commitReportTo(outputDirectory, cacheAction, requestedTasks, totalProblemCount);
            State newState = (State)pair.component1();
            reportFile = outputFile = (File)pair.component2();
            configurationCacheReport.state = newState;
            Unit unit = Unit.INSTANCE;
        }
        return reportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyState(Function1<? super State, ? extends State> f) {
        boolean $i$f$modifyState = false;
        Object object = this.stateLock;
        synchronized (object) {
            try {
                boolean bl = false;
                this.state = (State)f.invoke((Object)this.state);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd((int)1);
            }
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0016J6\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u0082\u0001\u0003\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State;", "", "()V", "close", "commitReportTo", "Lkotlin/Pair;", "Ljava/io/File;", "outputDirectory", "cacheAction", "", "requestedTasks", "totalProblemCount", "", "illegalState", "", "onDiagnostic", "kind", "Lorg/gradle/configurationcache/problems/DiagnosticKind;", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "Closed", "Idle", "Spooling", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Closed;", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Idle;", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Spooling;", "configuration-cache"})
    private static abstract class State {
        private State() {
        }

        @NotNull
        public State onDiagnostic(@NotNull DiagnosticKind kind, @NotNull PropertyProblem problem) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            this.illegalState();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Pair<State, File> commitReportTo(@NotNull File outputDirectory, @NotNull String cacheAction, @NotNull String requestedTasks, int totalProblemCount) {
            Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
            Intrinsics.checkNotNullParameter((Object)requestedTasks, (String)"requestedTasks");
            this.illegalState();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public State close() {
            this.illegalState();
            throw new KotlinNothingValueException();
        }

        private final Void illegalState() {
            throw new IllegalStateException("Operation is not valid in " + this.getClass().getSimpleName() + " state.");
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0001H\u0016J6\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u000e0\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\n \u0016*\u0004\u0018\u00010\u001d0\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Idle;", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State;", "executorFactory", "Lorg/gradle/internal/concurrent/ExecutorFactory;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "(Lorg/gradle/internal/concurrent/ExecutorFactory;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;)V", "getExecutorFactory", "()Lorg/gradle/internal/concurrent/ExecutorFactory;", "getTemporaryFileProvider", "()Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "close", "commitReportTo", "Lkotlin/Pair;", "Ljava/io/File;", "outputDirectory", "cacheAction", "", "requestedTasks", "totalProblemCount", "", "htmlReportSpoolFile", "kotlin.jvm.PlatformType", "onDiagnostic", "kind", "Lorg/gradle/configurationcache/problems/DiagnosticKind;", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "singleThreadExecutor", "Lorg/gradle/internal/concurrent/ManagedExecutor;", "configuration-cache"})
        public static final class Idle
        extends State {
            @NotNull
            private final ExecutorFactory executorFactory;
            @NotNull
            private final TemporaryFileProvider temporaryFileProvider;

            public Idle(@NotNull ExecutorFactory executorFactory, @NotNull TemporaryFileProvider temporaryFileProvider) {
                Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
                Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
                super(null);
                this.executorFactory = executorFactory;
                this.temporaryFileProvider = temporaryFileProvider;
            }

            @NotNull
            public final ExecutorFactory getExecutorFactory() {
                return this.executorFactory;
            }

            @NotNull
            public final TemporaryFileProvider getTemporaryFileProvider() {
                return this.temporaryFileProvider;
            }

            @Override
            @NotNull
            public Pair<State, File> commitReportTo(@NotNull File outputDirectory, @NotNull String cacheAction, @NotNull String requestedTasks, int totalProblemCount) {
                Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
                Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
                Intrinsics.checkNotNullParameter((Object)requestedTasks, (String)"requestedTasks");
                return TuplesKt.to((Object)this, null);
            }

            @Override
            @NotNull
            public State onDiagnostic(@NotNull DiagnosticKind kind, @NotNull PropertyProblem problem) {
                Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                File file = this.htmlReportSpoolFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"htmlReportSpoolFile()");
                ManagedExecutor managedExecutor = this.singleThreadExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)managedExecutor, (String)"singleThreadExecutor()");
                ClassLoader classLoader = CharBuf.class.getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"CharBuf::class.java.classLoader");
                return new Spooling(file, managedExecutor, classLoader).onDiagnostic(kind, problem);
            }

            private final File htmlReportSpoolFile() {
                return this.temporaryFileProvider.createTemporaryFile("configuration-cache-report", "html", new String[0]);
            }

            private final ManagedExecutor singleThreadExecutor() {
                return this.executorFactory.create("Configuration cache report writer", 1);
            }

            @Override
            @NotNull
            public State close() {
                return this;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0001H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J6\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0017H\u0002J\f\u0010%\u001a\u00020\u0015*\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Spooling;", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State;", "spoolFile", "Ljava/io/File;", "executor", "Lorg/gradle/internal/concurrent/ManagedExecutor;", "groovyJsonClassLoader", "Ljava/lang/ClassLoader;", "(Ljava/io/File;Lorg/gradle/internal/concurrent/ManagedExecutor;Ljava/lang/ClassLoader;)V", "getExecutor", "()Lorg/gradle/internal/concurrent/ManagedExecutor;", "getGroovyJsonClassLoader", "()Ljava/lang/ClassLoader;", "hashingStream", "Lorg/gradle/internal/hash/HashingOutputStream;", "getSpoolFile", "()Ljava/io/File;", "writer", "Lorg/gradle/configurationcache/problems/HtmlReportWriter;", "close", "closeHtmlReport", "", "cacheAction", "", "requestedTasks", "totalProblemCount", "", "commitReportTo", "Lkotlin/Pair;", "outputDirectory", "moveSpoolFileTo", "onDiagnostic", "kind", "Lorg/gradle/configurationcache/problems/DiagnosticKind;", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "reportHash", "shutdownAndAwaitTermination", "configuration-cache"})
        public static final class Spooling
        extends State {
            @NotNull
            private final File spoolFile;
            @NotNull
            private final ManagedExecutor executor;
            @NotNull
            private final ClassLoader groovyJsonClassLoader;
            @NotNull
            private final HashingOutputStream hashingStream;
            @NotNull
            private final HtmlReportWriter writer;

            public Spooling(@NotNull File spoolFile, @NotNull ManagedExecutor executor, @NotNull ClassLoader groovyJsonClassLoader) {
                Intrinsics.checkNotNullParameter((Object)spoolFile, (String)"spoolFile");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                Intrinsics.checkNotNullParameter((Object)groovyJsonClassLoader, (String)"groovyJsonClassLoader");
                super(null);
                this.spoolFile = spoolFile;
                this.executor = executor;
                this.groovyJsonClassLoader = groovyJsonClassLoader;
                OutputStream outputStream = new FileOutputStream(this.spoolFile);
                int n = 8192;
                this.hashingStream = new HashingOutputStream(Hashing.md5(), (OutputStream)(outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n)));
                outputStream = (OutputStream)this.hashingStream;
                Charset charset = Charsets.UTF_8;
                this.writer = new HtmlReportWriter(new OutputStreamWriter(outputStream, charset));
                this.executor.submit(new Runnable(){

                    @Override
                    public final void run() {
                        Thread.currentThread().setContextClassLoader(this.getGroovyJsonClassLoader());
                        writer.beginHtmlReport();
                    }
                });
            }

            @NotNull
            public final File getSpoolFile() {
                return this.spoolFile;
            }

            @NotNull
            public final ManagedExecutor getExecutor() {
                return this.executor;
            }

            @NotNull
            public final ClassLoader getGroovyJsonClassLoader() {
                return this.groovyJsonClassLoader;
            }

            @Override
            @NotNull
            public State onDiagnostic(@NotNull DiagnosticKind kind, @NotNull PropertyProblem problem) {
                Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                this.executor.submit(new Runnable(this, kind, problem){
                    final /* synthetic */ Spooling this$0;
                    final /* synthetic */ DiagnosticKind $kind;
                    final /* synthetic */ PropertyProblem $problem;
                    {
                        this.this$0 = $receiver;
                        this.$kind = $kind;
                        this.$problem = $problem;
                    }

                    public final void run() {
                        Spooling.access$getWriter$p(this.this$0).writeDiagnostic(this.$kind, this.$problem);
                    }
                });
                return this;
            }

            @Override
            @NotNull
            public Pair<State, File> commitReportTo(@NotNull File outputDirectory, @NotNull String cacheAction, @NotNull String requestedTasks, int totalProblemCount) {
                File file;
                Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
                Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
                Intrinsics.checkNotNullParameter((Object)requestedTasks, (String)"requestedTasks");
                Ref.ObjectRef reportFile = new Ref.ObjectRef();
                this.executor.submit(new Runnable(this, cacheAction, requestedTasks, totalProblemCount, (Ref.ObjectRef<File>)reportFile, outputDirectory){
                    final /* synthetic */ Spooling this$0;
                    final /* synthetic */ String $cacheAction;
                    final /* synthetic */ String $requestedTasks;
                    final /* synthetic */ int $totalProblemCount;
                    final /* synthetic */ Ref.ObjectRef<File> $reportFile;
                    final /* synthetic */ File $outputDirectory;
                    {
                        this.this$0 = $receiver;
                        this.$cacheAction = $cacheAction;
                        this.$requestedTasks = $requestedTasks;
                        this.$totalProblemCount = $totalProblemCount;
                        this.$reportFile = $reportFile;
                        this.$outputDirectory = $outputDirectory;
                    }

                    public final void run() {
                        Spooling.access$closeHtmlReport(this.this$0, this.$cacheAction, this.$requestedTasks, this.$totalProblemCount);
                        this.$reportFile.element = Spooling.access$moveSpoolFileTo(this.this$0, this.$outputDirectory);
                    }
                });
                this.shutdownAndAwaitTermination(this.executor);
                if (reportFile.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reportFile");
                    file = null;
                } else {
                    file = (File)reportFile.element;
                }
                return TuplesKt.to((Object)Closed.INSTANCE, (Object)file);
            }

            @Override
            @NotNull
            public State close() {
                if (this.executor.isShutdown()) {
                    this.writer.close();
                } else {
                    this.executor.submit(new Runnable(this){
                        final /* synthetic */ Spooling this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            Spooling.access$getWriter$p(this.this$0).close();
                        }
                    });
                    this.executor.shutdown();
                }
                return Closed.INSTANCE;
            }

            private final void closeHtmlReport(String cacheAction, String requestedTasks, int totalProblemCount) {
                this.writer.endHtmlReport(cacheAction, requestedTasks, totalProblemCount);
                this.writer.close();
            }

            private final void shutdownAndAwaitTermination(ManagedExecutor $this$shutdownAndAwaitTermination) {
                $this$shutdownAndAwaitTermination.shutdown();
                if (!$this$shutdownAndAwaitTermination.awaitTermination(30L, TimeUnit.SECONDS)) {
                    DefaultConfigurationCacheKt.getLogger().warn("Configuration cache report is taking too long to write... The build might finish before the report has been completely written.");
                }
            }

            private final File moveSpoolFileTo(File outputDirectory) {
                File reportDir = FilesKt.resolve((File)outputDirectory, (String)this.reportHash());
                File reportFile = FilesKt.resolve((File)reportDir, (String)"configuration-cache-report.html");
                if (!reportFile.exists()) {
                    if (!reportDir.mkdirs()) {
                        boolean bl = false;
                        String string2 = "Could not create configuration cache report directory '" + reportDir + '\'';
                        throw new IllegalArgumentException(string2.toString());
                    }
                    Files.move(this.spoolFile.toPath(), reportFile.toPath(), new CopyOption[0]);
                }
                return reportFile;
            }

            private final String reportHash() {
                String string2 = this.hashingStream.hash().toCompactString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hashingStream.hash().toCompactString()");
                return string2;
            }

            public static final /* synthetic */ void access$closeHtmlReport(Spooling $this, String cacheAction, String requestedTasks, int totalProblemCount) {
                $this.closeHtmlReport(cacheAction, requestedTasks, totalProblemCount);
            }

            public static final /* synthetic */ File access$moveSpoolFileTo(Spooling $this, File outputDirectory) {
                return $this.moveSpoolFileTo(outputDirectory);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State$Closed;", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport$State;", "()V", "close", "configuration-cache"})
        public static final class Closed
        extends State {
            @NotNull
            public static final Closed INSTANCE = new Closed();

            private Closed() {
                super(null);
            }

            @Override
            @NotNull
            public State close() {
                return this;
            }
        }
    }
}

