/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import com.google.common.annotations.VisibleForTesting;
import groovy.lang.GroovySystem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultDependencyAdder;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmComponentDependencies;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.plugins.jvm.internal.DefaultJvmComponentDependencies;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuiteTarget;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.internal.VersionNumber;

public abstract class DefaultJvmTestSuite
implements JvmTestSuite {
    private final ExtensiblePolymorphicDomainObjectContainer<JvmTestSuiteTarget> targets;
    private final SourceSet sourceSet;
    private final String name;
    private final JvmComponentDependencies dependencies;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public DefaultJvmTestSuite(String name, SourceSetContainer sourceSets, ConfigurationContainer configurations, TaskDependencyFactory taskDependencyFactory) {
        this.name = name;
        this.sourceSet = (SourceSet)sourceSets.create(this.getName());
        this.taskDependencyFactory = taskDependencyFactory;
        Configuration compileOnly = configurations.getByName(this.sourceSet.getCompileOnlyConfigurationName());
        Configuration implementation = configurations.getByName(this.sourceSet.getImplementationConfigurationName());
        Configuration runtimeOnly = configurations.getByName(this.sourceSet.getRuntimeOnlyConfigurationName());
        Configuration annotationProcessor = configurations.getByName(this.sourceSet.getAnnotationProcessorConfigurationName());
        this.targets = this.getObjectFactory().polymorphicDomainObjectContainer(JvmTestSuiteTarget.class);
        this.targets.registerBinding(JvmTestSuiteTarget.class, DefaultJvmTestSuiteTarget.class);
        this.dependencies = (JvmComponentDependencies)this.getObjectFactory().newInstance(DefaultJvmComponentDependencies.class, new Object[]{this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{implementation}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{compileOnly}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{runtimeOnly}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{annotationProcessor})});
        if (!name.equals("test")) {
            this.getTestSuiteTestingFramework().convention((Object)new VersionedTestingFramework(TestingFramework.JUNIT_JUPITER, TestingFramework.JUNIT_JUPITER.getDefaultVersion()));
        }
        this.getTestSuiteTestingFramework().finalizeValueOnRead();
        this.addDefaultTestTarget();
        this.targets.withType(JvmTestSuiteTarget.class).configureEach(target -> target.getTestTask().configure(task -> this.initializeTestFramework(name, (Test)task)));
        implementation.withDependencies(dependencySet -> this.dependencies.getImplementation().bundle(this.getTestSuiteTestingFramework().map(vtf -> this.createDependencies(vtf.getImplementationDependencies())).orElse(Collections.emptyList())));
        runtimeOnly.withDependencies(dependencySet -> this.dependencies.getRuntimeOnly().bundle(this.getTestSuiteTestingFramework().map(vtf -> this.createDependencies(vtf.getRuntimeOnlyDependencies())).orElse(Collections.emptyList())));
    }

    private void initializeTestFramework(String name, Test task) {
        Provider mapTestingFrameworkToTestFramework = this.getTestSuiteTestingFramework().map(vtf -> {
            switch (vtf.getFramework()) {
                case JUNIT4: {
                    return new JUnitTestFramework(task, (DefaultTestFilter)task.getFilter(), false);
                }
                case KOTLIN_TEST: 
                case JUNIT_JUPITER: 
                case SPOCK: {
                    return new JUnitPlatformTestFramework((DefaultTestFilter)task.getFilter(), false);
                }
                case TESTNG: {
                    return new TestNGTestFramework(task, (DefaultTestFilter)task.getFilter(), this.getObjectFactory());
                }
            }
            throw new IllegalStateException("do not know how to handle " + vtf);
        });
        if (name.equals("test")) {
            task.getTestFrameworkProperty().convention(mapTestingFrameworkToTestFramework.orElse(this.getProviderFactory().provider(() -> new JUnitTestFramework(task, (DefaultTestFilter)task.getFilter(), true))));
            task.getTestFrameworkProperty().finalizeValueOnRead();
        } else {
            task.getTestFrameworkProperty().convention(mapTestingFrameworkToTestFramework);
            task.getTestFrameworkProperty().disallowChanges();
            task.getTestFrameworkProperty().finalizeValueOnRead();
        }
    }

    private void addDefaultTestTarget() {
        String target = this.getName().equals("test") ? "test" : this.getName();
        this.targets.register(target);
    }

    protected abstract Property<VersionedTestingFramework> getTestSuiteTestingFramework();

    private List<ExternalModuleDependency> createDependencies(List<String> dependencies) {
        return dependencies.stream().map(arg_0 -> ((DependencyFactory)this.getDependencyFactory()).create(arg_0)).collect(Collectors.toList());
    }

    private void setFrameworkTo(TestingFramework framework, Provider<String> version) {
        this.getTestSuiteTestingFramework().set(version.map(v -> new VersionedTestingFramework(framework, (String)v)));
    }

    public String getName() {
        return this.name;
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Inject
    public abstract DependencyFactory getDependencyFactory();

    @Override
    public SourceSet getSources() {
        return this.sourceSet;
    }

    @Override
    public void sources(Action<? super SourceSet> configuration) {
        configuration.execute((Object)this.getSources());
    }

    public ExtensiblePolymorphicDomainObjectContainer<JvmTestSuiteTarget> getTargets() {
        return this.targets;
    }

    @Override
    public void useJUnit() {
        this.useJUnit(TestingFramework.JUNIT4.getDefaultVersion());
    }

    @Override
    public void useJUnit(String version) {
        this.useJUnit((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnit(Provider<String> version) {
        this.setFrameworkTo(TestingFramework.JUNIT4, version);
    }

    @Override
    public void useJUnitJupiter() {
        this.useJUnitJupiter(TestingFramework.JUNIT_JUPITER.getDefaultVersion());
    }

    @Override
    public void useJUnitJupiter(String version) {
        this.useJUnitJupiter((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnitJupiter(Provider<String> version) {
        this.setFrameworkTo(TestingFramework.JUNIT_JUPITER, version);
    }

    @Override
    public void useSpock() {
        this.useSpock(TestingFramework.SPOCK.getDefaultVersion());
    }

    @Override
    public void useSpock(String version) {
        this.useSpock((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useSpock(Provider<String> version) {
        this.setFrameworkTo(TestingFramework.SPOCK, version);
    }

    @Override
    public void useKotlinTest() {
        this.useKotlinTest(TestingFramework.KOTLIN_TEST.getDefaultVersion());
    }

    @Override
    public void useKotlinTest(String version) {
        this.useKotlinTest((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useKotlinTest(Provider<String> version) {
        this.setFrameworkTo(TestingFramework.KOTLIN_TEST, version);
    }

    @Override
    public void useTestNG() {
        this.useTestNG(TestingFramework.TESTNG.getDefaultVersion());
    }

    @Override
    public void useTestNG(String version) {
        this.useTestNG((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useTestNG(Provider<String> version) {
        this.setFrameworkTo(TestingFramework.TESTNG, version);
    }

    @Override
    public JvmComponentDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Action<? super JvmComponentDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public TaskDependency getBuildDependencies() {
        return this.taskDependencyFactory.visitingDependencies(context -> this.getTargets().forEach(arg_0 -> ((TaskDependencyResolveContext)context).add(arg_0)));
    }

    private static class VersionedTestingFramework {
        private final TestingFramework framework;
        private final String version;

        private VersionedTestingFramework(TestingFramework framework, String version) {
            this.framework = framework;
            this.version = version;
        }

        public TestingFramework getFramework() {
            return this.framework;
        }

        public List<String> getImplementationDependencies() {
            return this.framework.getImplementationDependencies(this.version);
        }

        public List<String> getRuntimeOnlyDependencies() {
            return this.framework.getRuntimeOnlyDependencies();
        }
    }

    @VisibleForTesting
    public static enum TestingFramework {
        JUNIT4("junit", "junit", "4.13.2"),
        JUNIT_JUPITER("org.junit.jupiter", "junit-jupiter", "5.8.2", Collections.singletonList("org.junit.platform:junit-platform-launcher")),
        SPOCK("org.spockframework", "spock-core", TestingFramework.getAppropriateSpockVersion(), Collections.singletonList("org.junit.platform:junit-platform-launcher")),
        KOTLIN_TEST("org.jetbrains.kotlin", "kotlin-test-junit5", "1.7.22", Collections.singletonList("org.junit.platform:junit-platform-launcher")),
        TESTNG("org.testng", "testng", "7.5");

        private final String groupName;
        private final String defaultVersion;
        private final List<String> runtimeDependencies;

        private TestingFramework(String group, String name, String defaultVersion) {
            this(group, name, defaultVersion, Collections.emptyList());
        }

        private TestingFramework(String group, String name, String defaultVersion, List<String> runtimeDependencies) {
            this.groupName = group + ":" + name;
            this.defaultVersion = defaultVersion;
            this.runtimeDependencies = runtimeDependencies;
        }

        public String getDefaultVersion() {
            return this.defaultVersion;
        }

        public List<String> getImplementationDependencies(String version) {
            return Collections.singletonList(this.groupName + ":" + version);
        }

        public List<String> getRuntimeOnlyDependencies() {
            return this.runtimeDependencies;
        }

        private static String getAppropriateSpockVersion() {
            if (VersionNumber.parse((String)GroovySystem.getVersion()).getMajor() >= 4) {
                return "2.2-groovy-4.0";
            }
            return "2.2-groovy-3.0";
        }
    }
}

