/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.plugins.BuildConfigurationRule;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.internal.DefaultBasePluginConvention;
import org.gradle.api.plugins.internal.DefaultBasePluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public abstract class BasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";

    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        BasePluginExtension baseExtension = (BasePluginExtension)project.getExtensions().create(BasePluginExtension.class, "base", DefaultBasePluginExtension.class, new Object[]{project});
        BasePluginConvention convention = (BasePluginConvention)project.getObjects().newInstance(DefaultBasePluginConvention.class, new Object[]{baseExtension});
        project.getConvention().getPlugins().put("base", convention);
        this.configureExtension(project, baseExtension);
        this.configureBuildConfigurationRule(project);
        this.configureArchiveDefaults(project, baseExtension);
        this.configureConfigurations(project);
        this.configureAssemble((ProjectInternal)project);
    }

    private void configureExtension(Project project, BasePluginExtension extension) {
        extension.getArchivesName().convention((Object)project.getName());
        extension.getLibsDirectory().convention(project.getLayout().getBuildDirectory().dir("libs"));
        extension.getDistsDirectory().convention(project.getLayout().getBuildDirectory().dir("distributions"));
    }

    private void configureArchiveDefaults(Project project, BasePluginExtension extension) {
        project.getTasks().withType(AbstractArchiveTask.class).configureEach(task -> {
            if (task instanceof Jar) {
                task.getDestinationDirectory().convention((Provider)extension.getLibsDirectory());
            } else {
                task.getDestinationDirectory().convention((Provider)extension.getDistsDirectory());
            }
            task.getArchiveVersion().convention(project.provider(() -> project.getVersion() == "unspecified" ? null : project.getVersion().toString()));
            task.getArchiveBaseName().convention(extension.getArchivesName());
        });
    }

    private void configureBuildConfigurationRule(Project project) {
        project.getTasks().addRule((Rule)new BuildConfigurationRule(project.getConfigurations(), project.getTasks()));
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        ((ProjectInternal)project).getInternalStatus().convention((Object)"integration");
        Configuration archivesConfiguration = ((Configuration)configurations.maybeCreate("archives")).setDescription("Configuration for archive artifacts.");
        Configuration defaultConfiguration = ((Configuration)configurations.maybeCreate("default")).setDescription("Configuration for default artifacts.");
        DefaultArtifactPublicationSet defaultArtifacts = (DefaultArtifactPublicationSet)project.getExtensions().create("defaultArtifacts", DefaultArtifactPublicationSet.class, new Object[]{archivesConfiguration.getArtifacts()});
        archivesConfiguration.setCanBeResolved(false);
        defaultConfiguration.setCanBeResolved(false);
        ((ConfigurationInternal)archivesConfiguration).setCanBeDeclaredAgainst(false);
        ((ConfigurationInternal)defaultConfiguration).setCanBeDeclaredAgainst(false);
        configurations.all(configuration -> {
            if (!configuration.equals(archivesConfiguration)) {
                configuration.getArtifacts().configureEach(artifact -> {
                    if (configuration.isVisible()) {
                        defaultArtifacts.addCandidate((PublishArtifact)artifact);
                    }
                });
            }
        });
    }

    private void configureAssemble(ProjectInternal project) {
        project.getTasks().named(ASSEMBLE_TASK_NAME, task -> task.dependsOn(new Object[]{task.getProject().getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies()}));
    }
}

