/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.VersionNumber;

public class PmdPlugin
extends AbstractCodeQualityPlugin<Pmd> {
    public static final String DEFAULT_PMD_VERSION = "6.48.0";
    private static final String PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION = "pmdAux";
    private PmdExtension extension;

    @Inject
    protected JvmPluginServices getJvmPluginServices() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getToolName() {
        return "PMD";
    }

    @Override
    protected Class<Pmd> getTaskType() {
        return Pmd.class;
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (PmdExtension)this.project.getExtensions().create("pmd", PmdExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_PMD_VERSION);
        this.extension.getRulesMinimumPriority().convention((Object)5);
        this.extension.getIncrementalAnalysis().convention((Object)true);
        this.extension.getMaxFailures().convention((Object)0);
        this.extension.getThreads().convention((Object)1);
        this.extension.setRuleSetFiles(this.project.getLayout().files(new Object[0]));
        this.extension.ruleSetsConvention((Provider<List<String>>)this.project.getProviders().provider(() -> this.ruleSetsConvention(this.extension)));
        PmdPlugin.conventionMappingOf(this.extension).map("targetJdk", () -> this.getDefaultTargetJdk(this.getJavaPluginExtension().getSourceCompatibility()));
        return this.extension;
    }

    public TargetJdk getDefaultTargetJdk(JavaVersion javaVersion) {
        try {
            return TargetJdk.toVersion(javaVersion.toString());
        }
        catch (IllegalArgumentException ignored) {
            return TargetJdk.VERSION_1_4;
        }
    }

    @Override
    protected void createConfigurations() {
        super.createConfigurations();
        this.project.getConfigurations().create(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION, additionalAuxDepsConfiguration -> {
            additionalAuxDepsConfiguration.setDescription("The additional libraries that are available for type resolution during analysis");
            additionalAuxDepsConfiguration.setCanBeResolved(false);
            additionalAuxDepsConfiguration.setCanBeConsumed(false);
            additionalAuxDepsConfiguration.setVisible(false);
        });
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Pmd task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
        this.configureToolchains(task);
    }

    private List<String> ruleSetsConvention(PmdExtension extension) {
        if (extension.getRuleSetConfig() == null && extension.getRuleSetFiles().isEmpty()) {
            return new ArrayList<String>(Collections.singletonList("category/java/errorprone.xml"));
        }
        return Collections.emptyList();
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> {
            VersionNumber version = VersionNumber.parse((String)this.extension.getToolVersion());
            String dependency = this.calculateDefaultDependencyNotation(version);
            dependencies.add((Object)this.project.getDependencies().create((Object)dependency));
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, Pmd task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("pmdClasspath", () -> configuration);
        taskMapping.map("ruleSets", () -> this.extension.getRuleSets());
        taskMapping.map("ruleSetConfig", () -> this.extension.getRuleSetConfig());
        taskMapping.map("ruleSetFiles", () -> this.extension.getRuleSetFiles());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
        taskMapping.map("consoleOutput", () -> this.extension.isConsoleOutput());
        taskMapping.map("targetJdk", () -> this.extension.getTargetJdk());
        task.getRulesMinimumPriority().convention(this.extension.getRulesMinimumPriority());
        task.getMaxFailures().convention(this.extension.getMaxFailures());
        task.getIncrementalAnalysis().convention(this.extension.getIncrementalAnalysis());
        task.getThreads().convention(this.extension.getThreads());
    }

    private void configureReportsConventionMapping(Pmd task, String baseName) {
        ProjectLayout layout = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider reportsDir = layout.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
            report.getRequired().convention((Object)true);
            report.getOutputLocation().convention(layout.getProjectDirectory().file(providers.provider(() -> {
                String reportFileName = baseName + "." + report.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), reportFileName).getAbsolutePath();
            })));
        }));
    }

    private void configureToolchains(Pmd task) {
        Provider javaLauncherProvider = this.getToolchainService().launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(this.project.getObjects()));
        task.getJavaLauncher().convention(javaLauncherProvider);
        this.project.getPluginManager().withPlugin("java-base", p -> {
            JavaToolchainSpec toolchain = this.getJavaPluginExtension().getToolchain();
            task.getJavaLauncher().convention(this.getToolchainService().launcherFor(toolchain).orElse(javaLauncherProvider));
        });
    }

    private String calculateDefaultDependencyNotation(VersionNumber toolVersion) {
        if (toolVersion.compareTo(VersionNumber.version((int)5)) < 0) {
            return "pmd:pmd:" + this.extension.getToolVersion();
        }
        if (toolVersion.compareTo(VersionNumber.parse((String)"5.2.0")) < 0) {
            return "net.sourceforge.pmd:pmd:" + this.extension.getToolVersion();
        }
        return "net.sourceforge.pmd:pmd-java:" + this.extension.getToolVersion();
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Pmd task) {
        task.setDescription("Run PMD analysis for " + sourceSet.getName() + " classes");
        task.setSource((FileTree)sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        Configuration pmdAdditionalAuxDepsConfiguration = configurations.getByName(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION);
        Configuration pmdAuxClasspath = (Configuration)configurations.create(sourceSet.getName() + "PmdAuxClasspath");
        pmdAuxClasspath.extendsFrom(new Configuration[]{compileClasspath, pmdAdditionalAuxDepsConfiguration});
        pmdAuxClasspath.setCanBeConsumed(false);
        pmdAuxClasspath.setVisible(false);
        this.getJvmPluginServices().configureAsRuntimeClasspath((HasConfigurableAttributes)pmdAuxClasspath);
        taskMapping.map("classpath", () -> {
            FileCollection nonConfigurationClasspathEntries = sourceSet.getCompileClasspath().minus((FileCollection)compileClasspath);
            return sourceSet.getOutput().plus(nonConfigurationClasspathEntries).plus((FileCollection)pmdAuxClasspath);
        });
    }
}

