/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.BuildWorkPlan;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.build.BuildToolingModelControllerFactory;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class DefaultBuildLifecycleController
implements BuildLifecycleController {
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkPreparer workPreparer;
    private final BuildWorkExecutor workExecutor;
    private final BuildToolingModelControllerFactory toolingModelControllerFactory;
    private final BuildModelController modelController;
    private final StateTransitionController<State> state;
    private final GradleInternal gradle;
    private boolean hasTasks;

    public DefaultBuildLifecycleController(GradleInternal gradle, BuildModelController buildModelController, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkPreparer workPreparer, BuildWorkExecutor workExecutor, BuildToolingModelControllerFactory toolingModelControllerFactory, StateTransitionControllerFactory controllerFactory) {
        this.gradle = gradle;
        this.modelController = buildModelController;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.workPreparer = workPreparer;
        this.workExecutor = workExecutor;
        this.buildFinishedListener = buildFinishedListener;
        this.toolingModelControllerFactory = toolingModelControllerFactory;
        this.state = controllerFactory.newController(Describables.of((Object)"state of", (Object)gradle.getOwner().getDisplayName()), State.Configure);
    }

    @Override
    public GradleInternal getGradle() {
        this.state.assertNotInState(State.Finished);
        return this.gradle;
    }

    @Override
    public void loadSettings() {
        this.state.notInState(State.Finished, this.modelController::getLoadedSettings);
    }

    @Override
    public <T> T withSettings(Function<? super SettingsInternal, T> action) {
        return (T)this.state.notInState(State.Finished, () -> action.apply(this.modelController.getLoadedSettings()));
    }

    @Override
    public void configureProjects() {
        this.state.notInState(State.Finished, this.modelController::getConfiguredModel);
    }

    @Override
    public <T> T withProjectsConfigured(Function<? super GradleInternal, T> action) {
        return (T)this.state.notInState(State.Finished, () -> action.apply(this.modelController.getConfiguredModel()));
    }

    @Override
    public void resetState() {
        this.state.restart(State.Configure, () -> this.gradle.resetState());
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.state.notInStateIgnoreOtherThreads(State.Finished, this.modelController::getConfiguredModel);
    }

    @Override
    public void prepareToScheduleTasks() {
        this.state.maybeTransition(State.Configure, State.TaskSchedule, () -> {
            this.hasTasks = true;
            this.modelController.prepareToScheduleTasks();
        });
    }

    @Override
    public BuildWorkPlan newWorkGraph() {
        ExecutionPlan plan = this.workPreparer.newExecutionPlan();
        return new DefaultBuildWorkPlan(this, plan);
    }

    @Override
    public void populateWorkGraph(BuildWorkPlan plan, Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        workPlan.empty = false;
        this.state.inState(State.TaskSchedule, () -> this.workPreparer.populateWorkGraph(this.gradle, workPlan.plan, dest -> action.accept(new DefaultWorkGraphBuilder((ExecutionPlan)dest))));
    }

    @Override
    public void finalizeWorkGraph(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        if (workPlan.empty) {
            return;
        }
        this.state.transition(State.TaskSchedule, State.ReadyToRun, () -> {
            for (Consumer handler : workPlan.handlers) {
                workPlan.plan.onComplete(handler);
            }
            workPlan.finalizedPlan = this.workPreparer.finalizeWorkGraph(this.gradle, workPlan.plan);
        });
    }

    @Override
    public ExecutionResult<Void> executeTasks(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        if (workPlan.empty) {
            return ExecutionResult.succeeded();
        }
        return this.state.tryTransition(State.ReadyToRun, State.Configure, () -> this.workExecutor.execute(this.gradle, workPlan.finalizedPlan));
    }

    private DefaultBuildWorkPlan unpack(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = (DefaultBuildWorkPlan)plan;
        if (workPlan.owner != this) {
            throw new IllegalArgumentException("Unexpected plan owner.");
        }
        return workPlan;
    }

    @Override
    public <T> T withToolingModels(Function<? super BuildToolingModelController, T> action) {
        return action.apply(this.toolingModelControllerFactory.createController(this.gradle.getOwner(), this));
    }

    @Override
    public ExecutionResult<Void> finishBuild(@Nullable Throwable failure) {
        return this.state.finish(State.Finished, stageFailures -> {
            ExecutionResult<Object> finishResult;
            Throwable reportableFailure = failure;
            if (reportableFailure == null && !stageFailures.getFailures().isEmpty()) {
                reportableFailure = this.exceptionAnalyser.transform(stageFailures.getFailures());
            }
            BuildResult buildResult = new BuildResult(this.hasTasks ? "Build" : "Configure", (Gradle)this.gradle, reportableFailure);
            try {
                this.buildListener.buildFinished(buildResult);
                this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle(), buildResult.getFailure() != null);
                finishResult = ExecutionResult.succeeded();
            }
            catch (Throwable t) {
                finishResult = ExecutionResult.failed(t);
            }
            return finishResult;
        });
    }

    @Override
    public void addListener(Object listener) {
        this.getGradle().addListener(listener);
    }

    private class DefaultWorkGraphBuilder
    implements BuildLifecycleController.WorkGraphBuilder {
        private final ExecutionPlan plan;

        public DefaultWorkGraphBuilder(ExecutionPlan plan) {
            this.plan = plan;
        }

        @Override
        public void addRequestedTasks(@Nullable EntryTaskSelector selector) {
            DefaultBuildLifecycleController.this.modelController.scheduleRequestedTasks(selector, this.plan);
        }

        @Override
        public void addEntryTasks(List<? extends Task> tasks) {
            for (Task task : tasks) {
                this.plan.addEntryTask(task);
            }
        }

        @Override
        public void setScheduledNodes(List<? extends Node> nodes) {
            this.plan.setScheduledNodes(nodes);
        }
    }

    private static class DefaultBuildWorkPlan
    implements BuildWorkPlan {
        private final DefaultBuildLifecycleController owner;
        private final ExecutionPlan plan;
        private final List<Consumer<LocalTaskNode>> handlers = new ArrayList<Consumer<LocalTaskNode>>();
        private FinalizedExecutionPlan finalizedPlan;
        private boolean empty = true;

        public DefaultBuildWorkPlan(DefaultBuildLifecycleController owner, ExecutionPlan plan) {
            this.owner = owner;
            this.plan = plan;
        }

        public void stop() {
            this.plan.close();
        }

        @Override
        public void addFilter(Spec<Task> filter) {
            this.plan.addFilter(filter);
        }

        @Override
        public void onComplete(Consumer<LocalTaskNode> handler) {
            this.handlers.add(handler);
        }
    }

    private static enum State implements StateTransitionController.State
    {
        Configure,
        TaskSchedule,
        ReadyToRun,
        Finished;

    }
}

