/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Properties;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.MonitoredCleanupAction;
import org.gradle.cache.internal.MonitoredCleanupActionDecorator;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.util.internal.GUtil;

public class GradleUserHomeCacheCleanupActionDecorator
implements CleanupActionDecorator,
MonitoredCleanupActionDecorator {
    public static final String CACHE_CLEANUP_PROPERTY = "org.gradle.cache.cleanup";
    private final GradleUserHomeDirProvider userHomeDirProvider;

    public GradleUserHomeCacheCleanupActionDecorator(GradleUserHomeDirProvider userHomeDirProvider) {
        this.userHomeDirProvider = userHomeDirProvider;
    }

    private boolean isEnabled() {
        File gradleUserHomeDirectory = this.userHomeDirProvider.getGradleUserHomeDirectory();
        File gradleProperties = new File(gradleUserHomeDirectory, "gradle.properties");
        if (gradleProperties.isFile()) {
            Properties properties = GUtil.loadProperties((File)gradleProperties);
            String cleanup = properties.getProperty(CACHE_CLEANUP_PROPERTY);
            return cleanup == null || !cleanup.equals("false");
        }
        return true;
    }

    public CleanupAction decorate(CleanupAction cleanup) {
        return (cleanableStore, progressMonitor) -> {
            if (this.isEnabled()) {
                cleanup.clean(cleanableStore, progressMonitor);
            }
        };
    }

    @Override
    public MonitoredCleanupAction decorate(final MonitoredCleanupAction cleanupAction) {
        return new MonitoredCleanupAction(){

            @Override
            public boolean execute(CleanupProgressMonitor progressMonitor) {
                return GradleUserHomeCacheCleanupActionDecorator.this.isEnabled() && cleanupAction.execute(progressMonitor);
            }

            public String getDisplayName() {
                return cleanupAction.getDisplayName();
            }
        };
    }
}

