/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.internal.ServiceLifecycleException;
import org.gradle.internal.Try;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.Managed;

public class BuildServiceProvider<T extends BuildService<P>, P extends BuildServiceParameters>
extends AbstractMinimalProvider<T>
implements Managed {
    private final BuildIdentifier buildIdentifier;
    private final String name;
    private final Class<T> implementationType;
    private final IsolationScheme<BuildService, BuildServiceParameters> isolationScheme;
    private final InstantiationScheme instantiationScheme;
    private final IsolatableFactory isolatableFactory;
    private final ServiceRegistry internalServices;
    private final Listener listener;
    private final P parameters;
    private Try<T> instance;

    public BuildServiceProvider(BuildIdentifier buildIdentifier, String name, Class<T> implementationType, @Nullable P parameters, IsolationScheme<BuildService, BuildServiceParameters> isolationScheme, InstantiationScheme instantiationScheme, IsolatableFactory isolatableFactory, ServiceRegistry internalServices, Listener listener) {
        this.buildIdentifier = buildIdentifier;
        this.name = name;
        this.implementationType = implementationType;
        this.parameters = parameters;
        this.isolationScheme = isolationScheme;
        this.instantiationScheme = instantiationScheme;
        this.isolatableFactory = isolatableFactory;
        this.internalServices = internalServices;
        this.listener = listener;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getImplementationType() {
        return this.implementationType;
    }

    @Nullable
    public P getParameters() {
        return this.parameters;
    }

    @Nullable
    public Class<T> getType() {
        return this.implementationType;
    }

    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return true;
    }

    public boolean isImmutable() {
        return true;
    }

    public Object unpackState() {
        throw new UnsupportedOperationException("Build services cannot be serialized.");
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        return ValueSupplier.Value.of(this.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getInstance() {
        this.listener.beforeGet(this);
        BuildServiceProvider buildServiceProvider = this;
        synchronized (buildServiceProvider) {
            if (this.instance == null) {
                this.instance = this.instantiate();
            }
        }
        return (T)((BuildService)this.instance.get());
    }

    private Try<T> instantiate() {
        BuildServiceParameters isolatedParameters = (BuildServiceParameters)this.isolatableFactory.isolate(this.parameters).isolate();
        ServiceLookup instantiationServices = this.instantiationServicesFor(isolatedParameters);
        try {
            return Try.successful(this.instantiate(instantiationServices));
        }
        catch (Exception e) {
            return Try.failure((Throwable)((Object)this.instantiationException(e)));
        }
    }

    private ServiceLifecycleException instantiationException(Exception e) {
        return new ServiceLifecycleException("Failed to create service '" + this.name + "'.", e);
    }

    private T instantiate(ServiceLookup instantiationServices) {
        return (T)((BuildService)this.instantiationScheme.withServices(instantiationServices).instantiator().newInstance(this.implementationType, new Object[0]));
    }

    private ServiceLookup instantiationServicesFor(@Nullable P isolatedParameters) {
        return this.isolationScheme.servicesForImplementation(isolatedParameters, (ServiceLookup)this.internalServices, (Collection)ImmutableList.of(), serviceType -> false);
    }

    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return ValueSupplier.ExecutionTimeValue.changingValue((ProviderInternal)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeStop() {
        BuildServiceProvider buildServiceProvider = this;
        synchronized (buildServiceProvider) {
            try {
                if (this.instance != null) {
                    this.instance.ifSuccessful(t -> {
                        if (t instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)t).close();
                            }
                            catch (Exception e) {
                                throw new ServiceLifecycleException("Failed to stop service '" + this.name + "'.", e);
                            }
                        }
                    });
                }
            }
            finally {
                this.instance = null;
            }
        }
    }

    public static interface Listener {
        public static final Listener EMPTY = provider -> {};

        public void beforeGet(BuildServiceProvider<?, ?> var1);
    }
}

