/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Queue;
import org.codehaus.groovy.runtime.ConvertedClosure;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.AbstractNestedRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.scripts.ScriptOriginUtil;
import org.gradle.internal.snapshot.impl.ImplementationValue;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;

class NestedRuntimeBeanNode
extends AbstractNestedRuntimeBeanNode {
    public NestedRuntimeBeanNode(RuntimeBeanNode<?> parentNode, String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
    }

    @Override
    public void visitNode(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, TypeValidationContext validationContext) {
        this.visitImplementation(visitor);
        this.visitProperties(visitor, queue, nodeFactory, validationContext);
    }

    private void visitImplementation(PropertyVisitor visitor) {
        Object unwrapped = NestedRuntimeBeanNode.unwrapBean(this.getBean());
        String classIdentifier = ScriptOriginUtil.getOriginClassIdentifier(unwrapped);
        visitor.visitInputProperty(this.getPropertyName(), new ImplementationPropertyValue(new ImplementationValue(classIdentifier, unwrapped)), false);
    }

    @VisibleForTesting
    static Object unwrapBean(Object bean) {
        if (Proxy.isProxyClass(bean.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(bean);
            if (invocationHandler instanceof ConvertedClosure) {
                return ((ConvertedClosure)invocationHandler).getDelegate();
            }
            return invocationHandler;
        }
        if (bean instanceof ConfigureUtil.WrappedConfigureAction) {
            return ((ConfigureUtil.WrappedConfigureAction)bean).getConfigureClosure();
        }
        if (bean instanceof ClosureBackedAction) {
            return ((ClosureBackedAction)bean).getClosure();
        }
        return bean;
    }

    private static class ImplementationPropertyValue
    implements PropertyValue {
        private final ImplementationValue implementationValue;

        public ImplementationPropertyValue(ImplementationValue implementationValue) {
            this.implementationValue = implementationValue;
        }

        @Override
        public Object call() {
            return this.implementationValue;
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }
    }
}

