/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.configurationcache.extensions.UnsafeLazyKt;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.buildoption.InternalFlag;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u0011\u0010%\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u001b\u0010(\u001a\n )*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u0011\u00103\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0019R!\u00105\u001a\b\u0012\u0004\u0012\u00020\u00130\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b6\u0010\rR\u0011\u00109\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0010R\u0011\u0010;\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0010R\u0019\u0010=\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\f\u0012\u0004\b>\u0010?\u001a\u0004\b@\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "", "buildLayout", "Lorg/gradle/initialization/layout/BuildLayout;", "startParameter", "Lorg/gradle/api/internal/StartParameterInternal;", "options", "Lorg/gradle/internal/buildoption/InternalOptions;", "(Lorg/gradle/initialization/layout/BuildLayout;Lorg/gradle/api/internal/StartParameterInternal;Lorg/gradle/internal/buildoption/InternalOptions;)V", "allInitScripts", "", "Ljava/io/File;", "getAllInitScripts", "()Ljava/util/List;", "currentDirectory", "getCurrentDirectory", "()Ljava/io/File;", "excludedTaskNames", "", "", "getExcludedTaskNames", "()Ljava/util/Set;", "failOnProblems", "", "getFailOnProblems", "()Z", "gradleProperties", "", "getGradleProperties", "()Ljava/util/Map;", "gradleUserHomeDir", "getGradleUserHomeDir", "includedBuilds", "getIncludedBuilds", "isDebug", "isOffline", "isQuiet", "isRefreshDependencies", "isUpdateDependencyLocks", "isWriteDependencyLocks", "loadAfterStore", "kotlin.jvm.PlatformType", "getLoadAfterStore", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "maxProblems", "", "getMaxProblems", "()I", "projectDirectory", "getProjectDirectory", "recreateCache", "getRecreateCache", "requestedTaskNames", "getRequestedTaskNames", "requestedTaskNames$delegate", "Lkotlin/Lazy;", "rootDirectory", "getRootDirectory", "settingsDirectory", "getSettingsDirectory", "settingsFile", "getSettingsFile$annotations", "()V", "getSettingsFile", "configuration-cache"})
public final class ConfigurationCacheStartParameter {
    @NotNull
    private final BuildLayout buildLayout;
    @NotNull
    private final StartParameterInternal startParameter;
    private final Boolean loadAfterStore;
    @NotNull
    private final Lazy requestedTaskNames$delegate;

    public ConfigurationCacheStartParameter(@NotNull BuildLayout buildLayout, @NotNull StartParameterInternal startParameter, @NotNull InternalOptions options) {
        Intrinsics.checkNotNullParameter((Object)buildLayout, (String)"buildLayout");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.buildLayout = buildLayout;
        this.startParameter = startParameter;
        this.loadAfterStore = (Boolean)options.getOption((InternalOption)new InternalFlag("org.gradle.configuration-cache.internal.load-after-store")).get();
        this.requestedTaskNames$delegate = UnsafeLazyKt.unsafeLazy((Function0)new Function0<List<String>>(this){
            final /* synthetic */ ConfigurationCacheStartParameter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return ConfigurationCacheStartParameter.access$getStartParameter$p(this.this$0).getTaskNames();
            }
        });
    }

    public final Boolean getLoadAfterStore() {
        return this.loadAfterStore;
    }

    @NotNull
    public final Map<String, Object> getGradleProperties() {
        Map map = this.startParameter.getProjectProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"startParameter.projectProperties");
        return map;
    }

    public final boolean isQuiet() {
        return this.startParameter.isConfigurationCacheQuiet();
    }

    public final int getMaxProblems() {
        return this.startParameter.getConfigurationCacheMaxProblems();
    }

    public final boolean isDebug() {
        return this.startParameter.isConfigurationCacheDebug();
    }

    public final boolean getFailOnProblems() {
        return this.startParameter.getConfigurationCacheProblems() == StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value.FAIL;
    }

    public final boolean getRecreateCache() {
        return this.startParameter.isConfigurationCacheRecreateCache();
    }

    @Nullable
    public final File getProjectDirectory() {
        return this.startParameter.getProjectDir();
    }

    @NotNull
    public final File getCurrentDirectory() {
        File file = this.startParameter.getCurrentDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"startParameter.currentDir");
        return file;
    }

    @NotNull
    public final File getSettingsDirectory() {
        File file = this.buildLayout.getSettingsDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildLayout.settingsDir");
        return file;
    }

    @Nullable
    public final File getSettingsFile() {
        return this.startParameter.getSettingsFile();
    }

    public static /* synthetic */ void getSettingsFile$annotations() {
    }

    @NotNull
    public final File getRootDirectory() {
        File file = this.buildLayout.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildLayout.rootDirectory");
        return file;
    }

    public final boolean isOffline() {
        return this.startParameter.isOffline();
    }

    public final boolean isRefreshDependencies() {
        return this.startParameter.isRefreshDependencies();
    }

    public final boolean isWriteDependencyLocks() {
        return this.startParameter.isWriteDependencyLocks() && !this.isUpdateDependencyLocks();
    }

    public final boolean isUpdateDependencyLocks() {
        List list = this.startParameter.getLockedDependenciesToUpdate();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.lockedDependenciesToUpdate");
        return !((Collection)list).isEmpty();
    }

    @NotNull
    public final List<String> getRequestedTaskNames() {
        Lazy lazy = this.requestedTaskNames$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-requestedTaskNames>(...)");
        return (List)object;
    }

    @NotNull
    public final Set<String> getExcludedTaskNames() {
        Set set2 = this.startParameter.getExcludedTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"startParameter.excludedTaskNames");
        return set2;
    }

    @NotNull
    public final List<File> getAllInitScripts() {
        List list = this.startParameter.getAllInitScripts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.allInitScripts");
        return list;
    }

    @NotNull
    public final File getGradleUserHomeDir() {
        File file = this.startParameter.getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"startParameter.gradleUserHomeDir");
        return file;
    }

    @NotNull
    public final List<File> getIncludedBuilds() {
        List list = this.startParameter.getIncludedBuilds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.includedBuilds");
        return list;
    }

    public static final /* synthetic */ StartParameterInternal access$getStartParameter$p(ConfigurationCacheStartParameter $this) {
        return $this.startParameter;
    }
}

