/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.BoundTransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.Deferrable;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class TransformingAsyncArtifactListener
implements ResolvedArtifactSet.Visitor {
    private final List<BoundTransformationStep> transformationSteps;
    private final ImmutableAttributes target;
    private final List<? extends Capability> capabilities;
    private final ImmutableList.Builder<ResolvedArtifactSet.Artifacts> result;

    public TransformingAsyncArtifactListener(List<BoundTransformationStep> transformationSteps, ImmutableAttributes target, List<? extends Capability> capabilities, ImmutableList.Builder<ResolvedArtifactSet.Artifacts> result) {
        this.transformationSteps = transformationSteps;
        this.target = target;
        this.capabilities = capabilities;
        this.result = result;
    }

    @Override
    public void visitArtifacts(ResolvedArtifactSet.Artifacts artifacts) {
        artifacts.visit(new ArtifactVisitor(){

            @Override
            public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, List<? extends Capability> variantCapabilities, ResolvableArtifact artifact) {
                TransformedArtifact transformedArtifact = new TransformedArtifact(variantName, TransformingAsyncArtifactListener.this.target, TransformingAsyncArtifactListener.this.capabilities, artifact, TransformingAsyncArtifactListener.this.transformationSteps);
                TransformingAsyncArtifactListener.this.result.add((Object)transformedArtifact);
            }

            @Override
            public boolean requireArtifactFiles() {
                return false;
            }

            @Override
            public void visitFailure(Throwable failure) {
                TransformingAsyncArtifactListener.this.result.add((Object)new BrokenArtifacts(failure));
            }
        });
    }

    @Override
    public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
        return FileCollectionStructureVisitor.VisitType.Visit;
    }

    public static class TransformedArtifact
    implements ResolvedArtifactSet.Artifacts,
    RunnableBuildOperation {
        private final DisplayName variantName;
        private final List<? extends Capability> capabilities;
        private final ResolvableArtifact artifact;
        private final ImmutableAttributes target;
        private final List<BoundTransformationStep> transformationSteps;
        private Try<TransformationSubject> transformedSubject;
        private Deferrable<Try<TransformationSubject>> invocation;

        public TransformedArtifact(DisplayName variantName, ImmutableAttributes target, List<? extends Capability> capabilities, ResolvableArtifact artifact, List<BoundTransformationStep> transformationSteps) {
            this.variantName = variantName;
            this.artifact = artifact;
            this.target = target;
            this.capabilities = capabilities;
            this.transformationSteps = transformationSteps;
        }

        public DisplayName getVariantName() {
            return this.variantName;
        }

        public ResolvableArtifact getArtifact() {
            return this.artifact;
        }

        public ImmutableAttributes getTarget() {
            return this.target;
        }

        public List<? extends Capability> getCapabilities() {
            return this.capabilities;
        }

        public List<BoundTransformationStep> getTransformationSteps() {
            return this.transformationSteps;
        }

        @Override
        public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
            if (this.prepareInvocation()) {
                actions.add((BuildOperation)this);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Execute transform");
        }

        public void run(@Nullable BuildOperationContext context) {
            this.finalizeValue();
        }

        @Override
        public void finalizeNow(boolean requireFiles) {
            this.finalizeValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean prepareInvocation() {
            TransformedArtifact transformedArtifact = this;
            synchronized (transformedArtifact) {
                if (this.transformedSubject != null) {
                    return false;
                }
            }
            if (!this.artifact.getFileSource().isFinalized()) {
                return true;
            }
            if (!this.artifact.getFileSource().getValue().isSuccessful()) {
                transformedArtifact = this;
                synchronized (transformedArtifact) {
                    this.transformedSubject = Try.failure((Throwable)((Throwable)this.artifact.getFileSource().getValue().getFailure().get()));
                    return false;
                }
            }
            Deferrable<Try<TransformationSubject>> invocation = this.createInvocation();
            TransformedArtifact transformedArtifact2 = this;
            synchronized (transformedArtifact2) {
                this.invocation = invocation;
                if (invocation.getCompleted().isPresent()) {
                    this.transformedSubject = (Try)invocation.getCompleted().get();
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Try<TransformationSubject> finalizeValue() {
            Deferrable<Try<TransformationSubject>> invocation;
            TransformedArtifact transformedArtifact = this;
            synchronized (transformedArtifact) {
                if (this.transformedSubject != null) {
                    return this.transformedSubject;
                }
            }
            this.artifact.getFileSource().finalizeIfNotAlready();
            if (!this.artifact.getFileSource().getValue().isSuccessful()) {
                transformedArtifact = this;
                synchronized (transformedArtifact) {
                    this.transformedSubject = Try.failure((Throwable)((Throwable)this.artifact.getFileSource().getValue().getFailure().get()));
                    return this.transformedSubject;
                }
            }
            TransformedArtifact transformedArtifact2 = this;
            synchronized (transformedArtifact2) {
                invocation = this.invocation;
            }
            if (invocation == null) {
                invocation = this.createInvocation();
            }
            Try result = (Try)invocation.completeAndGet();
            TransformedArtifact transformedArtifact3 = this;
            synchronized (transformedArtifact3) {
                this.transformedSubject = result;
                return result;
            }
        }

        private Deferrable<Try<TransformationSubject>> createInvocation() {
            TransformationSubject initialSubject = TransformationSubject.initial(this.artifact);
            BoundTransformationStep initialStep = this.transformationSteps.get(0);
            Deferrable invocation = initialStep.getTransformation().createInvocation(initialSubject, initialStep.getUpstreamDependencies(), null);
            for (int i = 1; i < this.transformationSteps.size(); ++i) {
                BoundTransformationStep nextStep = this.transformationSteps.get(i);
                invocation = invocation.flatMap(intermediateResult -> (Deferrable)intermediateResult.map(intermediateSubject -> nextStep.getTransformation().createInvocation((TransformationSubject)intermediateSubject, nextStep.getUpstreamDependencies(), null)).getOrMapFailure(failure -> Deferrable.completed((Object)Try.failure((Throwable)failure))));
            }
            return invocation;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            Try<TransformationSubject> transformedSubject = this.finalizeValue();
            transformedSubject.ifSuccessfulOrElse(subject -> {
                for (File output : subject.getFiles()) {
                    ResolvableArtifact resolvedArtifact = this.artifact.transformedTo(output);
                    visitor.visitArtifact(this.variantName, (AttributeContainer)this.target, this.capabilities, resolvedArtifact);
                }
            }, failure -> visitor.visitFailure((Throwable)((Object)new TransformException(String.format("Failed to transform %s to match attributes %s.", this.artifact.getId(), this.target), (Throwable)failure))));
        }
    }
}

