/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;

public class JavadocExecutableUtils {
    @Nullable
    public static JavaToolchainSpec getExecutableOverrideToolchainSpec(Javadoc task, ObjectFactory objectFactory) {
        String customExecutable = task.getExecutable();
        if (customExecutable != null) {
            File executable = new File(customExecutable);
            if (executable.exists()) {
                File parentJavaHome = executable.getParentFile().getParentFile();
                return new SpecificInstallationToolchainSpec(objectFactory, parentJavaHome);
            }
            throw new InvalidUserDataException("The configured executable does not exist (" + executable.getAbsolutePath() + ")");
        }
        return null;
    }
}

