/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;

public class JavaCompileExecutableUtils {
    @Nullable
    public static JavaToolchainSpec getExecutableOverrideToolchainSpec(JavaCompile task, ObjectFactory objectFactory) {
        if (!task.getOptions().isFork()) {
            return null;
        }
        ForkOptions forkOptions = task.getOptions().getForkOptions();
        File customJavaHome = forkOptions.getJavaHome();
        if (customJavaHome != null) {
            return new SpecificInstallationToolchainSpec(objectFactory, customJavaHome);
        }
        String customExecutable = forkOptions.getExecutable();
        if (customExecutable != null) {
            File executable = new File(customExecutable);
            if (executable.exists()) {
                File parentJavaHome = executable.getParentFile().getParentFile();
                return new SpecificInstallationToolchainSpec(objectFactory, parentJavaHome);
            }
            throw new InvalidUserDataException("The configured executable does not exist (" + executable.getAbsolutePath() + ")");
        }
        return null;
    }
}

