/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.GroovySystem;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.quality.CodeNarc;
import org.gradle.api.plugins.quality.CodeNarcExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.VersionNumber;

public class CodeNarcPlugin
extends AbstractCodeQualityPlugin<CodeNarc> {
    public static final String DEFAULT_CODENARC_VERSION = CodeNarcPlugin.appropriateCodeNarcVersion();
    private CodeNarcExtension extension;

    @Override
    protected String getToolName() {
        return "CodeNarc";
    }

    @Override
    protected Class<CodeNarc> getTaskType() {
        return CodeNarc.class;
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<? extends Plugin> getBasePlugin() {
        return GroovyBasePlugin.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (CodeNarcExtension)this.project.getExtensions().create("codenarc", CodeNarcExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_CODENARC_VERSION);
        this.extension.setConfig(this.project.getResources().getText().fromFile((Object)this.project.getRootProject().file((Object)"config/codenarc/codenarc.xml")));
        this.extension.setMaxPriority1Violations(0);
        this.extension.setMaxPriority2Violations(0);
        this.extension.setMaxPriority3Violations(0);
        this.extension.setReportFormat("html");
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(CodeNarc task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
        this.configureToolchains(task);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.codenarc:CodeNarc:" + this.extension.getToolVersion()))));
    }

    private void configureTaskConventionMapping(Configuration configuration, CodeNarc task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("codenarcClasspath", () -> configuration);
        taskMapping.map("config", () -> this.extension.getConfig());
        taskMapping.map("maxPriority1Violations", () -> this.extension.getMaxPriority1Violations());
        taskMapping.map("maxPriority2Violations", () -> this.extension.getMaxPriority2Violations());
        taskMapping.map("maxPriority3Violations", () -> this.extension.getMaxPriority3Violations());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
    }

    private void configureReportsConventionMapping(CodeNarc task, String baseName) {
        ProjectLayout layout = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider reportFormat = providers.provider(() -> this.extension.getReportFormat());
        Provider reportsDir = layout.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
            report.getRequired().convention(providers.provider(() -> report.getName().equals(reportFormat.get())));
            report.getOutputLocation().convention(layout.getProjectDirectory().file(providers.provider(() -> {
                String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), baseName + "." + fileSuffix).getAbsolutePath();
            })));
        }));
    }

    private void configureToolchains(CodeNarc task) {
        Provider javaLauncherProvider = this.getToolchainService().launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(this.project.getObjects()));
        task.getJavaLauncher().convention(javaLauncherProvider);
        this.project.getPluginManager().withPlugin("java-base", p -> {
            JavaToolchainSpec toolchain = this.getJavaPluginExtension().getToolchain();
            task.getJavaLauncher().convention(this.getToolchainService().launcherFor(toolchain).orElse(javaLauncherProvider));
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, CodeNarc task) {
        task.setDescription("Run CodeNarc analysis for " + sourceSet.getName() + " classes");
        SourceDirectorySet groovySourceSet = (SourceDirectorySet)sourceSet.getExtensions().getByType(GroovySourceDirectorySet.class);
        task.setSource(groovySourceSet.matching(filter -> filter.include(new String[]{"**/*.groovy"})));
    }

    private static String appropriateCodeNarcVersion() {
        int groovyMajorVersion = VersionNumber.parse((String)GroovySystem.getVersion()).getMajor();
        return groovyMajorVersion < 4 ? "3.1.0" : "3.1.0-groovy-4.0";
    }
}

