/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentGraphResolveState;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentResolveResult {
    private ComponentGraphResolveState state;
    private ModuleVersionResolveException failure;

    @Override
    public DefaultBuildableComponentResolveResult failed(ModuleVersionResolveException failure) {
        this.state = null;
        this.failure = failure;
        return this;
    }

    @Override
    public void notFound(ModuleComponentIdentifier versionIdentifier) {
        this.failed(new ModuleVersionNotFoundException(DefaultModuleVersionIdentifier.newId(versionIdentifier), this.getAttempted()));
    }

    @Override
    public void resolved(ComponentGraphResolveState state) {
        this.state = state;
    }

    @Override
    public void resolved(ComponentResolveMetadata metadata) {
        this.resolved(new DefaultComponentGraphResolveState<ComponentResolveMetadata>(metadata));
    }

    @Override
    public void setResult(ComponentGraphResolveState state) {
        this.assertResolved();
        this.state = state;
    }

    @Override
    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.state.getId();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.state.getMetadata().getModuleVersionId();
    }

    @Override
    public ComponentGraphResolveState getState() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.state;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    @Override
    public boolean hasResult() {
        return this.failure != null || this.state != null;
    }

    public void applyTo(BuildableComponentIdResolveResult idResolve) {
        super.applyTo(idResolve);
        if (this.failure != null) {
            idResolve.failed(this.failure);
        }
        if (this.state != null) {
            idResolve.resolved(this.state);
        }
    }
}

