/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.classpath.Instrumented;

class InstrumentedListenerHolder {
    private static final Instrumented.Listener NO_OP = InstrumentedListenerHolder.createNoOp();
    private volatile Instrumented.Listener global = NO_OP;
    private final ThreadLocal<Boolean> enabledForCurrentThread = ThreadLocal.withInitial(() -> true);

    InstrumentedListenerHolder() {
    }

    public void setGlobalListener(Instrumented.Listener listener) {
        this.global = listener;
    }

    public void discardGlobalListener() {
        this.global = NO_OP;
    }

    public Instrumented.Listener listenerForCurrentThread() {
        return this.enabledForCurrentThread.get() != false ? this.global : NO_OP;
    }

    public void disableListenerForCurrentThread() {
        this.enabledForCurrentThread.set(false);
    }

    public void restoreListenerForCurrentThread() {
        this.enabledForCurrentThread.set(true);
    }

    private static Instrumented.Listener createNoOp() {
        return new Instrumented.Listener(){

            @Override
            public void systemPropertyQueried(String key, @Nullable Object value, String consumer) {
            }

            @Override
            public void systemPropertyChanged(Object key, @Nullable Object value, String consumer) {
            }

            @Override
            public void systemPropertyRemoved(Object key, String consumer) {
            }

            @Override
            public void systemPropertiesCleared(String consumer) {
            }

            @Override
            public void envVariableQueried(String key, @Nullable String value, String consumer) {
            }

            @Override
            public void externalProcessStarted(String command, String consumer) {
            }

            @Override
            public void fileOpened(File file, String consumer) {
            }

            @Override
            public void fileObserved(File file, String consumer) {
            }

            @Override
            public void fileCollectionObserved(FileCollection fileCollection, String consumer) {
            }
        };
    }
}

