/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaExecSpec;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Gradle would require more information to cache this task")
public class JavaExec
extends ConventionTask
implements JavaExecSpec {
    private final DefaultJavaExecSpec javaExecSpec;
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private final ModularitySpec modularity;
    private final Property<ExecResult> execResult;
    private final Property<JavaLauncher> javaLauncher;

    public JavaExec() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.mainModule = objectFactory.property(String.class);
        this.mainClass = objectFactory.property(String.class);
        this.modularity = (ModularitySpec)objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.execResult = objectFactory.property(ExecResult.class);
        this.javaExecSpec = (DefaultJavaExecSpec)objectFactory.newInstance(DefaultJavaExecSpec.class, new Object[0]);
        this.javaExecSpec.getMainClass().convention(this.mainClass);
        this.javaExecSpec.getMainModule().convention(this.mainModule);
        this.javaExecSpec.getModularity().getInferModulePath().convention((Provider)this.modularity.getInferModulePath());
        this.javaLauncher = objectFactory.property(JavaLauncher.class);
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void exec() {
        this.setJvmArgs(this.getJvmArgs());
        JavaExecAction javaExecAction = this.getExecActionFactory().newJavaExecAction();
        this.javaExecSpec.copyTo((JavaExecSpec)javaExecAction);
        javaExecAction.setExecutable(this.getEffectiveExecutable());
        this.execResult.set((Object)javaExecAction.execute());
    }

    public List<String> getAllJvmArgs() {
        return this.javaExecSpec.getAllJvmArgs();
    }

    public void setAllJvmArgs(List<String> arguments) {
        this.javaExecSpec.setAllJvmArgs(arguments);
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.javaExecSpec.setAllJvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        return this.javaExecSpec.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.javaExecSpec.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.javaExecSpec.setJvmArgs(arguments);
    }

    public JavaExec jvmArgs(Iterable<?> arguments) {
        this.javaExecSpec.jvmArgs(arguments);
        return this;
    }

    public JavaExec jvmArgs(Object ... arguments) {
        this.javaExecSpec.jvmArgs(arguments);
        return this;
    }

    public Map<String, Object> getSystemProperties() {
        return this.javaExecSpec.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.javaExecSpec.setSystemProperties(properties);
    }

    public JavaExec systemProperties(Map<String, ?> properties) {
        this.javaExecSpec.systemProperties(properties);
        return this;
    }

    public JavaExec systemProperty(String name, Object value) {
        this.javaExecSpec.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.javaExecSpec.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaExecSpec.setBootstrapClasspath(classpath);
    }

    public JavaExec bootstrapClasspath(Object ... classpath) {
        this.javaExecSpec.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.javaExecSpec.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.javaExecSpec.setMinHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.javaExecSpec.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaExecSpec.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public String getMaxHeapSize() {
        return this.javaExecSpec.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.javaExecSpec.setMaxHeapSize(heapSize);
    }

    public boolean getEnableAssertions() {
        return this.javaExecSpec.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.javaExecSpec.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.javaExecSpec.getDebug();
    }

    @Option(option="debug-jvm", description="Enable debugging for the process. The process is started suspended and listening on port 5005.")
    public void setDebug(boolean enabled) {
        this.javaExecSpec.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.javaExecSpec.getDebugOptions();
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaExecSpec.debugOptions(action);
    }

    public Property<String> getMainModule() {
        return this.mainModule;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public List<String> getArgs() {
        return this.javaExecSpec.getArgs();
    }

    @Option(option="args", description="Command line arguments passed to the main class.")
    public JavaExec setArgsString(String args) {
        return this.setArgs((List)Arrays.asList(Commandline.translateCommandline((String)args)));
    }

    public JavaExec setArgs(List<String> applicationArgs) {
        this.javaExecSpec.setArgs(applicationArgs);
        return this;
    }

    public JavaExec setArgs(Iterable<?> applicationArgs) {
        this.javaExecSpec.setArgs(applicationArgs);
        return this;
    }

    public JavaExec args(Object ... args) {
        this.javaExecSpec.args(args);
        return this;
    }

    public JavaExecSpec args(Iterable<?> args) {
        this.javaExecSpec.args(args);
        return this;
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.javaExecSpec.getArgumentProviders();
    }

    public JavaExec setClasspath(FileCollection classpath) {
        this.javaExecSpec.setClasspath(classpath);
        return this;
    }

    public JavaExec classpath(Object ... paths) {
        this.javaExecSpec.classpath(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.javaExecSpec.getClasspath();
    }

    public ModularitySpec getModularity() {
        return this.modularity;
    }

    public JavaExec copyTo(JavaForkOptions options) {
        this.javaExecSpec.copyTo(options);
        return this;
    }

    @Input
    public JavaVersion getJavaVersion() {
        return ((JvmVersionDetector)this.getServices().get(JvmVersionDetector.class)).getJavaVersion(this.getEffectiveExecutable());
    }

    @Internal(value="covered by getJavaVersion")
    @Nullable
    public String getExecutable() {
        return this.javaExecSpec.getExecutable();
    }

    public void setExecutable(String executable) {
        this.javaExecSpec.setExecutable(executable);
    }

    public void setExecutable(Object executable) {
        this.javaExecSpec.setExecutable(executable);
    }

    public JavaExec executable(Object executable) {
        this.javaExecSpec.executable(executable);
        return this;
    }

    @Internal
    public File getWorkingDir() {
        return this.javaExecSpec.getWorkingDir();
    }

    public void setWorkingDir(File dir) {
        this.javaExecSpec.setWorkingDir(dir);
    }

    public void setWorkingDir(Object dir) {
        this.javaExecSpec.setWorkingDir(dir);
    }

    public JavaExec workingDir(Object dir) {
        this.javaExecSpec.workingDir(dir);
        return this;
    }

    @Internal
    public Map<String, Object> getEnvironment() {
        return this.javaExecSpec.getEnvironment();
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.javaExecSpec.setEnvironment(environmentVariables);
    }

    public JavaExec environment(String name, Object value) {
        this.javaExecSpec.environment(name, value);
        return this;
    }

    public JavaExec environment(Map<String, ?> environmentVariables) {
        this.javaExecSpec.environment(environmentVariables);
        return this;
    }

    public JavaExec copyTo(ProcessForkOptions target) {
        this.javaExecSpec.copyTo(target);
        return this;
    }

    public JavaExec setStandardInput(InputStream inputStream) {
        this.javaExecSpec.setStandardInput(inputStream);
        return this;
    }

    @Internal
    public InputStream getStandardInput() {
        return this.javaExecSpec.getStandardInput();
    }

    public JavaExec setStandardOutput(OutputStream outputStream) {
        this.javaExecSpec.setStandardOutput(outputStream);
        return this;
    }

    @Internal
    public OutputStream getStandardOutput() {
        return this.javaExecSpec.getStandardOutput();
    }

    public JavaExec setErrorOutput(OutputStream outputStream) {
        this.javaExecSpec.setErrorOutput(outputStream);
        return this;
    }

    @Internal
    public OutputStream getErrorOutput() {
        return this.javaExecSpec.getErrorOutput();
    }

    public JavaExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.javaExecSpec.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Input
    public boolean isIgnoreExitValue() {
        return this.javaExecSpec.isIgnoreExitValue();
    }

    @Internal
    public List<String> getCommandLine() {
        return this.javaExecSpec.getCommandLine();
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaExecSpec.getJvmArgumentProviders();
    }

    @Internal
    public Provider<ExecResult> getExecutionResult() {
        return this.execResult;
    }

    @Nested
    @Optional
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    private String getEffectiveExecutable() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getExecutablePath().toString();
        }
        String executable = this.getExecutable();
        if (executable != null) {
            return executable;
        }
        return Jvm.current().getJavaExecutable().getAbsolutePath();
    }
}

