/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import com.google.common.collect.Interner;
import java.io.Closeable;
import java.io.File;
import java.util.function.Function;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionHistoryStore;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;

public class DefaultImmutableWorkspaceProvider
implements WorkspaceProvider,
Closeable {
    private static final int DEFAULT_FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File baseDirectory;
    private final ExecutionHistoryStore executionHistoryStore;
    private final PersistentCache cache;

    public static DefaultImmutableWorkspaceProvider withBuiltInHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner stringInterner, ClassLoaderHierarchyHasher classLoaderHasher, CleanupActionDecorator cleanupActionDecorator) {
        return DefaultImmutableWorkspaceProvider.withBuiltInHistory(cacheBuilder, fileAccessTimeJournal, inMemoryCacheDecoratorFactory, stringInterner, classLoaderHasher, 1, cleanupActionDecorator);
    }

    public static DefaultImmutableWorkspaceProvider withBuiltInHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner stringInterner, ClassLoaderHierarchyHasher classLoaderHasher, int treeDepthToTrackAndCleanup, CleanupActionDecorator cleanupActionDecorator) {
        return new DefaultImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, cache -> new DefaultExecutionHistoryStore(() -> cache, inMemoryCacheDecoratorFactory, (Interner<String>)stringInterner, classLoaderHasher), treeDepthToTrackAndCleanup, cleanupActionDecorator);
    }

    public static DefaultImmutableWorkspaceProvider withExternalHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, ExecutionHistoryStore executionHistoryStore, CleanupActionDecorator cleanupActionDecorator) {
        return new DefaultImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, __ -> executionHistoryStore, 1, cleanupActionDecorator);
    }

    private DefaultImmutableWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, Function<PersistentCache, ExecutionHistoryStore> historyFactory, int treeDepthToTrackAndCleanup, CleanupActionDecorator cleanupActionDecorator) {
        PersistentCache cache;
        this.cache = cache = cacheBuilder.withCleanup(cleanupActionDecorator.decorate(DefaultImmutableWorkspaceProvider.createCleanupAction(fileAccessTimeJournal, treeDepthToTrackAndCleanup))).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        this.baseDirectory = cache.getBaseDir();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.baseDirectory, treeDepthToTrackAndCleanup);
        this.executionHistoryStore = historyFactory.apply(cache);
    }

    private static CleanupAction createCleanupAction(FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup) {
        return new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(treeDepthToTrackAndCleanup), fileAccessTimeJournal, 7L);
    }

    @Override
    public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
        return (T)this.cache.withFileLock(() -> {
            File workspace = new File(this.baseDirectory, path);
            this.fileAccessTracker.markAccessed(workspace);
            return action.executeInWorkspace(workspace, this.executionHistoryStore);
        });
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

