/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.api.internal.provider.DefaultConfigurationTimeBarrier;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.configurationcache.BuildTreeConfigurationCache;
import org.gradle.configurationcache.CheckedFingerprint;
import org.gradle.configurationcache.ConfigurationCacheAction;
import org.gradle.configurationcache.ConfigurationCacheBuild;
import org.gradle.configurationcache.ConfigurationCacheBuildOperationsKt;
import org.gradle.configurationcache.ConfigurationCacheClassLoaderScopeRegistryListener;
import org.gradle.configurationcache.ConfigurationCacheError;
import org.gradle.configurationcache.ConfigurationCacheIO;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheRepository;
import org.gradle.configurationcache.ConfigurationCacheStateFile;
import org.gradle.configurationcache.ConfigurationCacheStateStore;
import org.gradle.configurationcache.DefaultConfigurationCache;
import org.gradle.configurationcache.DefaultConfigurationCacheKt;
import org.gradle.configurationcache.InstrumentedInputAccessListener;
import org.gradle.configurationcache.StateType;
import org.gradle.configurationcache.VintageGradleBuild;
import org.gradle.configurationcache.cacheentry.EntryDetails;
import org.gradle.configurationcache.extensions.CastExtensionsKt;
import org.gradle.configurationcache.fingerprint.ConfigurationCacheFingerprintController;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.metadata.ProjectMetadataController;
import org.gradle.configurationcache.models.IntermediateModelController;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems;
import org.gradle.configurationcache.serialization.Codec;
import org.gradle.configurationcache.serialization.DefaultReadContext;
import org.gradle.configurationcache.serialization.DefaultWriteContext;
import org.gradle.configurationcache.serialization.IsolateOwner;
import org.gradle.configurationcache.serialization.MutableIsolateContext;
import org.gradle.configurationcache.serialization.ReadContext;
import org.gradle.configurationcache.serialization.codecs.Codecs;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildTreeWorkGraph;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0093\u0001Bo\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010>\u001a\u00020?2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020EH\u0002J\u0018\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u0018\u0010M\u001a\u00020E2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010N\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010O\u001a\u00020?H\u0002J\b\u0010P\u001a\u00020\u001fH\u0002J\b\u0010Q\u001a\u00020?H\u0002J\b\u0010R\u001a\u00020?H\u0016J\b\u0010S\u001a\u00020?H\u0016J3\u0010T\u001a\u0002HU\"\b\b\u0000\u0010U*\u00020V2\u0006\u0010W\u001a\u00020X2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u0002HU0ZH\u0002\u00a2\u0006\u0002\u0010[J\b\u0010\\\u001a\u00020?H\u0002J\b\u0010]\u001a\u00020VH\u0002J7\u0010^\u001a\u0004\u0018\u0001HU\"\u0004\b\u0000\u0010U2\b\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010a\u001a\u00020b2\u000e\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HU0dH\u0016\u00a2\u0006\u0002\u0010eJ%\u0010f\u001a\u0002HU\"\b\b\u0000\u0010U*\u00020V2\f\u0010c\u001a\b\u0012\u0004\u0012\u0002HU0dH\u0016\u00a2\u0006\u0002\u0010gJ\u001e\u0010h\u001a\u00020i2\u0006\u0010_\u001a\u00020`2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020i0dH\u0016J$\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020m2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020m\u0012\u0004\u0012\u00020o0ZH\u0016J\u0010\u0010p\u001a\u00020o2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010q\u001a\u00020o2\u0006\u0010l\u001a\u00020mH\u0002J-\u0010r\u001a\u00020?2\u0006\u0010s\u001a\u00020b2\u0016\u0010t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010V0u\"\u0004\u0018\u00010VH\u0002\u00a2\u0006\u0002\u0010vJ-\u0010w\u001a\u00020?2\u0006\u0010s\u001a\u00020b2\u0016\u0010t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010V0u\"\u0004\u0018\u00010VH\u0002\u00a2\u0006\u0002\u0010vJ\u0016\u0010x\u001a\u00020?2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020?0dH\u0016J\b\u0010y\u001a\u00020?H\u0002J\b\u0010z\u001a\u00020?H\u0002JO\u0010{\u001a\u0002HU\"\u0004\b\u0000\u0010U2\u0006\u0010F\u001a\u00020G2.\u0010Y\u001a*\b\u0001\u0012\u0004\u0012\u00020}\u0012\u0004\u0012\u00020~\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0\u007f\u0012\u0006\u0012\u0004\u0018\u00010V0|\u00a2\u0006\u0003\b\u0080\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0081\u0001J\u001a\u0010\u0082\u0001\u001a\u00020?2\u000f\u0010\u0083\u0001\u001a\n\u0012\u0005\u0012\u00030\u0085\u00010\u0084\u0001H\u0002J\"\u0010\u0086\u0001\u001a\u0002HU\"\u0004\b\u0000\u0010U2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002HU0dH\u0002\u00a2\u0006\u0002\u0010gJ\u0012\u0010\u0087\u0001\u001a\u00020?2\u0007\u0010\u0088\u0001\u001a\u00020VH\u0002J%\u0010\u0089\u0001\u001a\u00020?2\u0006\u0010W\u001a\u00020X2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020?0ZH\u0002J\t\u0010\u008a\u0001\u001a\u00020?H\u0002J\t\u0010\u008b\u0001\u001a\u00020?H\u0002J\t\u0010\u008c\u0001\u001a\u00020?H\u0016J\t\u0010\u008d\u0001\u001a\u00020?H\u0002J!\u0010\u008e\u0001\u001a\u00020?2\u0006\u0010K\u001a\u00020L2\u000e\u0010\u008f\u0001\u001a\t\u0012\u0004\u0012\u00020`0\u0090\u0001H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020?2\u0007\u0010\u0092\u0001\u001a\u00020GH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020803X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00109\u001a\u00020:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010%\u001a\u0004\b;\u0010<R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0094\u0001"}, d2={"Lorg/gradle/configurationcache/DefaultConfigurationCache;", "Lorg/gradle/configurationcache/BuildTreeConfigurationCache;", "Lorg/gradle/internal/concurrent/Stoppable;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "problems", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "scopeRegistryListener", "Lorg/gradle/configurationcache/ConfigurationCacheClassLoaderScopeRegistryListener;", "cacheRepository", "Lorg/gradle/configurationcache/ConfigurationCacheRepository;", "instrumentedInputAccessListener", "Lorg/gradle/configurationcache/InstrumentedInputAccessListener;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "buildActionModelRequirements", "Lorg/gradle/internal/buildtree/BuildActionModelRequirements;", "buildStateRegistry", "Lorg/gradle/internal/build/BuildStateRegistry;", "virtualFileSystem", "Lorg/gradle/internal/watch/vfs/BuildLifecycleAwareVirtualFileSystem;", "buildOperationExecutor", "Lorg/gradle/internal/operations/BuildOperationExecutor;", "cacheFingerprintController", "Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprintController;", "fileSystemAccess", "Lorg/gradle/internal/vfs/FileSystemAccess;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;Lorg/gradle/configurationcache/ConfigurationCacheClassLoaderScopeRegistryListener;Lorg/gradle/configurationcache/ConfigurationCacheRepository;Lorg/gradle/configurationcache/InstrumentedInputAccessListener;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/buildtree/BuildActionModelRequirements;Lorg/gradle/internal/build/BuildStateRegistry;Lorg/gradle/internal/watch/vfs/BuildLifecycleAwareVirtualFileSystem;Lorg/gradle/internal/operations/BuildOperationExecutor;Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprintController;Lorg/gradle/internal/vfs/FileSystemAccess;)V", "cacheAction", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "cacheIO", "Lorg/gradle/configurationcache/ConfigurationCacheIO;", "getCacheIO", "()Lorg/gradle/configurationcache/ConfigurationCacheIO;", "cacheIO$delegate", "Lkotlin/Lazy;", "configurationCacheLogLevel", "Lorg/gradle/api/logging/LogLevel;", "getConfigurationCacheLogLevel", "()Lorg/gradle/api/logging/LogLevel;", "gradlePropertiesController", "Lorg/gradle/initialization/GradlePropertiesController;", "getGradlePropertiesController", "()Lorg/gradle/initialization/GradlePropertiesController;", "hasSavedValues", "", "host", "Lorg/gradle/configurationcache/DefaultConfigurationCache$Host;", "intermediateModels", "Lkotlin/Lazy;", "Lorg/gradle/configurationcache/models/IntermediateModelController;", "isLoaded", "()Z", "projectMetadata", "Lorg/gradle/configurationcache/metadata/ProjectMetadataController;", "store", "Lorg/gradle/configurationcache/ConfigurationCacheStateStore;", "getStore", "()Lorg/gradle/configurationcache/ConfigurationCacheStateStore;", "store$delegate", "attachRootBuild", "", "cacheFingerprintWriterContextFor", "Lorg/gradle/configurationcache/serialization/DefaultWriteContext;", "outputStream", "Ljava/io/OutputStream;", "checkBuildScopedFingerprint", "Lorg/gradle/configurationcache/CheckedFingerprint;", "fingerprintFile", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "checkFingerprint", "entryDetails", "Lorg/gradle/configurationcache/cacheentry/EntryDetails;", "layout", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "checkFingerprintAgainstLoadedProperties", "checkProjectScopedFingerprint", "crossConfigurationTimeBarrier", "determineCacheAction", "doneWithWork", "finalizeCacheEntry", "initializeCacheEntry", "loadFromCache", "T", "", "stateType", "Lorg/gradle/configurationcache/StateType;", "action", "Lkotlin/Function1;", "(Lorg/gradle/configurationcache/StateType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadGradleProperties", "loadModel", "loadOrCreateIntermediateModel", "identityPath", "Lorg/gradle/util/Path;", "modelName", "", "creator", "Lkotlin/Function0;", "(Lorg/gradle/util/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "loadOrCreateModel", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "loadOrCreateProjectMetadata", "Lorg/gradle/internal/component/local/model/LocalComponentMetadata;", "loadOrScheduleRequestedTasks", "Lorg/gradle/configurationcache/BuildTreeConfigurationCache$WorkGraphResult;", "graph", "Lorg/gradle/internal/buildtree/BuildTreeWorkGraph;", "scheduler", "Lorg/gradle/internal/buildtree/BuildTreeWorkGraph$FinalizedGraph;", "loadRequestedTasks", "loadWorkGraph", "log", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "logBootstrapSummary", "maybePrepareModel", "prepareConfigurationTimeBarrier", "prepareForWork", "readFingerprintFile", "Lkotlin/Function3;", "Lorg/gradle/configurationcache/serialization/ReadContext;", "Lorg/gradle/configurationcache/fingerprint/ConfigurationCacheFingerprintController$Host;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lorg/gradle/configurationcache/ConfigurationCacheStateFile;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "registerWatchableBuildDirectories", "buildDirs", "", "Ljava/io/File;", "runWorkThatContributesToCacheEntry", "saveModel", "model", "saveToCache", "saveWorkGraph", "startCollectingCacheFingerprint", "stop", "unloadGradleProperties", "writeConfigurationCacheFingerprint", "reusedProjects", "", "writeConfigurationCacheState", "stateFile", "Host", "configuration-cache"})
public final class DefaultConfigurationCache
implements BuildTreeConfigurationCache,
Stoppable {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final ConfigurationCacheKey cacheKey;
    @NotNull
    private final ConfigurationCacheProblems problems;
    @NotNull
    private final ConfigurationCacheClassLoaderScopeRegistryListener scopeRegistryListener;
    @NotNull
    private final ConfigurationCacheRepository cacheRepository;
    @NotNull
    private final InstrumentedInputAccessListener instrumentedInputAccessListener;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final BuildActionModelRequirements buildActionModelRequirements;
    @NotNull
    private final BuildStateRegistry buildStateRegistry;
    @NotNull
    private final BuildLifecycleAwareVirtualFileSystem virtualFileSystem;
    @NotNull
    private final BuildOperationExecutor buildOperationExecutor;
    @NotNull
    private final ConfigurationCacheFingerprintController cacheFingerprintController;
    @NotNull
    private final FileSystemAccess fileSystemAccess;
    private ConfigurationCacheAction cacheAction;
    private boolean hasSavedValues;
    private Host host;
    @NotNull
    private final Lazy store$delegate;
    @NotNull
    private final Lazy<IntermediateModelController> intermediateModels;
    @NotNull
    private final Lazy<ProjectMetadataController> projectMetadata;
    @NotNull
    private final Lazy cacheIO$delegate;

    public DefaultConfigurationCache(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheKey cacheKey, @NotNull ConfigurationCacheProblems problems, @NotNull ConfigurationCacheClassLoaderScopeRegistryListener scopeRegistryListener, @NotNull ConfigurationCacheRepository cacheRepository, @NotNull InstrumentedInputAccessListener instrumentedInputAccessListener, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull BuildActionModelRequirements buildActionModelRequirements, @NotNull BuildStateRegistry buildStateRegistry2, @NotNull BuildLifecycleAwareVirtualFileSystem virtualFileSystem, @NotNull BuildOperationExecutor buildOperationExecutor, @NotNull ConfigurationCacheFingerprintController cacheFingerprintController, @NotNull FileSystemAccess fileSystemAccess) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)scopeRegistryListener, (String)"scopeRegistryListener");
        Intrinsics.checkNotNullParameter((Object)cacheRepository, (String)"cacheRepository");
        Intrinsics.checkNotNullParameter((Object)instrumentedInputAccessListener, (String)"instrumentedInputAccessListener");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)buildActionModelRequirements, (String)"buildActionModelRequirements");
        Intrinsics.checkNotNullParameter((Object)buildStateRegistry2, (String)"buildStateRegistry");
        Intrinsics.checkNotNullParameter((Object)virtualFileSystem, (String)"virtualFileSystem");
        Intrinsics.checkNotNullParameter((Object)buildOperationExecutor, (String)"buildOperationExecutor");
        Intrinsics.checkNotNullParameter((Object)cacheFingerprintController, (String)"cacheFingerprintController");
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        this.startParameter = startParameter;
        this.cacheKey = cacheKey;
        this.problems = problems;
        this.scopeRegistryListener = scopeRegistryListener;
        this.cacheRepository = cacheRepository;
        this.instrumentedInputAccessListener = instrumentedInputAccessListener;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.buildActionModelRequirements = buildActionModelRequirements;
        this.buildStateRegistry = buildStateRegistry2;
        this.virtualFileSystem = virtualFileSystem;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cacheFingerprintController = cacheFingerprintController;
        this.fileSystemAccess = fileSystemAccess;
        this.store$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurationCacheStateStore>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ConfigurationCacheStateStore invoke() {
                return DefaultConfigurationCache.access$getCacheRepository$p(this.this$0).forKey(DefaultConfigurationCache.access$getCacheKey$p(this.this$0).getString());
            }
        }));
        this.intermediateModels = LazyKt.lazy((Function0)((Function0)new Function0<IntermediateModelController>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IntermediateModelController invoke() {
                Host host = DefaultConfigurationCache.access$getHost$p(this.this$0);
                if (host == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    host = null;
                }
                return new IntermediateModelController(host, DefaultConfigurationCache.access$getCacheIO(this.this$0), DefaultConfigurationCache.access$getStore(this.this$0), DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0));
            }
        }));
        this.projectMetadata = LazyKt.lazy((Function0)((Function0)new Function0<ProjectMetadataController>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectMetadataController invoke() {
                Host host = DefaultConfigurationCache.access$getHost$p(this.this$0);
                if (host == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    host = null;
                }
                return new ProjectMetadataController(host, DefaultConfigurationCache.access$getCacheIO(this.this$0), DefaultConfigurationCache.access$getStore(this.this$0));
            }
        }));
        this.cacheIO$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurationCacheIO>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ConfigurationCacheIO invoke() {
                Host host = DefaultConfigurationCache.access$getHost$p(this.this$0);
                if (host == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    host = null;
                }
                Host $this$service$iv = host;
                boolean $i$f$service = false;
                return $this$service$iv.service(ConfigurationCacheIO.class);
            }
        }));
    }

    private final ConfigurationCacheStateStore getStore() {
        Lazy lazy = this.store$delegate;
        return (ConfigurationCacheStateStore)lazy.getValue();
    }

    private final ConfigurationCacheIO getCacheIO() {
        Lazy lazy = this.cacheIO$delegate;
        return (ConfigurationCacheIO)lazy.getValue();
    }

    private final GradlePropertiesController getGradlePropertiesController() {
        Host host = this.host;
        if (host == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
            host = null;
        }
        Host $this$service$iv = host;
        boolean $i$f$service = false;
        return $this$service$iv.service(GradlePropertiesController.class);
    }

    @Override
    public boolean isLoaded() {
        ConfigurationCacheAction configurationCacheAction = this.cacheAction;
        if (configurationCacheAction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            configurationCacheAction = null;
        }
        return configurationCacheAction == ConfigurationCacheAction.LOAD;
    }

    @Override
    public void initializeCacheEntry() {
        this.cacheAction = this.determineCacheAction();
        ConfigurationCacheAction configurationCacheAction = this.cacheAction;
        if (configurationCacheAction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            configurationCacheAction = null;
        }
        this.problems.action(configurationCacheAction);
    }

    @Override
    public void attachRootBuild(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
    }

    @Override
    @NotNull
    public BuildTreeConfigurationCache.WorkGraphResult loadOrScheduleRequestedTasks(@NotNull BuildTreeWorkGraph graph, @NotNull Function1<? super BuildTreeWorkGraph, ? extends BuildTreeWorkGraph.FinalizedGraph> scheduler) {
        BuildTreeConfigurationCache.WorkGraphResult workGraphResult;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(scheduler, (String)"scheduler");
        if (this.isLoaded()) {
            BuildTreeWorkGraph.FinalizedGraph finalizedGraph = this.loadWorkGraph(graph);
            workGraphResult = new BuildTreeConfigurationCache.WorkGraphResult(finalizedGraph, true, false);
        } else {
            workGraphResult = (BuildTreeConfigurationCache.WorkGraphResult)this.runWorkThatContributesToCacheEntry((Function0)new Function0<BuildTreeConfigurationCache.WorkGraphResult>(scheduler, graph, this){
                final /* synthetic */ Function1<BuildTreeWorkGraph, BuildTreeWorkGraph.FinalizedGraph> $scheduler;
                final /* synthetic */ BuildTreeWorkGraph $graph;
                final /* synthetic */ DefaultConfigurationCache this$0;
                {
                    this.$scheduler = $scheduler;
                    this.$graph = $graph;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final BuildTreeConfigurationCache.WorkGraphResult invoke() {
                    BuildTreeWorkGraph.FinalizedGraph finalizedGraph = (BuildTreeWorkGraph.FinalizedGraph)this.$scheduler.invoke((Object)this.$graph);
                    DefaultConfigurationCache.access$saveWorkGraph(this.this$0);
                    return new BuildTreeConfigurationCache.WorkGraphResult(finalizedGraph, false, DefaultConfigurationCache.access$getProblems$p(this.this$0).getShouldDiscardEntry());
                }
            });
        }
        return workGraphResult;
    }

    @Override
    @NotNull
    public BuildTreeWorkGraph.FinalizedGraph loadRequestedTasks(@NotNull BuildTreeWorkGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        return this.loadWorkGraph(graph);
    }

    @Override
    public void maybePrepareModel(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.isLoaded()) {
            return;
        }
        this.runWorkThatContributesToCacheEntry((Function0)new Function0<Unit>(action){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
                super(0);
            }

            public final void invoke() {
                this.$action.invoke();
            }
        });
    }

    @Override
    @NotNull
    public <T> T loadOrCreateModel(@NotNull Function0<? extends T> creator) {
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        if (this.isLoaded()) {
            return CastExtensionsKt.uncheckedCast(this.loadModel());
        }
        return this.runWorkThatContributesToCacheEntry((Function0)new Function0<T>(creator, this){
            final /* synthetic */ Function0<T> $creator;
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.$creator = $creator;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final T invoke() {
                Object model = this.$creator.invoke();
                DefaultConfigurationCache.access$saveModel(this.this$0, model);
                return (T)model;
            }
        });
    }

    @Override
    @Nullable
    public <T> T loadOrCreateIntermediateModel(@Nullable Path identityPath, @NotNull String modelName, @NotNull Function0<? extends T> creator) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        return ((IntermediateModelController)this.intermediateModels.getValue()).loadOrCreateIntermediateModel(identityPath, modelName, creator);
    }

    @Override
    @NotNull
    public LocalComponentMetadata loadOrCreateProjectMetadata(@NotNull Path identityPath, @NotNull Function0<? extends LocalComponentMetadata> creator) {
        Intrinsics.checkNotNullParameter((Object)identityPath, (String)"identityPath");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        return ((ProjectMetadataController)this.projectMetadata.getValue()).loadOrCreateValue(identityPath, creator);
    }

    @Override
    public void finalizeCacheEntry() {
        if (this.problems.getShouldDiscardEntry()) {
            this.getStore().useForStore((Function1<? super ConfigurationCacheRepository.Layout, Unit>)((Function1)finalizeCacheEntry.1.INSTANCE));
        } else if (this.hasSavedValues) {
            Set reusedProjects = new LinkedHashSet();
            Set updatedProjects = new LinkedHashSet();
            ((IntermediateModelController)this.intermediateModels.getValue()).visitProjects(new Consumer(reusedProjects){
                final /* synthetic */ Set<Path> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void accept(@NotNull Path p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.add(p0);
                }
            }, new Consumer(updatedProjects){
                final /* synthetic */ Set<Path> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void accept(@NotNull Path p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.add(p0);
                }
            });
            ((ProjectMetadataController)this.projectMetadata.getValue()).visitProjects(new Consumer(reusedProjects){
                final /* synthetic */ Set<Path> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void accept(@NotNull Path p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.add(p0);
                }
            }, finalizeCacheEntry.5.INSTANCE);
            this.getStore().useForStore((Function1<? super ConfigurationCacheRepository.Layout, Unit>)((Function1)new Function1<ConfigurationCacheRepository.Layout, Unit>(this, (Set<Path>)reusedProjects){
                final /* synthetic */ DefaultConfigurationCache this$0;
                final /* synthetic */ Set<Path> $reusedProjects;
                {
                    this.this$0 = $receiver;
                    this.$reusedProjects = $reusedProjects;
                    super(1);
                }

                public final void invoke(@NotNull ConfigurationCacheRepository.Layout layout2) {
                    Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                    DefaultConfigurationCache.access$writeConfigurationCacheFingerprint(this.this$0, layout2, this.$reusedProjects);
                    DefaultConfigurationCache.access$getCacheIO(this.this$0).writeCacheEntryDetailsTo$configuration_cache(DefaultConfigurationCache.access$getBuildStateRegistry$p(this.this$0), ((IntermediateModelController)DefaultConfigurationCache.access$getIntermediateModels$p(this.this$0).getValue()).getValues(), ((ProjectMetadataController)DefaultConfigurationCache.access$getProjectMetadata$p(this.this$0).getValue()).getValues(), layout2.fileFor(StateType.Entry));
                }
            }));
            this.problems.projectStateStats(reusedProjects.size(), updatedProjects.size());
            this.hasSavedValues = false;
        }
    }

    private final ConfigurationCacheAction determineCacheAction() {
        ConfigurationCacheAction configurationCacheAction;
        if (this.startParameter.getRecreateCache()) {
            this.logBootstrapSummary("Recreating configuration cache", new Object[0]);
            configurationCacheAction = ConfigurationCacheAction.STORE;
        } else if (this.startParameter.isRefreshDependencies()) {
            Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), "--refresh-dependencies"};
            this.logBootstrapSummary("{} as configuration cache cannot be reused due to {}", objectArray);
            configurationCacheAction = ConfigurationCacheAction.STORE;
        } else if (this.startParameter.isWriteDependencyLocks()) {
            Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), "--write-locks"};
            this.logBootstrapSummary("{} as configuration cache cannot be reused due to {}", objectArray);
            configurationCacheAction = ConfigurationCacheAction.STORE;
        } else if (this.startParameter.isUpdateDependencyLocks()) {
            Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), "--update-locks"};
            this.logBootstrapSummary("{} as configuration cache cannot be reused due to {}", objectArray);
            configurationCacheAction = ConfigurationCacheAction.STORE;
        } else {
            CheckedFingerprint checkedFingerprint = this.checkFingerprint();
            if (checkedFingerprint instanceof CheckedFingerprint.NotFound) {
                Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), this.buildActionModelRequirements.getConfigurationCacheKeyDisplayName().getDisplayName()};
                this.logBootstrapSummary("{} as no configuration cache is available for {}", objectArray);
                configurationCacheAction = ConfigurationCacheAction.STORE;
            } else if (checkedFingerprint instanceof CheckedFingerprint.EntryInvalid) {
                Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), ((CheckedFingerprint.EntryInvalid)checkedFingerprint).getReason()};
                this.logBootstrapSummary("{} as configuration cache cannot be reused because {}.", objectArray);
                configurationCacheAction = ConfigurationCacheAction.STORE;
            } else if (checkedFingerprint instanceof CheckedFingerprint.ProjectsInvalid) {
                Object[] objectArray = new Object[]{this.buildActionModelRequirements.getActionDisplayName().getCapitalizedDisplayName(), ((CheckedFingerprint.ProjectsInvalid)checkedFingerprint).getReason()};
                this.logBootstrapSummary("{} as configuration cache cannot be reused because {}.", objectArray);
                configurationCacheAction = ConfigurationCacheAction.UPDATE;
            } else if (checkedFingerprint instanceof CheckedFingerprint.Valid) {
                this.logBootstrapSummary("Reusing configuration cache.", new Object[0]);
                configurationCacheAction = ConfigurationCacheAction.LOAD;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return configurationCacheAction;
    }

    public void stop() {
        CompositeStoppable stoppable = CompositeStoppable.stoppable((Object[])new Object[0]);
        if (this.intermediateModels.isInitialized()) {
            stoppable.add(this.intermediateModels.getValue());
        }
        if (this.projectMetadata.isInitialized()) {
            stoppable.add(this.projectMetadata.getValue());
        }
        stoppable.add((Object)this.getStore());
        stoppable.stop();
    }

    private final CheckedFingerprint checkFingerprint() {
        return (CheckedFingerprint)this.getStore().useForStateLoad((Function1)new Function1<ConfigurationCacheRepository.Layout, CheckedFingerprint>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CheckedFingerprint invoke(@NotNull ConfigurationCacheRepository.Layout layout2) {
                Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                ConfigurationCacheStateFile entryFile = layout2.fileFor(StateType.Entry);
                EntryDetails entryDetails = DefaultConfigurationCache.access$getCacheIO(this.this$0).readCacheEntryDetailsFrom$configuration_cache(entryFile);
                return entryDetails == null ? (CheckedFingerprint)CheckedFingerprint.NotFound.INSTANCE : DefaultConfigurationCache.access$checkFingerprint(this.this$0, entryDetails, layout2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWorkThatContributesToCacheEntry(Function0<? extends T> action) {
        this.prepareForWork();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            this.doneWithWork();
        }
    }

    private final void prepareForWork() {
        this.prepareConfigurationTimeBarrier();
        this.startCollectingCacheFingerprint();
        Instrumented.setListener((Instrumented.Listener)this.instrumentedInputAccessListener);
    }

    private final void doneWithWork() {
        Instrumented.discardListener();
        this.cacheFingerprintController.stopCollectingFingerprint();
    }

    private final void saveModel(Object model) {
        this.saveToCache(StateType.Model, (Function1<? super ConfigurationCacheStateFile, Unit>)((Function1)new Function1<ConfigurationCacheStateFile, Unit>(this, model){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ Object $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                super(1);
            }

            public final void invoke(@NotNull ConfigurationCacheStateFile stateFile) {
                Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
                DefaultConfigurationCache.access$getCacheIO(this.this$0).writeModelTo$configuration_cache(this.$model, stateFile);
            }
        }));
    }

    private final void saveWorkGraph() {
        this.saveToCache(StateType.Work, (Function1<? super ConfigurationCacheStateFile, Unit>)((Function1)new Function1<ConfigurationCacheStateFile, Unit>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ConfigurationCacheStateFile layout2) {
                Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                DefaultConfigurationCache.access$writeConfigurationCacheState(this.this$0, layout2);
            }
        }));
    }

    private final void saveToCache(StateType stateType, Function1<? super ConfigurationCacheStateFile, Unit> action) {
        this.crossConfigurationTimeBarrier();
        Instrumented.discardListener();
        ConfigurationCacheBuildOperationsKt.withStoreOperation(this.buildOperationExecutor, this.cacheKey.getString(), (Function0<Unit>)((Function0)new Function0<Unit>(this, action, stateType){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ Function1<ConfigurationCacheStateFile, Unit> $action;
            final /* synthetic */ StateType $stateType;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                this.$stateType = $stateType;
                super(0);
            }

            public final void invoke() {
                DefaultConfigurationCache.access$getStore(this.this$0).useForStore((Function1<? super ConfigurationCacheRepository.Layout, Unit>)((Function1)new Function1<ConfigurationCacheRepository.Layout, Unit>(this.$action, this.$stateType, this.this$0){
                    final /* synthetic */ Function1<ConfigurationCacheStateFile, Unit> $action;
                    final /* synthetic */ StateType $stateType;
                    final /* synthetic */ DefaultConfigurationCache this$0;
                    {
                        this.$action = $action;
                        this.$stateType = $stateType;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull ConfigurationCacheRepository.Layout layout2) {
                        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                        try {
                            this.$action.invoke((Object)layout2.fileFor(this.$stateType));
                        }
                        catch (ConfigurationCacheError error) {
                            DefaultConfigurationCache.access$setHasSavedValues$p(this.this$0, false);
                            DefaultConfigurationCache.access$getProblems$p(this.this$0).failingBuildDueToSerializationError();
                            throw error;
                        }
                        finally {
                            DefaultConfigurationCache.access$getScopeRegistryListener$p(this.this$0).dispose();
                        }
                    }
                }));
            }
        }));
        this.hasSavedValues = true;
    }

    private final Object loadModel() {
        return this.loadFromCache(StateType.Model, (Function1)new Function1<ConfigurationCacheStateFile, Object>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull ConfigurationCacheStateFile stateFile) {
                Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
                return DefaultConfigurationCache.access$getCacheIO(this.this$0).readModelFrom$configuration_cache(stateFile);
            }
        });
    }

    private final BuildTreeWorkGraph.FinalizedGraph loadWorkGraph(BuildTreeWorkGraph graph) {
        return (BuildTreeWorkGraph.FinalizedGraph)this.loadFromCache(StateType.Work, (Function1)new Function1<ConfigurationCacheStateFile, BuildTreeWorkGraph.FinalizedGraph>(this, graph){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ BuildTreeWorkGraph $graph;
            {
                this.this$0 = $receiver;
                this.$graph = $graph;
                super(1);
            }

            @NotNull
            public final BuildTreeWorkGraph.FinalizedGraph invoke(@NotNull ConfigurationCacheStateFile stateFile) {
                Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
                return DefaultConfigurationCache.access$getCacheIO(this.this$0).readRootBuildStateFrom$configuration_cache(stateFile, this.$graph);
            }
        });
    }

    private final <T> T loadFromCache(StateType stateType, Function1<? super ConfigurationCacheStateFile, ? extends T> action) {
        this.prepareConfigurationTimeBarrier();
        this.scopeRegistryListener.dispose();
        Object result2 = ConfigurationCacheBuildOperationsKt.withLoadOperation(this.buildOperationExecutor, (Function0)new Function0<T>(this, stateType, action){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ StateType $stateType;
            final /* synthetic */ Function1<ConfigurationCacheStateFile, T> $action;
            {
                this.this$0 = $receiver;
                this.$stateType = $stateType;
                this.$action = $action;
                super(0);
            }

            @NotNull
            public final T invoke() {
                return DefaultConfigurationCache.access$getStore(this.this$0).useForStateLoad(this.$stateType, this.$action);
            }
        });
        this.crossConfigurationTimeBarrier();
        return result2;
    }

    private final void prepareConfigurationTimeBarrier() {
        if (!(this.configurationTimeBarrier instanceof DefaultConfigurationTimeBarrier)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ((DefaultConfigurationTimeBarrier)this.configurationTimeBarrier).prepare();
    }

    private final void crossConfigurationTimeBarrier() {
        if (!(this.configurationTimeBarrier instanceof DefaultConfigurationTimeBarrier)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ((DefaultConfigurationTimeBarrier)this.configurationTimeBarrier).cross();
    }

    private final void writeConfigurationCacheState(ConfigurationCacheStateFile stateFile) {
        Host host = this.host;
        if (host == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
            host = null;
        }
        host.getCurrentBuild().getGradle().getOwner().getProjects().withMutableStateOfAllProjects(new Runnable(this, stateFile){
            final /* synthetic */ DefaultConfigurationCache this$0;
            final /* synthetic */ ConfigurationCacheStateFile $stateFile;
            {
                this.this$0 = $receiver;
                this.$stateFile = $stateFile;
            }

            public final void run() {
                DefaultConfigurationCache.access$getCacheIO(this.this$0).writeRootBuildStateTo$configuration_cache(this.$stateFile);
            }
        });
    }

    private final void writeConfigurationCacheFingerprint(ConfigurationCacheRepository.Layout layout2, Set<? extends Path> reusedProjects) {
        if (!((Collection)reusedProjects).isEmpty()) {
            this.readFingerprintFile(layout2.fileForRead(StateType.ProjectFingerprint), (Function3)new Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super Unit>, Object>(this, reusedProjects, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ DefaultConfigurationCache this$0;
                final /* synthetic */ Set<Path> $reusedProjects;
                {
                    this.this$0 = $receiver;
                    this.$reusedProjects = $reusedProjects;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ReadContext $this$readFingerprintFile = (ReadContext)this.L$0;
                            ConfigurationCacheFingerprintController.Host host = (ConfigurationCacheFingerprintController.Host)this.L$1;
                            ConfigurationCacheFingerprintController configurationCacheFingerprintController = DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0);
                            Set<Path> set2 = this.$reusedProjects;
                            ConfigurationCacheFingerprintController $this$invokeSuspend_u24lambda_u2d0 = configurationCacheFingerprintController;
                            boolean bl = false;
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = $this$invokeSuspend_u24lambda_u2d0.collectFingerprintForReusedProjects($this$readFingerprintFile, host, set2, (Continuation<? super Unit>)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean bl = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull ReadContext p1, @NotNull ConfigurationCacheFingerprintController.Host p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }
        this.cacheFingerprintController.commitFingerprintTo(layout2.fileFor(StateType.BuildFingerprint), layout2.fileFor(StateType.ProjectFingerprint));
    }

    private final void startCollectingCacheFingerprint() {
        this.cacheFingerprintController.maybeStartCollectingFingerprint(this.getStore().assignSpoolFile(StateType.BuildFingerprint), this.getStore().assignSpoolFile(StateType.ProjectFingerprint), (Function1<? super OutputStream, DefaultWriteContext>)((Function1)new Function1<OutputStream, DefaultWriteContext>(this){
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DefaultWriteContext invoke(@NotNull OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCache.access$cacheFingerprintWriterContextFor(this.this$0, it);
            }
        }));
    }

    private final DefaultWriteContext cacheFingerprintWriterContextFor(OutputStream outputStream) {
        DefaultWriteContext defaultWriteContext;
        Pair<DefaultWriteContext, Codecs> pair = this.getCacheIO().writerContextFor$configuration_cache(outputStream, "fingerprint");
        DefaultWriteContext context = (DefaultWriteContext)pair.component1();
        Codecs codecs = (Codecs)pair.component2();
        DefaultWriteContext $this$cacheFingerprintWriterContextFor_u24lambda_u2d2 = defaultWriteContext = context;
        boolean bl = false;
        Host host = this.host;
        if (host == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
            host = null;
        }
        $this$cacheFingerprintWriterContextFor_u24lambda_u2d2.push(new IsolateOwner.OwnerHost(host), codecs.userTypesCodec());
        return defaultWriteContext;
    }

    private final CheckedFingerprint checkFingerprint(EntryDetails entryDetails, ConfigurationCacheRepository.Layout layout2) {
        CheckedFingerprint checkedFingerprint;
        this.registerWatchableBuildDirectories((Iterable<? extends File>)entryDetails.getRootDirs());
        this.loadGradleProperties();
        CheckedFingerprint result2 = checkedFingerprint = this.checkFingerprintAgainstLoadedProperties(entryDetails, layout2);
        boolean bl = false;
        if (result2 != CheckedFingerprint.Valid.INSTANCE) {
            this.unloadGradleProperties();
        }
        return checkedFingerprint;
    }

    private final CheckedFingerprint checkFingerprintAgainstLoadedProperties(EntryDetails entryDetails, ConfigurationCacheRepository.Layout layout2) {
        CheckedFingerprint result2 = this.checkBuildScopedFingerprint(layout2.fileFor(StateType.BuildFingerprint));
        if (!(result2 instanceof CheckedFingerprint.Valid)) {
            return result2;
        }
        CheckedFingerprint projectResult = this.checkProjectScopedFingerprint(layout2.fileFor(StateType.ProjectFingerprint));
        if (projectResult instanceof CheckedFingerprint.ProjectsInvalid) {
            ((IntermediateModelController)this.intermediateModels.getValue()).restoreFromCacheEntry(entryDetails.getIntermediateModels(), (CheckedFingerprint.ProjectsInvalid)projectResult);
            ((ProjectMetadataController)this.projectMetadata.getValue()).restoreFromCacheEntry(entryDetails.getProjectMetadata(), (CheckedFingerprint.ProjectsInvalid)projectResult);
        }
        return projectResult;
    }

    private final CheckedFingerprint checkBuildScopedFingerprint(ConfigurationCacheStateFile fingerprintFile) {
        return (CheckedFingerprint)this.readFingerprintFile(fingerprintFile, (Function3)new Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super CheckedFingerprint>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ReadContext $this$readFingerprintFile = (ReadContext)this.L$0;
                        ConfigurationCacheFingerprintController.Host host = (ConfigurationCacheFingerprintController.Host)this.L$1;
                        ConfigurationCacheFingerprintController $this$invokeSuspend_u24lambda_u2d0 = DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0);
                        boolean bl = false;
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = $this$invokeSuspend_u24lambda_u2d0.checkBuildScopedFingerprint($this$readFingerprintFile, host, (Continuation<? super CheckedFingerprint>)this);
                        if (object3 != object2) return (CheckedFingerprint)object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return (CheckedFingerprint)object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull ReadContext p1, @NotNull ConfigurationCacheFingerprintController.Host p2, @Nullable Continuation<? super CheckedFingerprint> p3) {
                Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super CheckedFingerprint>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    private final CheckedFingerprint checkProjectScopedFingerprint(ConfigurationCacheStateFile fingerprintFile) {
        return (CheckedFingerprint)this.readFingerprintFile(fingerprintFile, (Function3)new Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super CheckedFingerprint>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ DefaultConfigurationCache this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ReadContext $this$readFingerprintFile = (ReadContext)this.L$0;
                        ConfigurationCacheFingerprintController.Host host = (ConfigurationCacheFingerprintController.Host)this.L$1;
                        ConfigurationCacheFingerprintController $this$invokeSuspend_u24lambda_u2d0 = DefaultConfigurationCache.access$getCacheFingerprintController$p(this.this$0);
                        boolean bl = false;
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = $this$invokeSuspend_u24lambda_u2d0.checkProjectScopedFingerprint($this$readFingerprintFile, host, (Continuation<? super CheckedFingerprint>)this);
                        if (object3 != object2) return (CheckedFingerprint)object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return (CheckedFingerprint)object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull ReadContext p1, @NotNull ConfigurationCacheFingerprintController.Host p2, @Nullable Continuation<? super CheckedFingerprint> p3) {
                Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super CheckedFingerprint>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T readFingerprintFile(ConfigurationCacheStateFile fingerprintFile, Function3<? super ReadContext, ? super ConfigurationCacheFingerprintController.Host, ? super Continuation<? super T>, ? extends Object> action) {
        Object r;
        Closeable closeable = fingerprintFile.inputStream();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            r = this.getCacheIO().withReadContextFor$configuration_cache(inputStream, (Function3)new Function3<DefaultReadContext, Codecs, Continuation<? super T>, Object>(this, action, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ DefaultConfigurationCache this$0;
                final /* synthetic */ Function3<ReadContext, ConfigurationCacheFingerprintController.Host, Continuation<? super T>, Object> $action;
                {
                    this.this$0 = $receiver;
                    this.$action = $action;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$withReadContextFor = (DefaultReadContext)this.L$0;
                            codecs = (Codecs)this.L$1;
                            var4_5 = $this$withReadContextFor;
                            v0 = DefaultConfigurationCache.access$getHost$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                                v0 = null;
                            }
                            var5_6 = new IsolateOwner.OwnerHost(v0);
                            var6_7 = codecs.userTypesCodec();
                            var7_8 = this.$action;
                            var8_9 = this.this$0;
                            $i$f$withIsolate = false;
                            $this$withIsolate$iv.push((IsolateOwner)owner$iv, (Codec<Object>)codec$iv);
                            $this$invokeSuspend_u24lambda_u2d0 = (DefaultReadContext)$this$withIsolate$iv;
                            $i$a$-withIsolate-DefaultConfigurationCache$readFingerprintFile$1$1$1 = false;
                            this.L$0 = $this$withIsolate$iv;
                            this.label = 1;
                            v1 = var7_8.invoke((Object)$this$invokeSuspend_u24lambda_u2d0, (Object)new ConfigurationCacheFingerprintController.Host(var8_9){
                                final /* synthetic */ DefaultConfigurationCache this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                @NotNull
                                public ValueSourceProviderFactory getValueSourceProviderFactory() {
                                    Host host = DefaultConfigurationCache.access$getHost$p(this.this$0);
                                    if (host == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                                        host = null;
                                    }
                                    Host $this$service$iv = host;
                                    boolean $i$f$service = false;
                                    return $this$service$iv.service(ValueSourceProviderFactory.class);
                                }

                                @NotNull
                                public GradleProperties getGradleProperties() {
                                    GradleProperties gradleProperties2 = DefaultConfigurationCache.access$getGradlePropertiesController(this.this$0).getGradleProperties();
                                    Intrinsics.checkNotNullExpressionValue((Object)gradleProperties2, (String)"gradlePropertiesController.gradleProperties");
                                    return gradleProperties2;
                                }
                            }, (Object)this);
                            ** if (v1 != var13_2) goto lbl27
lbl26:
                            // 1 sources

                            return var13_2;
lbl27:
                            // 1 sources

                            ** GOTO lbl37
                        }
                        case 1: {
                            $i$f$withIsolate = false;
                            $i$a$-withIsolate-DefaultConfigurationCache$readFingerprintFile$1$1$1 = false;
                            $this$withIsolate$iv = (MutableIsolateContext)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl37:
                                // 2 sources

                                var12_15 = v1;
                            }
                            catch (Throwable var12_16) {
                                throw var12_16;
                            }
                            finally {
                                $this$withIsolate$iv.pop();
                            }
                            return var12_15;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull DefaultReadContext p1, @NotNull Codecs p2, @Nullable Continuation<? super T> p3) {
                    Function3<DefaultReadContext, Codecs, Continuation<? super T>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)r;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerWatchableBuildDirectories(Iterable<? extends File> buildDirs) {
        void $this$forEach$iv;
        Iterable<? extends File> iterable = buildDirs;
        BuildLifecycleAwareVirtualFileSystem buildLifecycleAwareVirtualFileSystem = this.virtualFileSystem;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File p0 = (File)element$iv;
            boolean bl = false;
            buildLifecycleAwareVirtualFileSystem.registerWatchableHierarchy(p0);
        }
    }

    private final void loadGradleProperties() {
        this.getGradlePropertiesController().loadGradlePropertiesFrom(this.startParameter.getSettingsDirectory());
    }

    private final void unloadGradleProperties() {
        this.getGradlePropertiesController().unloadGradleProperties();
    }

    private final void logBootstrapSummary(String message2, Object ... args) {
        this.log(message2, Arrays.copyOf(args, args.length));
    }

    private final void log(String message2, Object ... args) {
        DefaultConfigurationCacheKt.getLogger().log(this.getConfigurationCacheLogLevel(), message2, Arrays.copyOf(args, args.length));
    }

    private final LogLevel getConfigurationCacheLogLevel() {
        return this.startParameter.isQuiet() ? LogLevel.INFO : LogLevel.LIFECYCLE;
    }

    public static final /* synthetic */ void access$saveWorkGraph(DefaultConfigurationCache $this) {
        $this.saveWorkGraph();
    }

    public static final /* synthetic */ ConfigurationCacheProblems access$getProblems$p(DefaultConfigurationCache $this) {
        return $this.problems;
    }

    public static final /* synthetic */ void access$saveModel(DefaultConfigurationCache $this, Object model) {
        $this.saveModel(model);
    }

    public static final /* synthetic */ void access$writeConfigurationCacheFingerprint(DefaultConfigurationCache $this, ConfigurationCacheRepository.Layout layout2, Set reusedProjects) {
        $this.writeConfigurationCacheFingerprint(layout2, reusedProjects);
    }

    public static final /* synthetic */ ConfigurationCacheIO access$getCacheIO(DefaultConfigurationCache $this) {
        return $this.getCacheIO();
    }

    public static final /* synthetic */ BuildStateRegistry access$getBuildStateRegistry$p(DefaultConfigurationCache $this) {
        return $this.buildStateRegistry;
    }

    public static final /* synthetic */ Lazy access$getIntermediateModels$p(DefaultConfigurationCache $this) {
        return $this.intermediateModels;
    }

    public static final /* synthetic */ Lazy access$getProjectMetadata$p(DefaultConfigurationCache $this) {
        return $this.projectMetadata;
    }

    public static final /* synthetic */ CheckedFingerprint access$checkFingerprint(DefaultConfigurationCache $this, EntryDetails entryDetails, ConfigurationCacheRepository.Layout layout2) {
        return $this.checkFingerprint(entryDetails, layout2);
    }

    public static final /* synthetic */ void access$writeConfigurationCacheState(DefaultConfigurationCache $this, ConfigurationCacheStateFile stateFile) {
        $this.writeConfigurationCacheState(stateFile);
    }

    public static final /* synthetic */ ConfigurationCacheStateStore access$getStore(DefaultConfigurationCache $this) {
        return $this.getStore();
    }

    public static final /* synthetic */ void access$setHasSavedValues$p(DefaultConfigurationCache $this, boolean bl) {
        $this.hasSavedValues = bl;
    }

    public static final /* synthetic */ ConfigurationCacheClassLoaderScopeRegistryListener access$getScopeRegistryListener$p(DefaultConfigurationCache $this) {
        return $this.scopeRegistryListener;
    }

    public static final /* synthetic */ ConfigurationCacheFingerprintController access$getCacheFingerprintController$p(DefaultConfigurationCache $this) {
        return $this.cacheFingerprintController;
    }

    public static final /* synthetic */ DefaultWriteContext access$cacheFingerprintWriterContextFor(DefaultConfigurationCache $this, OutputStream outputStream) {
        return $this.cacheFingerprintWriterContextFor(outputStream);
    }

    public static final /* synthetic */ Host access$getHost$p(DefaultConfigurationCache $this) {
        return $this.host;
    }

    public static final /* synthetic */ GradlePropertiesController access$getGradlePropertiesController(DefaultConfigurationCache $this) {
        return $this.getGradlePropertiesController();
    }

    public static final /* synthetic */ ConfigurationCacheRepository access$getCacheRepository$p(DefaultConfigurationCache $this) {
        return $this.cacheRepository;
    }

    public static final /* synthetic */ ConfigurationCacheKey access$getCacheKey$p(DefaultConfigurationCache $this) {
        return $this.cacheKey;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&J\"\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H&J!\u0010\u0011\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H&\u00a2\u0006\u0002\u0010\u0012R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/gradle/configurationcache/DefaultConfigurationCache$Host;", "", "currentBuild", "Lorg/gradle/configurationcache/VintageGradleBuild;", "getCurrentBuild", "()Lorg/gradle/configurationcache/VintageGradleBuild;", "createBuild", "Lorg/gradle/configurationcache/ConfigurationCacheBuild;", "settingsFile", "Ljava/io/File;", "rootProjectName", "", "factory", "Lorg/gradle/internal/Factory;", "T", "serviceType", "Ljava/lang/Class;", "service", "(Ljava/lang/Class;)Ljava/lang/Object;", "configuration-cache"})
    public static interface Host {
        @NotNull
        public VintageGradleBuild getCurrentBuild();

        @NotNull
        public ConfigurationCacheBuild createBuild(@Nullable File var1, @NotNull String var2);

        public <T> T service(@NotNull Class<T> var1);

        @NotNull
        public <T> Factory<T> factory(@NotNull Class<T> var1);
    }
}

