/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ManagedExecutorImpl;
import org.gradle.internal.enterprise.GradleEnterprisePluginBackgroundJobExecutors;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Gradle.class)
public class DefaultGradleEnterprisePluginBackgroundJobExecutors
implements GradleEnterprisePluginBackgroundJobExecutors {
    private final ManagedExecutor executorService = DefaultGradleEnterprisePluginBackgroundJobExecutors.createExecutor();

    private static ManagedExecutor createExecutor() {
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(4, 4, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new BackgroundThreadFactory());
        poolExecutor.allowCoreThreadTimeOut(true);
        return new ManagedExecutorImpl((ExecutorService)poolExecutor, (ExecutorPolicy)new ExecutorPolicy.CatchAndRecordFailures());
    }

    @Override
    public Executor getUserJobExecutor() {
        return this::executeUserJob;
    }

    private void executeUserJob(Runnable job) {
        this.executorService.execute(() -> DefaultGradleEnterprisePluginBackgroundJobExecutors.executeWithoutConfigurationInputTracking(job));
    }

    private static void executeWithoutConfigurationInputTracking(Runnable job) {
        Instrumented.disableListenerForCurrentThread();
        try {
            job.run();
        }
        finally {
            Instrumented.restoreListenerForCurrentThread();
        }
    }

    @Override
    public boolean isInBackground() {
        return Thread.currentThread() instanceof BackgroundThread;
    }

    public void stop() {
        if (this.executorService.isShutdown()) {
            return;
        }
        this.executorService.stop();
    }

    private static final class BackgroundThread
    extends Thread {
        BackgroundThread(ThreadGroup group, Runnable r, String s) {
            super(group, r, s);
        }
    }

    private static final class BackgroundThreadFactory
    implements ThreadFactory {
        private static final String NAME = "gradle-enterprise-background-job";
        private final ThreadGroup group = new ThreadGroup("gradle-enterprise-background-job");
        private final AtomicLong counter = new AtomicLong();

        private BackgroundThreadFactory() {
        }

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            BackgroundThread thread = new BackgroundThread(this.group, r, "gradle-enterprise-background-job-" + this.counter.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

