/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.IvyArtifactNameSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleResolveMetadataSerializationHelper;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.ivy.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyConfigurationHelper;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class RealisedIvyModuleResolveMetadataSerializationHelper
extends AbstractRealisedModuleResolveMetadataSerializationHelper {
    public RealisedIvyModuleResolveMetadataSerializationHelper(AttributeContainerSerializer attributeContainerSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        super(attributeContainerSerializer, moduleIdentifierFactory);
    }

    public ModuleComponentResolveMetadata readMetadata(Decoder decoder, DefaultIvyModuleResolveMetadata resolveMetadata) throws IOException {
        Map<String, List<GradleDependencyMetadata>> variantToDependencies = this.readVariantDependencies(decoder);
        ImmutableList variants = resolveMetadata.getVariants();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentVariant variant : variants) {
            builder.add((Object)new AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl(resolveMetadata.getId(), variant.getName(), variant.getAttributes().asImmutable(), variant.getDependencies(), variant.getDependencyConstraints(), variant.getFiles(), ImmutableCapabilities.of(variant.getCapabilities().getCapabilities()), variantToDependencies.get(variant.getName()), variant.isExternalVariant()));
        }
        ImmutableList realisedVariants = builder.build();
        return new RealisedIvyModuleResolveMetadata(resolveMetadata, (ImmutableList<? extends ComponentVariant>)realisedVariants, this.readIvyConfigurations(decoder, resolveMetadata));
    }

    @Override
    protected void writeDependencies(Encoder encoder, ConfigurationMetadata configuration, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        List<? extends DependencyMetadata> dependencies = configuration.getDependencies();
        encoder.writeSmallInt(dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            if (dependencyMetadata instanceof GradleDependencyMetadata) {
                encoder.writeByte((byte)1);
                this.writeDependencyMetadata(encoder, (GradleDependencyMetadata)dependencyMetadata);
                continue;
            }
            if (!(dependencyMetadata instanceof ConfigurationBoundExternalDependencyMetadata)) continue;
            ConfigurationBoundExternalDependencyMetadata dependencyMetadata2 = (ConfigurationBoundExternalDependencyMetadata)dependencyMetadata;
            ExternalDependencyDescriptor dependencyDescriptor = dependencyMetadata2.getDependencyDescriptor();
            if (!(dependencyDescriptor instanceof IvyDependencyDescriptor)) {
                throw new IllegalStateException("Unknown type of dependency descriptor: " + dependencyDescriptor.getClass());
            }
            encoder.writeByte((byte)3);
            boolean addedByRule = configuration instanceof RealisedConfigurationMetadata && ((RealisedConfigurationMetadata)configuration).isAddedByRule();
            this.writeIvyDependency(encoder, (IvyDependencyDescriptor)dependencyDescriptor, configuration.getName(), addedByRule);
            encoder.writeNullableString((CharSequence)dependencyMetadata.getReason());
        }
    }

    @Override
    protected void writeConfiguration(Encoder encoder, ConfigurationMetadata configuration) throws IOException {
        super.writeConfiguration(encoder, configuration);
        if (configuration instanceof RealisedConfigurationMetadata) {
            RealisedConfigurationMetadata realisedMetadata = (RealisedConfigurationMetadata)configuration;
            if (realisedMetadata.isAddedByRule()) {
                encoder.writeBoolean(true);
                this.writeMavenExcludeRules(encoder, (List<ExcludeMetadata>)realisedMetadata.getExcludes());
            } else {
                encoder.writeBoolean(false);
            }
        } else {
            encoder.writeBoolean(false);
        }
    }

    private Map<String, ConfigurationMetadata> readIvyConfigurations(Decoder decoder, DefaultIvyModuleResolveMetadata metadata) throws IOException {
        IvyConfigurationHelper configurationHelper = new IvyConfigurationHelper(metadata.getArtifactDefinitions(), new IdentityHashMap<Artifact, ModuleComponentArtifactMetadata>(), metadata.getExcludes(), metadata.getDependencies(), metadata.getId());
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        int configurationsCount = decoder.readSmallInt();
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)configurationsCount);
        for (int i = 0; i < configurationsCount; ++i) {
            ImmutableList excludes;
            String configurationName = decoder.readString();
            boolean transitive = true;
            boolean visible = true;
            ImmutableSet<String> hierarchy = ImmutableSet.of((Object)configurationName);
            Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
            if (configuration != null) {
                transitive = configuration.isTransitive();
                visible = configuration.isVisible();
                hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
                excludes = configurationHelper.filterExcludes(hierarchy);
            } else {
                excludes = ImmutableList.of();
            }
            ImmutableAttributes attributes = this.getAttributeContainerSerializer().read(decoder);
            ImmutableCapabilities capabilities = this.readCapabilities(decoder);
            boolean isExternalVariant = decoder.readBoolean();
            boolean hasExplicitExcludes = decoder.readBoolean();
            if (hasExplicitExcludes) {
                excludes = ImmutableList.copyOf(this.readMavenExcludes(decoder));
            }
            ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = this.readFiles(decoder, metadata.getId());
            RealisedConfigurationMetadata configurationMetadata = new RealisedConfigurationMetadata(metadata.getId(), configurationName, transitive, visible, hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)excludes, attributes, capabilities, false, isExternalVariant);
            ImmutableList.Builder builder = ImmutableList.builder();
            int dependenciesCount = decoder.readSmallInt();
            block6: for (int j = 0; j < dependenciesCount; ++j) {
                byte dependencyType = decoder.readByte();
                switch (dependencyType) {
                    case 1: {
                        builder.add((Object)this.readDependencyMetadata(decoder));
                        continue block6;
                    }
                    case 3: {
                        IvyDependencyDescriptor ivyDependency = this.readIvyDependency(decoder);
                        ModuleDependencyMetadata dependencyMetadata = configurationHelper.contextualize(configurationMetadata, metadata.getId(), ivyDependency);
                        builder.add((Object)dependencyMetadata.withReason(decoder.readNullableString()));
                        continue block6;
                    }
                    case 2: {
                        throw new IllegalStateException("Unexpected Maven dependency for Ivy module");
                    }
                    default: {
                        throw new IllegalStateException("Unknown dependency type " + dependencyType);
                    }
                }
            }
            ImmutableList dependencies = builder.build();
            configurationMetadata.setDependencies((List<ModuleDependencyMetadata>)dependencies);
            configurations.put(configurationName, configurationMetadata);
        }
        return configurations;
    }

    private IvyDependencyDescriptor readIvyDependency(Decoder decoder) throws IOException {
        ModuleComponentSelector requested = this.getComponentSelectorSerializer().read(decoder);
        SetMultimap<String, String> configMappings = this.readDependencyConfigurationMapping(decoder);
        List<Artifact> artifacts = this.readDependencyArtifactDescriptors(decoder);
        List<Exclude> excludes = this.readDependencyExcludes(decoder);
        String dynamicConstraintVersion = decoder.readString();
        boolean changing = decoder.readBoolean();
        boolean transitive = decoder.readBoolean();
        boolean optional = decoder.readBoolean();
        return new IvyDependencyDescriptor(requested, dynamicConstraintVersion, changing, transitive, optional, (Multimap<String, String>)configMappings, artifacts, excludes);
    }

    private void writeIvyDependency(Encoder encoder, IvyDependencyDescriptor ivyDependency, String configurationName, boolean configurationAddedByRule) throws IOException {
        this.getComponentSelectorSerializer().write(encoder, ivyDependency.getSelector());
        this.writeDependencyConfigurationMapping(encoder, ivyDependency, configurationName, configurationAddedByRule);
        this.writeArtifacts(encoder, ivyDependency.getDependencyArtifacts());
        this.writeExcludeRules(encoder, ivyDependency.getAllExcludes());
        encoder.writeString((CharSequence)ivyDependency.getDynamicConstraintVersion());
        encoder.writeBoolean(ivyDependency.isChanging());
        encoder.writeBoolean(ivyDependency.isTransitive());
        encoder.writeBoolean(ivyDependency.isOptional());
    }

    private void writeExcludeRules(Encoder encoder, List<Exclude> excludes) throws IOException {
        encoder.writeSmallInt(excludes.size());
        for (Exclude exclude : excludes) {
            encoder.writeString((CharSequence)exclude.getModuleId().getGroup());
            encoder.writeString((CharSequence)exclude.getModuleId().getName());
            IvyArtifactName artifact = exclude.getArtifact();
            IvyArtifactNameSerializer.INSTANCE.writeNullable(encoder, artifact);
            this.writeStringSet(encoder, exclude.getConfigurations());
            encoder.writeNullableString((CharSequence)exclude.getMatcher());
        }
    }

    private void writeArtifacts(Encoder encoder, List<Artifact> artifacts) throws IOException {
        encoder.writeSmallInt(artifacts.size());
        for (Artifact artifact : artifacts) {
            IvyArtifactNameSerializer.INSTANCE.write(encoder, artifact.getArtifactName());
            this.writeStringSet(encoder, artifact.getConfigurations());
        }
    }

    private SetMultimap<String, String> readDependencyConfigurationMapping(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (int i = 0; i < size; ++i) {
            String from = decoder.readString();
            Set<String> to = this.readStringSet(decoder);
            result.putAll((Object)from, to);
        }
        return result;
    }

    private void writeDependencyConfigurationMapping(Encoder encoder, IvyDependencyDescriptor dep, String configurationName, boolean configurationAddedByRule) throws IOException {
        SetMultimap<String, String> confMappings = dep.getConfMappings();
        int mappingCount = confMappings.keySet().size() + (configurationAddedByRule ? 1 : 0);
        encoder.writeSmallInt(mappingCount);
        for (String conf : confMappings.keySet()) {
            encoder.writeString((CharSequence)conf);
            this.writeStringSet(encoder, confMappings.get((Object)conf));
        }
        if (configurationAddedByRule) {
            encoder.writeString((CharSequence)configurationName);
            this.writeStringSet(encoder, (Set<String>)ImmutableSet.copyOf((Collection)confMappings.values()));
        }
    }

    private List<Artifact> readDependencyArtifactDescriptors(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            IvyArtifactName ivyArtifactName = IvyArtifactNameSerializer.INSTANCE.read(decoder);
            result.add(new Artifact(ivyArtifactName, this.readStringSet(decoder)));
        }
        return result;
    }

    private List<Exclude> readDependencyExcludes(Decoder decoder) throws IOException {
        int len = decoder.readSmallInt();
        ArrayList result = Lists.newArrayListWithCapacity((int)len);
        for (int i = 0; i < len; ++i) {
            DefaultExclude rule = this.readExcludeRule(decoder);
            result.add(rule);
        }
        return result;
    }
}

