/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RelativePath;

public interface TransformationResult {
    public ImmutableList<File> resolveOutputsForInputArtifact(File var1);

    public void visitOutputs(TransformationOutputVisitor var1);

    public int size();

    public static OutputTypeInferringBuilder builderFor(File inputArtifact, File outputDir) {
        return new OutputTypeInferringBuilder(inputArtifact, outputDir);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class OutputTypeInferringBuilder {
        private final File inputArtifact;
        private final File workspaceDir;
        private final String inputArtifactPrefix;
        private final String workspaceDirPrefix;
        private final Builder delegate = TransformationResult.builder();

        public OutputTypeInferringBuilder(File inputArtifact, File workspaceDir) {
            this.inputArtifact = inputArtifact;
            this.workspaceDir = workspaceDir;
            this.inputArtifactPrefix = inputArtifact.getPath() + File.separator;
            this.workspaceDirPrefix = workspaceDir.getPath() + File.separator;
        }

        public void addOutput(File output, Consumer<File> workspaceAction) {
            if (output.equals(this.inputArtifact)) {
                this.delegate.addEntireInputArtifact();
            } else if (output.equals(this.workspaceDir) || output.getPath().startsWith(this.workspaceDirPrefix)) {
                this.delegate.addProducedOutput(output);
                workspaceAction.accept(output);
            } else if (output.getPath().startsWith(this.inputArtifactPrefix)) {
                String relativePath = RelativePath.parse((boolean)true, (String)output.getPath().substring(this.inputArtifactPrefix.length())).getPathString();
                this.delegate.addPartOfInputArtifact(relativePath);
            } else {
                throw new InvalidUserDataException("Transform output " + output.getPath() + " must be a part of the input artifact or refer to a relative path.");
            }
        }

        public TransformationResult build() {
            return this.delegate.build();
        }
    }

    public static interface TransformationOutputVisitor {
        public void visitEntireInputArtifact();

        public void visitPartOfInputArtifact(String var1);

        public void visitProducedOutput(File var1);
    }

    public static class Builder {
        private final ImmutableList.Builder<TransformationOutput> builder = ImmutableList.builder();
        private boolean onlyProducedOutputs = true;

        public void addEntireInputArtifact() {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)EntireInputArtifact.INSTANCE);
        }

        public void addPartOfInputArtifact(String relativePath) {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)new PartOfInputArtifact(relativePath));
        }

        public void addProducedOutput(File outputLocation) {
            this.builder.add((Object)new ProducedOutput(outputLocation));
        }

        public TransformationResult build() {
            ImmutableList transformationOutputs = this.builder.build();
            return this.onlyProducedOutputs ? new ProducedOutputOnlyTransformationResult(Builder.convertToProducedOutputLocations((ImmutableList<TransformationOutput>)transformationOutputs)) : new FilteredTransformationResult((ImmutableList<TransformationOutput>)transformationOutputs);
        }

        private static ImmutableList<File> convertToProducedOutputLocations(ImmutableList<TransformationOutput> transformationOutputs) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            transformationOutputs.forEach(output -> builder.add((Object)((ProducedOutput)output).getOutputLocation()));
            return builder.build();
        }

        private static class ProducedOutput
        implements TransformationOutput {
            private final File outputFile;

            public ProducedOutput(File outputFile) {
                this.outputFile = outputFile;
            }

            public File getOutputLocation() {
                return this.outputFile;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return this.outputFile;
            }

            @Override
            public void visitOutput(TransformationOutputVisitor visitor) {
                visitor.visitProducedOutput(this.outputFile);
            }
        }

        private static class EntireInputArtifact
        implements TransformationOutput {
            public static final EntireInputArtifact INSTANCE = new EntireInputArtifact();

            private EntireInputArtifact() {
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return inputArtifact;
            }

            @Override
            public void visitOutput(TransformationOutputVisitor visitor) {
                visitor.visitEntireInputArtifact();
            }
        }

        private static class PartOfInputArtifact
        implements TransformationOutput {
            private final String relativePath;

            public PartOfInputArtifact(String relativePath) {
                this.relativePath = relativePath;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return new File(inputArtifact, this.relativePath);
            }

            @Override
            public void visitOutput(TransformationOutputVisitor visitor) {
                visitor.visitPartOfInputArtifact(this.relativePath);
            }
        }

        private static interface TransformationOutput {
            public File resolveForInputArtifact(File var1);

            public void visitOutput(TransformationOutputVisitor var1);
        }

        private static class FilteredTransformationResult
        implements TransformationResult {
            private final ImmutableList<TransformationOutput> transformationOutputs;

            public FilteredTransformationResult(ImmutableList<TransformationOutput> transformationOutputs) {
                this.transformationOutputs = transformationOutputs;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.transformationOutputs.size());
                this.transformationOutputs.forEach(output -> builder.add((Object)output.resolveForInputArtifact(inputArtifact)));
                return builder.build();
            }

            @Override
            public void visitOutputs(TransformationOutputVisitor visitor) {
                this.transformationOutputs.forEach(output -> output.visitOutput(visitor));
            }

            @Override
            public int size() {
                return this.transformationOutputs.size();
            }
        }

        private static class ProducedOutputOnlyTransformationResult
        implements TransformationResult {
            private final ImmutableList<File> producedOutputLocations;

            public ProducedOutputOnlyTransformationResult(ImmutableList<File> producedOutputLocations) {
                this.producedOutputLocations = producedOutputLocations;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                return this.producedOutputLocations;
            }

            @Override
            public void visitOutputs(TransformationOutputVisitor visitor) {
                this.producedOutputLocations.forEach(visitor::visitProducedOutput);
            }

            @Override
            public int size() {
                return this.producedOutputLocations.size();
            }
        }
    }
}

