/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultDependencyConstraintSet
extends DelegatingDomainObjectSet<DependencyConstraint>
implements DependencyConstraintSet {
    private final Describable displayName;
    private final Configuration clientConfiguration;

    public DefaultDependencyConstraintSet(Describable displayName, Configuration clientConfiguration, DomainObjectSet<DependencyConstraint> backingSet) {
        super(backingSet);
        this.displayName = displayName;
        this.clientConfiguration = clientConfiguration;
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    public boolean add(DependencyConstraint dependencyConstraint) {
        this.warnIfConfigurationIsDeprecated();
        return this.addInternalDependencyConstraint(dependencyConstraint);
    }

    public boolean addInternalDependencyConstraint(DependencyConstraint dependencyConstraint) {
        return super.add((Object)dependencyConstraint);
    }

    private void warnIfConfigurationIsDeprecated() {
        List alternatives = ((DeprecatableConfiguration)this.clientConfiguration).getDeclarationAlternatives();
        if (alternatives != null) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration((String)this.clientConfiguration.getName()).forDependencyDeclaration().replaceWith((Object)alternatives)).willBecomeAnErrorInGradle8().withUpgradeGuideSection(5, "dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations")).nagUser();
        }
    }

    public boolean addAll(Collection<? extends DependencyConstraint> dependencyConstraints) {
        boolean added = false;
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            added |= this.add(dependencyConstraint);
        }
        return added;
    }
}

