/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.properties.GradleProperties;

class DefaultGradleProperties
implements GradleProperties {
    private final Map<String, Object> defaultProperties;
    private final Map<String, Object> overrideProperties;
    private final ImmutableMap<String, Object> gradleProperties;

    public DefaultGradleProperties(Map<String, Object> defaultProperties, Map<String, Object> overrideProperties) {
        this.defaultProperties = defaultProperties;
        this.overrideProperties = overrideProperties;
        this.gradleProperties = this.immutablePropertiesWith((Map<String, Object>)ImmutableMap.of());
    }

    @Nullable
    public Object find(String propertyName) {
        return this.gradleProperties.get((Object)propertyName);
    }

    public Map<String, Object> mergeProperties(Map<String, Object> properties) {
        return properties.isEmpty() ? this.gradleProperties : this.immutablePropertiesWith(properties);
    }

    ImmutableMap<String, Object> immutablePropertiesWith(Map<String, Object> properties) {
        return ImmutableMap.copyOf(this.mergePropertiesWith(properties));
    }

    Map<String, Object> mergePropertiesWith(Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.defaultProperties);
        result.putAll(properties);
        result.putAll(this.overrideProperties);
        return result;
    }
}

