/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan.edges;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeSets;
import org.gradle.execution.plan.edges.ComplexDependencyNodesSet;
import org.gradle.execution.plan.edges.DependencyNodesSet;

public class DependencySuccessorsOnlyNodeSet
implements DependencyNodesSet {
    private final NavigableSet<Node> orderedDependencies = NodeSets.newSortedNodeSet();
    private Set<Node> waitingFor;
    private boolean nodeCannotStart;
    private boolean pruned;

    @Override
    public NavigableSet<Node> getDependencySuccessors() {
        return this.orderedDependencies;
    }

    @Override
    public DependencySuccessorsOnlyNodeSet addDependency(Node node) {
        this.orderedDependencies.add(node);
        if (this.waitingFor == null) {
            this.waitingFor = new HashSet<Node>();
        }
        this.pruned = false;
        this.waitingFor.add(node);
        return this;
    }

    @Override
    public NavigableSet<Node> getMustSuccessors() {
        return ImmutableSortedSet.of();
    }

    @Override
    public DependencyNodesSet addMustSuccessor(Node toNode) {
        return new ComplexDependencyNodesSet(this).addMustSuccessor(toNode);
    }

    @Override
    public void onNodeComplete(Node node, Node dependency) {
        if (this.waitingFor != null && this.waitingFor.remove(dependency) && this.preventsNodeFromStarting(node, dependency)) {
            this.nodeCannotStart = true;
            this.waitingFor = null;
        }
    }

    @Override
    public Node.DependenciesState getState(Node node) {
        if (!this.pruned) {
            this.discardCompletedNodes(node);
            this.pruned = true;
        }
        if (this.nodeCannotStart) {
            return Node.DependenciesState.COMPLETE_AND_NOT_SUCCESSFUL;
        }
        if (this.waitingFor == null || this.waitingFor.isEmpty()) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        return Node.DependenciesState.NOT_COMPLETE;
    }

    private void discardCompletedNodes(Node node) {
        if (this.waitingFor != null) {
            Iterator<Node> iterator = this.waitingFor.iterator();
            while (iterator.hasNext()) {
                Node dependency = iterator.next();
                if (!dependency.isComplete()) continue;
                iterator.remove();
                if (!this.preventsNodeFromStarting(node, dependency)) continue;
                this.nodeCannotStart = true;
                this.waitingFor = null;
                break;
            }
        }
    }

    private boolean preventsNodeFromStarting(Node node, Node dependency) {
        return !node.shouldContinueExecution(dependency);
    }
}

