/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.api.provider.Provider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class AbstractNestedRuntimeBeanNode
extends RuntimeBeanNode<Object> {
    protected AbstractNestedRuntimeBeanNode(@Nullable RuntimeBeanNode<?> parentNode, @Nullable String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
    }

    protected void visitProperties(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, TypeValidationContext validationContext) {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        typeMetadata.visitValidationFailures(this.getPropertyName(), validationContext);
        for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
            PropertyAnnotationHandler annotationHandler = typeMetadata.getAnnotationHandlerFor(propertyMetadata);
            if (!annotationHandler.shouldVisit(visitor)) continue;
            String propertyName = this.getQualifiedPropertyName(propertyMetadata.getPropertyName());
            BeanPropertyValue value = new BeanPropertyValue(this.getBean(), propertyMetadata.getGetterMethod());
            annotationHandler.visitPropertyValue(propertyName, value, propertyMetadata, visitor, (childPropertyName, bean) -> queue.add(nodeFactory.create(this, childPropertyName, bean)));
        }
    }

    private static class BeanPropertyValue
    implements PropertyValue {
        private final Method method;
        private final Object bean;
        private final Supplier<Object> cachedInvoker = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                return DeprecationLogger.whileDisabled(() -> {
                    try {
                        return method.invoke(bean, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                    }
                    catch (Exception e) {
                        throw new GradleException(String.format("Could not call %s.%s() on %s", method.getDeclaringClass().getSimpleName(), method.getName(), bean), (Throwable)e);
                    }
                });
            }
        });

        public BeanPropertyValue(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            if (this.isProvider()) {
                return (TaskDependencyContainer)this.cachedInvoker.get();
            }
            if (this.isBuildable()) {
                return context -> {
                    Object dependency = this.cachedInvoker.get();
                    if (dependency != null) {
                        context.add(dependency);
                    }
                };
            }
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
            if (this.isConfigurable()) {
                Object value = this.cachedInvoker.get();
                ((HasConfigurableValueInternal)value).implicitFinalizeValue();
            }
        }

        private boolean isProvider() {
            return Provider.class.isAssignableFrom(this.method.getReturnType());
        }

        private boolean isConfigurable() {
            return HasConfigurableValue.class.isAssignableFrom(this.method.getReturnType());
        }

        private boolean isBuildable() {
            return Buildable.class.isAssignableFrom(this.method.getReturnType());
        }

        @Override
        @Nullable
        public Object call() {
            return this.cachedInvoker.get();
        }
    }
}

