/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.PropertyMetadata;

public class NestedBeanAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Nested.class;
    }

    @Override
    public ImmutableSet<? extends AnnotationCategory> getAllowedModifiers() {
        return ImmutableSet.of((Object)((Object)ModifierAnnotationCategory.OPTIONAL));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor, BeanPropertyContext context) {
        Object nested;
        try {
            nested = NestedBeanAnnotationHandler.unpackProvider(value.call());
        }
        catch (Exception e) {
            visitor.visitInputProperty(propertyName, new InvalidValue(e), false);
            return;
        }
        if (nested != null) {
            context.addNested(propertyName, nested);
        } else if (!propertyMetadata.isAnnotationPresent(Optional.class)) {
            visitor.visitInputProperty(propertyName, PropertyValue.ABSENT, false);
        }
    }

    @Nullable
    private static Object unpackProvider(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).getOrNull();
        }
        return value;
    }

    private static class InvalidValue
    implements PropertyValue {
        private final Exception exception;

        public InvalidValue(Exception exception) {
            this.exception = exception;
        }

        @Override
        @Nullable
        public Object call() {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }
    }
}

