/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.util.internal.GUtil;

public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileCollectionFactory fileCollectionFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final PatternSet patterns;
    private final PatternSet filter;
    private final FileCollection dirs;
    private final DirectoryProperty destinationDirectory;
    private final DirectoryProperty classesDirectory;
    private TaskProvider<?> compileTaskProvider;

    public DefaultSourceDirectorySet(String name, String displayName, Factory<PatternSet> patternSetFactory, FileCollectionFactory fileCollectionFactory, DirectoryFileTreeFactory directoryFileTreeFactory, ObjectFactory objectFactory) {
        this(name, displayName, (PatternSet)patternSetFactory.create(), (PatternSet)patternSetFactory.create(), fileCollectionFactory, directoryFileTreeFactory, objectFactory.directoryProperty(), objectFactory.directoryProperty());
    }

    DefaultSourceDirectorySet(String name, String displayName, PatternSet patterns, PatternSet filters, FileCollectionFactory fileCollectionFactory, DirectoryFileTreeFactory directoryFileTreeFactory, DirectoryProperty destinationDirectory, DirectoryProperty classesDirectory) {
        this.name = name;
        this.displayName = displayName;
        this.fileCollectionFactory = fileCollectionFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patterns = patterns;
        this.filter = filters;
        this.dirs = new FileCollectionAdapter((MinimalFileSet)new SourceDirectories());
        this.destinationDirectory = destinationDirectory;
        this.classesDirectory = classesDirectory;
    }

    public DefaultSourceDirectorySet(SourceDirectorySet sourceSet) {
        if (!(sourceSet instanceof DefaultSourceDirectorySet)) {
            throw new RuntimeException("Invalid source set type:" + this.source.getClass());
        }
        DefaultSourceDirectorySet defaultSourceSet = (DefaultSourceDirectorySet)sourceSet;
        this.name = defaultSourceSet.name;
        this.displayName = defaultSourceSet.displayName;
        this.fileCollectionFactory = defaultSourceSet.fileCollectionFactory;
        this.directoryFileTreeFactory = defaultSourceSet.directoryFileTreeFactory;
        this.patterns = defaultSourceSet.patterns;
        this.filter = defaultSourceSet.filter;
        this.dirs = new FileCollectionAdapter((MinimalFileSet)new SourceDirectories());
        this.destinationDirectory = defaultSourceSet.destinationDirectory;
        this.classesDirectory = defaultSourceSet.classesDirectory;
    }

    public String getName() {
        return this.name;
    }

    public FileCollection getSourceDirectories() {
        return this.dirs;
    }

    public Set<File> getSrcDirs() {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (DirectoryTree tree : this.getSrcDirTrees()) {
            dirs.add(tree.getDir());
        }
        return dirs;
    }

    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes(includes);
        return this;
    }

    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes(excludes);
        return this;
    }

    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include(includes);
        return this;
    }

    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable getFilter() {
        return this.filter;
    }

    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public Provider<Directory> getClassesDirectory() {
        return this.classesDirectory;
    }

    public <T extends Task> void compiledBy(TaskProvider<T> taskProvider, Function<T, DirectoryProperty> mapping) {
        this.compileTaskProvider = taskProvider;
        taskProvider.configure(task -> {
            if (taskProvider == this.compileTaskProvider) {
                ((DirectoryProperty)mapping.apply(task)).set((Provider)this.destinationDirectory);
            }
        });
        this.classesDirectory.set(taskProvider.flatMap(mapping::apply));
    }

    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> trees = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree directoryTree : this.getSourceTrees()) {
            if (trees.containsKey(directoryTree.getDir())) continue;
            trees.put(directoryTree.getDir(), directoryTree);
        }
        return new LinkedHashSet<DirectoryTree>(trees.values());
    }

    protected Set<DirectoryFileTree> getSourceTrees() {
        LinkedHashSet<DirectoryFileTree> result = new LinkedHashSet<DirectoryFileTree>();
        for (Object path : this.source) {
            if (path instanceof DefaultSourceDirectorySet) {
                DefaultSourceDirectorySet nested = (DefaultSourceDirectorySet)((Object)path);
                result.addAll(nested.getSourceTrees());
                continue;
            }
            for (File srcDir : this.fileCollectionFactory.resolving(path)) {
                if (srcDir.exists() && !srcDir.isDirectory()) {
                    throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
                }
                result.add(this.directoryFileTreeFactory.create(srcDir, this.patterns));
            }
        }
        return result;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                context.add((Object)((SourceDirectorySet)path).getBuildDependencies());
                continue;
            }
            context.add((Object)this.fileCollectionFactory.resolving(path));
        }
    }

    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        for (DirectoryFileTree directoryTree : this.getSourceTrees()) {
            visitor.accept((FileCollectionInternal)this.fileCollectionFactory.treeOf((MinimalFileTree)directoryTree.filter((PatternFilterable)this.filter)));
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        this.source.addAll(Arrays.asList(srcDirs));
        return this;
    }

    public SourceDirectorySet setSrcDirs(Iterable<?> srcPaths) {
        this.source.clear();
        GUtil.addToCollection(this.source, srcPaths);
        return this;
    }

    public SourceDirectorySet source(SourceDirectorySet source) {
        this.source.add(source);
        return this;
    }

    private class SourceDirectories
    implements MinimalFileSet,
    Buildable {
        private SourceDirectories() {
        }

        public TaskDependency getBuildDependencies() {
            return DefaultSourceDirectorySet.this.getBuildDependencies();
        }

        public Set<File> getFiles() {
            return DefaultSourceDirectorySet.this.getSrcDirs();
        }

        public String getDisplayName() {
            return DefaultSourceDirectorySet.this.displayName;
        }
    }
}

