/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateStep<C extends IncrementalChangesContext>
implements Step<C, UpToDateResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateStep.class);
    private final Step<? super C, ? extends AfterExecutionResult> delegate;

    public SkipUpToDateStep(Step<? super C, ? extends AfterExecutionResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(UnitOfWork work, C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determining if {} is up-to-date", (Object)work.getDisplayName());
        }
        ImmutableList<String> reasons = context.getRebuildReasons();
        return context.getChanges().filter(__ -> reasons.isEmpty()).map(changes -> this.skipExecution(work, changes.getBeforeExecutionState(), context)).orElseGet(() -> this.executeBecause(work, reasons, context));
    }

    private UpToDateResult skipExecution(final UnitOfWork work, BeforeExecutionState beforeExecutionState, C context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Skipping {} as it is up-to-date.", (Object)work.getDisplayName());
        }
        final PreviousExecutionState previousExecutionState = context.getPreviousExecutionState().get();
        final DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, previousExecutionState.getOutputFilesProducedByWork(), previousExecutionState.getOriginMetadata(), true);
        return new UpToDateResult((IncrementalChangesContext)context){
            final /* synthetic */ IncrementalChangesContext val$context;
            {
                this.val$context = incrementalChangesContext;
            }

            @Override
            public ImmutableList<String> getExecutionReasons() {
                return ImmutableList.of();
            }

            @Override
            public Optional<AfterExecutionState> getAfterExecutionState() {
                return Optional.of(afterExecutionState);
            }

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return Optional.of(previousExecutionState.getOriginMetadata());
            }

            @Override
            public Try<ExecutionEngine.Execution> getExecution() {
                return Try.successful((Object)new ExecutionEngine.Execution(){

                    @Override
                    public ExecutionEngine.ExecutionOutcome getOutcome() {
                        return ExecutionEngine.ExecutionOutcome.UP_TO_DATE;
                    }

                    @Override
                    public Object getOutput() {
                        return work.loadAlreadyProducedOutput(val$context.getWorkspace());
                    }
                });
            }

            @Override
            public Duration getDuration() {
                return previousExecutionState.getOriginMetadata().getExecutionTime();
            }
        };
    }

    private UpToDateResult executeBecause(UnitOfWork work, final ImmutableList<String> reasons, C context) {
        this.logExecutionReasons((List<String>)reasons, work);
        final AfterExecutionResult result = this.delegate.execute(work, context);
        return new UpToDateResult(){

            @Override
            public ImmutableList<String> getExecutionReasons() {
                return reasons;
            }

            @Override
            public Optional<AfterExecutionState> getAfterExecutionState() {
                return result.getAfterExecutionState();
            }

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getAfterExecutionState().filter(AfterExecutionState::isReused).map(AfterExecutionState::getOriginMetadata);
            }

            @Override
            public Duration getDuration() {
                return result.getDuration();
            }

            @Override
            public Try<ExecutionEngine.Execution> getExecution() {
                return result.getExecution();
            }
        };
    }

    private void logExecutionReasons(List<String> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("%s is not up-to-date because:", StringUtils.capitalize((String)work.getDisplayName()));
            for (String message : reasons) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

