/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.DefaultIncrementalInputProperties;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;

public class ResolveChangesStep<C extends CachingContext, R extends Result>
implements Step<C, R> {
    private static final ImmutableList<String> NO_HISTORY = ImmutableList.of((Object)"No history is available.");
    private static final ImmutableList<String> UNTRACKED = ImmutableList.of((Object)"Change tracking is disabled.");
    private static final ImmutableList<String> VALIDATION_FAILED = ImmutableList.of((Object)"Incremental execution has been disabled to ensure correctness. Please consult deprecation warnings for more details.");
    private final ExecutionStateChangeDetector changeDetector;
    private final Step<? super IncrementalChangesContext, R> delegate;

    public ResolveChangesStep(ExecutionStateChangeDetector changeDetector, Step<? super IncrementalChangesContext, R> delegate) {
        this.changeDetector = changeDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        IncrementalChangesContext delegateContext = context.getBeforeExecutionState().map(beforeExecution -> this.resolveExecutionStateChanges(work, (CachingContext)context, (BeforeExecutionState)beforeExecution)).map(changes -> ResolveChangesStep.createDelegateContext(context, changes.getChangeDescriptions(), changes)).orElseGet(() -> {
            ImmutableList<String> rebuildReason = context.getNonIncrementalReason().map(ImmutableList::of).orElse(UNTRACKED);
            return ResolveChangesStep.createDelegateContext(context, rebuildReason, null);
        });
        return this.delegate.execute(work, delegateContext);
    }

    @Nonnull
    private ExecutionStateChanges resolveExecutionStateChanges(UnitOfWork work, CachingContext context, BeforeExecutionState beforeExecution) {
        IncrementalInputProperties incrementalInputProperties = ResolveChangesStep.createIncrementalInputProperties(work);
        return context.getNonIncrementalReason().map(ImmutableList::of).map(nonIncrementalReason -> ExecutionStateChanges.nonIncremental((ImmutableList<String>)nonIncrementalReason, beforeExecution, incrementalInputProperties)).orElseGet(() -> context.getPreviousExecutionState().map(previousExecution -> context.getValidationProblems().map(__ -> ExecutionStateChanges.nonIncremental(VALIDATION_FAILED, beforeExecution, incrementalInputProperties)).orElseGet(() -> this.changeDetector.detectChanges(work, (PreviousExecutionState)previousExecution, beforeExecution, incrementalInputProperties))).orElseGet(() -> ExecutionStateChanges.nonIncremental(NO_HISTORY, beforeExecution, incrementalInputProperties)));
    }

    private static IncrementalInputProperties createIncrementalInputProperties(UnitOfWork work) {
        switch (work.getExecutionBehavior()) {
            case NON_INCREMENTAL: {
                return IncrementalInputProperties.NONE;
            }
            case INCREMENTAL: {
                final ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                UnitOfWork.InputVisitor visitor = new UnitOfWork.InputVisitor(){

                    @Override
                    public void visitInputFileProperty(String propertyName, UnitOfWork.InputBehavior behavior, UnitOfWork.InputFileValueSupplier valueSupplier) {
                        if (behavior.shouldTrackChanges()) {
                            Object value = valueSupplier.getValue();
                            if (value == null) {
                                throw new InvalidUserDataException("Must specify a value for incremental input property '" + propertyName + "'.");
                            }
                            builder.put((Object)propertyName, value);
                        }
                    }
                };
                work.visitIdentityInputs(visitor);
                work.visitRegularInputs(visitor);
                return new DefaultIncrementalInputProperties((ImmutableBiMap<String, Object>)builder.build());
            }
        }
        throw new AssertionError();
    }

    private static IncrementalChangesContext createDelegateContext(final CachingContext context, final ImmutableList<String> rebuildReasons, final @Nullable ExecutionStateChanges changes) {
        return new IncrementalChangesContext(){

            @Override
            public ImmutableList<String> getRebuildReasons() {
                return rebuildReasons;
            }

            @Override
            public Optional<ExecutionStateChanges> getChanges() {
                return Optional.ofNullable(changes);
            }

            @Override
            public CachingState getCachingState() {
                return context.getCachingState();
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public Optional<PreviousExecutionState> getPreviousExecutionState() {
                return context.getPreviousExecutionState();
            }

            @Override
            public Optional<ValidationFinishedContext.ValidationResult> getValidationProblems() {
                return context.getValidationProblems();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return context.getBeforeExecutionState();
            }
        };
    }
}

