/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;

public class IdentifyStep<C extends ExecutionRequestContext, R extends Result>
implements DeferredExecutionAwareStep<C, R> {
    private final DeferredExecutionAwareStep<? super IdentityContext, R> delegate;

    public IdentifyStep(DeferredExecutionAwareStep<? super IdentityContext, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, this.createIdentityContext(work, context));
    }

    @Override
    public <T> Deferrable<Try<T>> executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, Try<T>> cache) {
        return this.delegate.executeDeferred(work, this.createIdentityContext(work, context), cache);
    }

    @Nonnull
    private IdentityContext createIdentityContext(UnitOfWork work, C context) {
        InputFingerprinter.Result inputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)ImmutableSortedMap.of(), work::visitIdentityInputs);
        ImmutableSortedMap<String, ValueSnapshot> identityInputProperties = inputs.getValueSnapshots();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> identityInputFileProperties = inputs.getFileFingerprints();
        UnitOfWork.Identity identity = work.identify((Map<String, ValueSnapshot>)identityInputProperties, (Map<String, CurrentFileCollectionFingerprint>)identityInputFileProperties);
        return new IdentityContext((ExecutionRequestContext)context, (ImmutableSortedMap)identityInputProperties, (ImmutableSortedMap)identityInputFileProperties, identity){
            final /* synthetic */ ExecutionRequestContext val$context;
            final /* synthetic */ ImmutableSortedMap val$identityInputProperties;
            final /* synthetic */ ImmutableSortedMap val$identityInputFileProperties;
            final /* synthetic */ UnitOfWork.Identity val$identity;
            {
                this.val$context = executionRequestContext;
                this.val$identityInputProperties = immutableSortedMap;
                this.val$identityInputFileProperties = immutableSortedMap2;
                this.val$identity = identity;
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return this.val$context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return this.val$context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$identityInputProperties;
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$identityInputFileProperties;
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$identity;
            }
        };
    }
}

