/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.work.InputChanges;

public class ExecuteStep<C extends ChangingOutputsContext>
implements Step<C, Result> {
    private final BuildOperationExecutor buildOperationExecutor;

    public ExecuteStep(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        return (Result)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.executeInternal(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE);
            }
        });
    }

    private static Result executeInternal(UnitOfWork work, final InputChangesContext context) {
        UnitOfWork.WorkOutput workOutput;
        UnitOfWork.ExecutionRequest executionRequest = new UnitOfWork.ExecutionRequest(){

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return context.getInputChanges();
            }

            @Override
            public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                return context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork);
            }
        };
        Timer timer = Time.startTimer();
        try {
            workOutput = work.execute(executionRequest);
        }
        catch (Throwable t) {
            return ResultImpl.failed(t, Duration.ofMillis(timer.getElapsedMillis()));
        }
        Duration duration = Duration.ofMillis(timer.getElapsedMillis());
        ExecutionEngine.ExecutionOutcome mode = ExecuteStep.determineOutcome(context, workOutput);
        return ResultImpl.success(duration, new ExecutionResultImpl(mode, workOutput));
    }

    private static ExecutionEngine.ExecutionOutcome determineOutcome(InputChangesContext context, UnitOfWork.WorkOutput workOutput) {
        switch (workOutput.getDidWork()) {
            case DID_NO_WORK: {
                return ExecutionEngine.ExecutionOutcome.UP_TO_DATE;
            }
            case DID_WORK: {
                return context.getInputChanges().filter(InputChanges::isIncremental).map(Functions.constant((Object)((Object)ExecutionEngine.ExecutionOutcome.EXECUTED_INCREMENTALLY))).orElse(ExecutionEngine.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY);
            }
        }
        throw new AssertionError();
    }

    private static final class ExecutionResultImpl
    implements ExecutionEngine.Execution {
        private final ExecutionEngine.ExecutionOutcome mode;
        private final UnitOfWork.WorkOutput workOutput;

        public ExecutionResultImpl(ExecutionEngine.ExecutionOutcome mode, UnitOfWork.WorkOutput workOutput) {
            this.mode = mode;
            this.workOutput = workOutput;
        }

        @Override
        public ExecutionEngine.ExecutionOutcome getOutcome() {
            return this.mode;
        }

        @Override
        public Object getOutput() {
            return this.workOutput.getOutput();
        }
    }

    private static final class ResultImpl
    implements Result {
        private final Duration duration;
        private final Try<ExecutionEngine.Execution> outcome;

        private ResultImpl(Duration duration, Try<ExecutionEngine.Execution> outcome) {
            this.duration = duration;
            this.outcome = outcome;
        }

        private static Result failed(Throwable t, Duration duration) {
            return new ResultImpl(duration, (Try<ExecutionEngine.Execution>)Try.failure((Throwable)t));
        }

        private static Result success(Duration duration, ExecutionEngine.Execution outcome) {
            return new ResultImpl(duration, (Try<ExecutionEngine.Execution>)Try.successful((Object)outcome));
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public Try<ExecutionEngine.Execution> getExecution() {
            return this.outcome;
        }
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

