/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class LanguageSpecificAdaptor
implements ProjectGenerator {
    private static final List<String> SAMPLE_CONVENTION_PLUGINS = Arrays.asList("common", "application", "library");
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final TemplateOperationFactory templateOperationFactory;
    private final LanguageSpecificProjectGenerator descriptor;
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public LanguageSpecificAdaptor(LanguageSpecificProjectGenerator descriptor, BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, TemplateLibraryVersionProvider libraryVersionProvider) {
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.descriptor = descriptor;
        this.templateOperationFactory = templateOperationFactory;
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ComponentType getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Language getLanguage() {
        return this.descriptor.getLanguage();
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return this.descriptor.getModularizationOptions();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return this.descriptor.getFurtherReading(settings);
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        if (this.descriptor.getLanguage().equals(Language.KOTLIN)) {
            return BuildInitDsl.KOTLIN;
        }
        return BuildInitDsl.GROOVY;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return this.descriptor.getTestFrameworks();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return this.descriptor.getDefaultTestFramework();
    }

    @Override
    public boolean supportsPackage() {
        return this.descriptor.supportsPackage();
    }

    public Map<String, List<String>> generateWithExternalComments(InitSettings settings) {
        HashMap<String, List<String>> comments = new HashMap<String, List<String>>();
        for (BuildScriptBuilder buildScriptBuilder : this.allBuildScriptBuilder(settings)) {
            buildScriptBuilder.withExternalComments().create(settings.getTarget()).generate();
            comments.put(buildScriptBuilder.getFileNameWithoutExtension(), buildScriptBuilder.extractComments());
        }
        return comments;
    }

    @Override
    public void generate(InitSettings settings) {
        for (BuildScriptBuilder buildScriptBuilder : this.allBuildScriptBuilder(settings)) {
            buildScriptBuilder.create(settings.getTarget()).generate();
        }
    }

    private List<BuildScriptBuilder> allBuildScriptBuilder(InitSettings settings) {
        ArrayList<BuildScriptBuilder> builder = new ArrayList<BuildScriptBuilder>();
        if (settings.getModularizationOption() == ModularizationOption.WITH_LIBRARY_PROJECTS) {
            builder.add(this.pluginsBuildSetup(settings));
            for (String conventionPluginName : SAMPLE_CONVENTION_PLUGINS) {
                builder.add(this.conventionPluginScriptBuilder(conventionPluginName, settings));
            }
        }
        for (String subproject : settings.getSubprojects()) {
            builder.add(this.projectBuildScriptBuilder(subproject, settings, subproject + "/build"));
        }
        TemplateFactory templateFactory = new TemplateFactory(settings, this.descriptor.getLanguage(), this.templateOperationFactory);
        this.descriptor.generateSources(settings, templateFactory);
        return builder;
    }

    private BuildScriptBuilder pluginsBuildSetup(InitSettings settings) {
        BuildScriptBuilder pluginsBuildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), this.pluginsBuildLocation(settings) + "/build", settings.isUseIncubatingAPIs());
        pluginsBuildScriptBuilder.conventionPluginSupport("Support convention plugins written in " + settings.getDsl().toString() + ". Convention plugins are build scripts in 'src/main' that automatically become available as plugins in the main build.");
        if (this.getLanguage() == Language.KOTLIN) {
            String kotlinPluginCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin:" + this.libraryVersionProvider.getVersion("kotlin");
            pluginsBuildScriptBuilder.implementationDependency(null, kotlinPluginCoordinates);
        }
        return pluginsBuildScriptBuilder;
    }

    private BuildScriptBuilder projectBuildScriptBuilder(String projectName, InitSettings settings, String buildFile) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), buildFile, settings.isUseIncubatingAPIs());
        this.descriptor.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        return buildScriptBuilder;
    }

    private BuildScriptBuilder conventionPluginScriptBuilder(String conventionPluginName, InitSettings settings) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), this.pluginsBuildLocation(settings) + "/src/main/" + settings.getDsl().name().toLowerCase() + "/" + settings.getPackageName() + "." + this.getLanguage().getName() + "-" + conventionPluginName + "-conventions", settings.isUseIncubatingAPIs());
        this.descriptor.generateConventionPluginBuildScript(conventionPluginName, settings, buildScriptBuilder);
        return buildScriptBuilder;
    }

    private String pluginsBuildLocation(InitSettings settings) {
        if (settings.isUseIncubatingAPIs()) {
            return "gradle/plugins";
        }
        return "buildSrc";
    }
}

