/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.util.concurrent.Runnables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.execution.plan.BuildWorkPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.BuildWorkGraphController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultBuildWorkGraphController
implements BuildWorkGraphController {
    private final TaskNodeFactory taskNodeFactory;
    private final BuildLifecycleController controller;
    private final BuildIdentifier buildIdentifier;
    private final WorkerLeaseService workerLeaseService;
    private final Map<String, DefaultExportedTaskNode> nodesByPath = new ConcurrentHashMap<String, DefaultExportedTaskNode>();
    private final Object lock = new Object();
    private Thread currentOwner;
    private final Set<DefaultBuildWorkGraph> pendingGraphs = new HashSet<DefaultBuildWorkGraph>();
    private DefaultBuildWorkGraph currentlyRunning;

    public DefaultBuildWorkGraphController(TaskNodeFactory taskNodeFactory, BuildLifecycleController controller, BuildState buildState, WorkerLeaseService workerLeaseService) {
        this.taskNodeFactory = taskNodeFactory;
        this.controller = controller;
        this.buildIdentifier = buildState.getBuildIdentifier();
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentOwner != null) {
                throw new IllegalStateException("Cannot reset work graph state as another thread is currently using the work graph.");
            }
            this.nodesByPath.clear();
        }
        this.taskNodeFactory.resetState();
    }

    @Override
    public ExportedTaskNode locateTask(TaskIdentifier taskIdentifier) {
        DefaultExportedTaskNode node = this.doLocate(taskIdentifier);
        if (taskIdentifier instanceof TaskIdentifier.TaskBasedTaskIdentifier) {
            node.maybeBindTask(((TaskIdentifier.TaskBasedTaskIdentifier)taskIdentifier).getTask());
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildWorkGraph newWorkGraph() {
        Object object = this.lock;
        synchronized (object) {
            while (this.currentOwner != null && this.currentOwner != Thread.currentThread()) {
                this.workerLeaseService.blocking(() -> {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                });
            }
            this.currentOwner = Thread.currentThread();
            DefaultBuildWorkGraph workGraph = new DefaultBuildWorkGraph();
            this.pendingGraphs.add(workGraph);
            return workGraph;
        }
    }

    private DefaultExportedTaskNode doLocate(TaskIdentifier taskIdentifier) {
        return this.nodesByPath.computeIfAbsent(taskIdentifier.getTaskPath(), x$0 -> new DefaultExportedTaskNode((String)x$0));
    }

    @Nullable
    private TaskInternal findTaskNode(String taskPath) {
        for (Task task : this.taskNodeFactory.getTasks()) {
            if (!task.getPath().equals(taskPath)) continue;
            return (TaskInternal)task;
        }
        return null;
    }

    private class DefaultExportedTaskNode
    implements ExportedTaskNode {
        final String taskPath;
        TaskNode taskNode;
        Runnable action = Runnables.doNothing();

        DefaultExportedTaskNode(String taskPath) {
            this.taskPath = taskPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeBindTask(TaskInternal task) {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Runnable action) {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                Runnable previous = this.action;
                this.action = () -> {
                    previous.run();
                    action.run();
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskInternal getTask() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    TaskInternal task = DefaultBuildWorkGraphController.this.findTaskNode(this.taskPath);
                    if (task == null) {
                        throw new IllegalStateException("Task '" + this.taskPath + "' was never scheduled for execution.");
                    }
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
                return this.taskNode.getTask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IncludedBuildTaskResource.State getTaskState() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    TaskInternal task = DefaultBuildWorkGraphController.this.findTaskNode(this.taskPath);
                    if (task == null) {
                        return IncludedBuildTaskResource.State.NotScheduled;
                    }
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
                if (this.taskNode.isExecuted() && this.taskNode.isSuccessful()) {
                    return IncludedBuildTaskResource.State.Success;
                }
                if (this.taskNode.isExecuted()) {
                    return IncludedBuildTaskResource.State.Failed;
                }
                if (this.taskNode.isComplete()) {
                    return IncludedBuildTaskResource.State.NotScheduled;
                }
                return IncludedBuildTaskResource.State.Scheduled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldSchedule() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                return this.taskNode == null || !this.taskNode.isRequired();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String healthDiagnostics() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                return "exportedTaskState=" + (Object)((Object)this.getTaskState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireCompleted() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                this.action.run();
                this.action = Runnables.doNothing();
            }
        }
    }

    private class DefaultBuildWorkGraph
    implements BuildWorkGraph {
        private final Thread owner = Thread.currentThread();
        BuildWorkPlan plan;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (this.plan != null) {
                this.plan.stop();
            }
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                assert (DefaultBuildWorkGraphController.this.currentOwner == Thread.currentThread());
                DefaultBuildWorkGraphController.this.pendingGraphs.remove(this);
                if (DefaultBuildWorkGraphController.this.pendingGraphs.isEmpty()) {
                    DefaultBuildWorkGraphController.this.currentOwner = null;
                    DefaultBuildWorkGraphController.this.lock.notifyAll();
                }
            }
        }

        @Override
        public boolean schedule(Collection<ExportedTaskNode> taskNodes) {
            this.assertIsOwner();
            ArrayList<TaskInternal> tasks = new ArrayList<TaskInternal>();
            for (ExportedTaskNode taskNode : taskNodes) {
                DefaultExportedTaskNode node = (DefaultExportedTaskNode)taskNode;
                if (DefaultBuildWorkGraphController.this.nodesByPath.get(node.taskPath) != taskNode) {
                    throw new IllegalArgumentException();
                }
                if (!node.shouldSchedule()) continue;
                tasks.add(node.getTask());
            }
            if (tasks.isEmpty()) {
                return false;
            }
            DefaultBuildWorkGraphController.this.controller.getGradle().getOwner().getProjects().withMutableStateOfAllProjects(() -> {
                this.createPlan();
                DefaultBuildWorkGraphController.this.controller.prepareToScheduleTasks();
                DefaultBuildWorkGraphController.this.controller.populateWorkGraph(this.plan, workGraph -> workGraph.addEntryTasks(tasks));
            });
            return true;
        }

        @Override
        public void populateWorkGraph(Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
            this.assertIsOwner();
            this.createPlan();
            DefaultBuildWorkGraphController.this.controller.prepareToScheduleTasks();
            DefaultBuildWorkGraphController.this.controller.populateWorkGraph(this.plan, action);
        }

        @Override
        public void addFilter(Spec<Task> filter) {
            this.assertIsOwner();
            this.createPlan();
            this.plan.addFilter(filter);
        }

        private void createPlan() {
            if (this.plan == null) {
                this.plan = DefaultBuildWorkGraphController.this.controller.newWorkGraph();
                this.plan.onComplete(this::nodeComplete);
            }
        }

        private void nodeComplete(LocalTaskNode node) {
            DefaultExportedTaskNode exportedNode = (DefaultExportedTaskNode)DefaultBuildWorkGraphController.this.nodesByPath.get(node.getTask().getPath());
            if (exportedNode != null) {
                exportedNode.fireCompleted();
            }
        }

        @Override
        public void finalizeGraph() {
            this.assertIsOwner();
            if (this.plan != null) {
                DefaultBuildWorkGraphController.this.controller.finalizeWorkGraph(this.plan);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecutionResult<Void> runWork() {
            ExecutionResult<Void> executionResult = DefaultBuildWorkGraphController.this.lock;
            synchronized (executionResult) {
                if (DefaultBuildWorkGraphController.this.currentlyRunning != null) {
                    throw new IllegalStateException("Build '" + DefaultBuildWorkGraphController.this.buildIdentifier + "' is currently already running work.");
                }
                DefaultBuildWorkGraphController.this.currentlyRunning = this;
            }
            try {
                if (this.plan != null) {
                    executionResult = DefaultBuildWorkGraphController.this.controller.executeTasks(this.plan);
                    return executionResult;
                }
                executionResult = ExecutionResult.succeeded();
                return executionResult;
            }
            finally {
                Object object = DefaultBuildWorkGraphController.this.lock;
                synchronized (object) {
                    DefaultBuildWorkGraphController.this.currentlyRunning = null;
                }
            }
        }

        private void assertIsOwner() {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException("Current thread is not the owner of this work graph.");
            }
        }
    }
}

