/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public abstract class AbstractCodeQualityPlugin<T>
implements Plugin<ProjectInternal> {
    protected ProjectInternal project;
    protected CodeQualityExtension extension;

    protected static ConventionMapping conventionMappingOf(Object object) {
        return ((IConventionAware)object).getConventionMapping();
    }

    public final void apply(ProjectInternal project) {
        this.project = project;
        this.beforeApply();
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.createConfigurations();
        this.extension = this.createExtension();
        this.configureExtensionRule();
        this.configureTaskRule();
        this.configureSourceSetRule();
        this.configureCheckTask();
    }

    protected abstract String getToolName();

    protected abstract Class<T> getTaskType();

    private Class<? extends Task> getCastedTaskType() {
        return (Class)Cast.uncheckedCast(this.getTaskType());
    }

    protected String getTaskBaseName() {
        return this.getToolName().toLowerCase();
    }

    protected String getConfigurationName() {
        return this.getToolName().toLowerCase();
    }

    protected String getReportName() {
        return this.getToolName().toLowerCase();
    }

    protected Class<? extends Plugin> getBasePlugin() {
        return JavaBasePlugin.class;
    }

    protected void beforeApply() {
    }

    protected void createConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create(this.getConfigurationName());
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The " + this.getToolName() + " libraries to be used for this project.");
        ((DeprecatableConfiguration)configuration).deprecateForConsumption(deprecation -> deprecation.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "plugin_configuration_consumption"));
        configuration.exclude(this.excludeProperties("ant", "ant"));
        configuration.exclude(this.excludeProperties("org.apache.ant", "ant"));
        configuration.exclude(this.excludeProperties("org.apache.ant", "ant-launcher"));
        configuration.exclude(this.excludeProperties("org.slf4j", "slf4j-api"));
        configuration.exclude(this.excludeProperties("org.slf4j", "jcl-over-slf4j"));
        configuration.exclude(this.excludeProperties("org.slf4j", "log4j-over-slf4j"));
        configuration.exclude(this.excludeProperties("commons-logging", "commons-logging"));
        configuration.exclude(this.excludeProperties("log4j", "log4j"));
        this.configureConfiguration(configuration);
    }

    protected abstract void configureConfiguration(Configuration var1);

    private Map<String, String> excludeProperties(String group, String module) {
        return ImmutableMap.builder().put((Object)"group", (Object)group).put((Object)"module", (Object)module).build();
    }

    protected abstract CodeQualityExtension createExtension();

    private void configureExtensionRule() {
        final ConventionMapping extensionMapping = AbstractCodeQualityPlugin.conventionMappingOf(this.extension);
        extensionMapping.map("sourceSets", Callables.returning(new ArrayList()));
        extensionMapping.map("reportsDir", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return ((ReportingExtension)AbstractCodeQualityPlugin.this.project.getExtensions().getByType(ReportingExtension.class)).file(AbstractCodeQualityPlugin.this.getReportName());
            }
        });
        this.withBasePlugin(new Action<Plugin>(){

            public void execute(Plugin plugin) {
                extensionMapping.map("sourceSets", (Callable)new Callable<SourceSetContainer>(){

                    @Override
                    public SourceSetContainer call() {
                        return AbstractCodeQualityPlugin.this.getJavaPluginExtension().getSourceSets();
                    }
                });
            }
        });
    }

    private void configureTaskRule() {
        this.project.getTasks().withType(this.getCastedTaskType()).configureEach((Action)new Action<Task>(){

            public void execute(Task task) {
                String prunedName = task.getName().replaceFirst(AbstractCodeQualityPlugin.this.getTaskBaseName(), "");
                if (prunedName.isEmpty()) {
                    prunedName = task.getName();
                }
                prunedName = ("" + prunedName.charAt(0)).toLowerCase() + prunedName.substring(1);
                AbstractCodeQualityPlugin.this.configureTaskDefaults(task, prunedName);
            }
        });
    }

    protected void configureTaskDefaults(T task, String baseName) {
    }

    private void configureSourceSetRule() {
        this.withBasePlugin(new Action<Plugin>(){

            public void execute(Plugin plugin) {
                AbstractCodeQualityPlugin.this.configureForSourceSets(AbstractCodeQualityPlugin.this.getJavaPluginExtension().getSourceSets());
            }
        });
    }

    private void configureForSourceSets(SourceSetContainer sourceSets) {
        sourceSets.all((Action)new Action<SourceSet>(){

            public void execute(final SourceSet sourceSet) {
                AbstractCodeQualityPlugin.this.project.getTasks().register(sourceSet.getTaskName(AbstractCodeQualityPlugin.this.getTaskBaseName(), null), AbstractCodeQualityPlugin.this.getCastedTaskType(), (Action)new Action<Task>(){

                    public void execute(Task task) {
                        AbstractCodeQualityPlugin.this.configureForSourceSet(sourceSet, task);
                    }
                });
            }
        });
    }

    protected void configureForSourceSet(SourceSet sourceSet, T task) {
    }

    private void configureCheckTask() {
        this.withBasePlugin(new Action<Plugin>(){

            public void execute(Plugin plugin) {
                AbstractCodeQualityPlugin.this.configureCheckTaskDependents();
            }
        });
    }

    private void configureCheckTaskDependents() {
        final String taskBaseName = this.getTaskBaseName();
        this.project.getTasks().named("check", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{new Callable<Object>(){

                    @Override
                    public Object call() {
                        return Iterables.transform(AbstractCodeQualityPlugin.this.extension.getSourceSets(), (Function)new Function<SourceSet, String>(){

                            public String apply(SourceSet sourceSet) {
                                return sourceSet.getTaskName(taskBaseName, null);
                            }
                        });
                    }
                }});
            }
        });
    }

    protected void withBasePlugin(Action<Plugin> action) {
        this.project.getPlugins().withType(this.getBasePlugin(), action);
    }

    @Deprecated
    protected JavaPluginConvention getJavaPluginConvention() {
        return (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    protected JavaPluginExtension getJavaPluginExtension() {
        return (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
    }
}

