/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import javax.inject.Inject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.credentials.CredentialListener;
import org.gradle.api.internal.provider.MissingValueException;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class PublishToMavenRepository
extends AbstractPublishToMaven {
    private final Transient.Var<DefaultMavenArtifactRepository> repository = Transient.varOf();
    private final Cached<PublishSpec> spec = Cached.of(this::computeSpec);
    private final Property<Credentials> credentials = this.getProject().getObjects().property(Credentials.class);

    @Internal
    public MavenArtifactRepository getRepository() {
        return (MavenArtifactRepository)this.repository.get();
    }

    @Nested
    @Optional
    Property<Credentials> getCredentials() {
        return this.credentials;
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository.set((Object)((DefaultMavenArtifactRepository)repository));
        this.credentials.set((Provider)((DefaultMavenArtifactRepository)repository).getConfiguredCredentials());
    }

    @TaskAction
    public void publish() {
        PublishSpec spec = (PublishSpec)this.spec.get();
        this.doPublish(spec.publication, spec.repository.get(this.getServices()));
    }

    private PublishSpec computeSpec() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        DefaultMavenArtifactRepository repository = (DefaultMavenArtifactRepository)this.repository.get();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.checkCredentialSafety(repository);
        this.getDuplicatePublicationTracker().checkCanPublish(publicationInternal, repository.getUrl(), repository.getName());
        MavenNormalizedPublication normalizedPublication = publicationInternal.asNormalisedPublication();
        return new PublishSpec(RepositorySpec.of(repository), normalizedPublication);
    }

    private void checkCredentialSafety(DefaultMavenArtifactRepository repository) {
        boolean safeCredentials;
        Credentials value = (Credentials)repository.getConfiguredCredentials().getOrNull();
        boolean bl = safeCredentials = value == null || this.areCredentialsSafe(repository.getName(), value);
        if (!safeCredentials) {
            this.credentialListener().onUnsafeCredentials("repository " + repository.getName(), (TaskInternal)this);
        }
    }

    private CredentialListener credentialListener() {
        return (CredentialListener)this.getListenerManager().getBroadcaster(CredentialListener.class);
    }

    private boolean areCredentialsSafe(String identity, Credentials toCheck) {
        Credentials referenceCredentials;
        ProviderFactory providerFactory = (ProviderFactory)this.getServices().get(ProviderFactory.class);
        try {
            Provider credentialsProvider = providerFactory.credentials(toCheck.getClass(), identity);
            referenceCredentials = (Credentials)credentialsProvider.get();
        }
        catch (MissingValueException e) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)toCheck, (Object)referenceCredentials);
    }

    private void doPublish(final MavenNormalizedPublication normalizedPublication, final MavenArtifactRepository repository) {
        new PublishOperation(normalizedPublication.getName(), repository.getName()){

            protected void publish() {
                PublishToMavenRepository.this.validatingMavenPublisher().publish(normalizedPublication, repository);
            }
        }.run();
    }

    private MavenPublisher validatingMavenPublisher() {
        return new ValidatingMavenPublisher(this.getMavenPublishers().getRemotePublisher((Factory<File>)this.getTemporaryDirFactory()));
    }

    static abstract class RepositorySpec {
        RepositorySpec() {
        }

        static RepositorySpec of(DefaultMavenArtifactRepository repository) {
            return new Configured(repository);
        }

        abstract MavenArtifactRepository get(ServiceRegistry var1);

        static class CredentialsSpec {
            private final String identity;
            private final Class<? extends Credentials> type;

            private CredentialsSpec(String identity, Class<? extends Credentials> type) {
                this.identity = identity;
                this.type = type;
            }

            public static CredentialsSpec of(String identity, Credentials credentials) {
                return new CredentialsSpec(identity, GeneratedSubclasses.unpackType((Object)credentials));
            }

            public Class<? extends Credentials> getType() {
                return this.type;
            }

            public String getIdentity() {
                return this.identity;
            }
        }

        static class DefaultRepositorySpec
        extends RepositorySpec {
            private final URI repositoryUrl;
            private final CredentialsSpec credentials;
            private final boolean allowInsecureProtocol;
            private final String name;

            public DefaultRepositorySpec(String name, URI repositoryUrl, boolean allowInsecureProtocol, CredentialsSpec credentials) {
                this.name = name;
                this.repositoryUrl = repositoryUrl;
                this.allowInsecureProtocol = allowInsecureProtocol;
                this.credentials = credentials;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                DefaultMavenArtifactRepository repository = (DefaultMavenArtifactRepository)((BaseRepositoryFactory)services.get(BaseRepositoryFactory.class)).createMavenRepository();
                repository.setName(this.name);
                repository.setUrl(this.repositoryUrl);
                repository.setAllowInsecureProtocol(this.allowInsecureProtocol);
                if (this.credentials != null) {
                    Provider provider = ((ProviderFactory)services.get(ProviderFactory.class)).credentials(this.credentials.getType(), this.name);
                    repository.setConfiguredCredentials((Credentials)provider.get());
                }
                return repository;
            }
        }

        static class Configured
        extends RepositorySpec
        implements Serializable {
            final DefaultMavenArtifactRepository repository;

            public Configured(DefaultMavenArtifactRepository repository) {
                this.repository = repository;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                return this.repository;
            }

            private Object writeReplace() {
                CredentialsSpec credentialsSpec = (CredentialsSpec)this.repository.getConfiguredCredentials().map(it -> CredentialsSpec.of(this.repository.getName(), it)).getOrNull();
                return new DefaultRepositorySpec(this.repository.getName(), this.repository.getUrl(), this.repository.isAllowInsecureProtocol(), credentialsSpec);
            }
        }
    }

    static class PublishSpec {
        private final RepositorySpec repository;
        private final MavenNormalizedPublication publication;

        public PublishSpec(RepositorySpec repository, MavenNormalizedPublication publication) {
            this.repository = repository;
            this.publication = publication;
        }
    }
}

