/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import javax.annotation.Nullable;
import org.gradle.internal.enterprise.GradleEnterprisePluginBuildState;
import org.gradle.internal.enterprise.GradleEnterprisePluginConfig;
import org.gradle.internal.enterprise.GradleEnterprisePluginEndOfBuildListener;
import org.gradle.internal.enterprise.GradleEnterprisePluginRequiredServices;
import org.gradle.internal.enterprise.GradleEnterprisePluginService;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginServiceRef;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;

public class DefaultGradleEnterprisePluginAdapter
implements GradleEnterprisePluginAdapter {
    private final GradleEnterprisePluginConfig config;
    private final GradleEnterprisePluginRequiredServices requiredServices;
    private final GradleEnterprisePluginBuildState buildState;
    private final DefaultGradleEnterprisePluginServiceRef pluginServiceRef;
    private final BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar;
    private GradleEnterprisePluginServiceFactory pluginServiceFactory;
    private transient GradleEnterprisePluginService pluginService;

    public DefaultGradleEnterprisePluginAdapter(GradleEnterprisePluginConfig config, GradleEnterprisePluginRequiredServices requiredServices, GradleEnterprisePluginBuildState buildState, DefaultGradleEnterprisePluginServiceRef pluginServiceRef, BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar) {
        this.config = config;
        this.requiredServices = requiredServices;
        this.buildState = buildState;
        this.pluginServiceRef = pluginServiceRef;
        this.buildOperationNotificationListenerRegistrar = buildOperationNotificationListenerRegistrar;
    }

    public GradleEnterprisePluginServiceRef register(GradleEnterprisePluginServiceFactory pluginServiceFactory) {
        this.pluginServiceFactory = pluginServiceFactory;
        this.createPluginService();
        return this.pluginServiceRef;
    }

    public boolean shouldSaveToConfigurationCache() {
        return true;
    }

    public void onLoadFromConfigurationCache() {
        this.createPluginService();
    }

    public void executionPhaseStarted() {
        if (this.pluginService != null) {
            this.pluginService.executionPhaseStarted();
        }
    }

    public void buildFinished(final @Nullable Throwable buildFailure) {
        if (this.pluginService != null) {
            this.pluginService.getEndOfBuildListener().buildFinished(new GradleEnterprisePluginEndOfBuildListener.BuildResult(){

                @Override
                @Nullable
                public Throwable getFailure() {
                    return buildFailure;
                }
            });
        }
    }

    private void createPluginService() {
        this.pluginService = this.pluginServiceFactory.create(this.config, this.requiredServices, this.buildState);
        this.pluginServiceRef.set(this.pluginService);
        this.buildOperationNotificationListenerRegistrar.register(this.pluginService.getBuildOperationNotificationListener());
    }
}

