/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.text.TreeFormatter;

public class DefaultSourceSetOutput
extends CompositeFileCollection
implements SourceSetOutput {
    private final ConfigurableFileCollection outputDirectories;
    private Object resourcesDir;
    private final ConfigurableFileCollection classesDirs;
    private final ConfigurableFileCollection dirs;
    private final ConfigurableFileCollection generatedSourcesDirs;
    private final FileResolver fileResolver;
    private final List<DirectoryContribution> classesContributions = new ArrayList<DirectoryContribution>();
    private DirectoryContribution resourcesContributor;

    public DefaultSourceSetOutput(String sourceSetDisplayName, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
        this.fileResolver = fileResolver;
        this.classesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classesDirs");
        this.classesDirs.builtBy(new Object[]{this});
        this.outputDirectories = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classes");
        this.outputDirectories.from(new Object[]{this.classesDirs, this::getResourcesDir});
        this.dirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " dirs");
        this.generatedSourcesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " generatedSourcesDirs");
    }

    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        visitor.accept((FileCollectionInternal)this.outputDirectories);
    }

    public String getDisplayName() {
        return this.outputDirectories.toString();
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("source set: " + this.outputDirectories.toString());
        formatter.node("output directories");
        formatter.startChildren();
        ((FileCollectionInternal)this.outputDirectories).describeContents(formatter);
        formatter.endChildren();
    }

    public ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void addClassesDir(Provider<Directory> directory, TaskProvider<?> task) {
        this.classesDirs.from(new Object[]{directory});
        this.classesContributions.add(new DirectoryContribution((Provider<File>)directory.map(Directory::getAsFile), task));
    }

    public void setResourcesContributor(Provider<File> directory, TaskProvider<?> task) {
        this.resourcesContributor = new DirectoryContribution(directory, task);
    }

    @Override
    @Nullable
    public File getResourcesDir() {
        if (this.resourcesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.resourcesDir);
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    @Override
    public void setResourcesDir(Object resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public void builtBy(Object ... taskPaths) {
        this.outputDirectories.builtBy(taskPaths);
    }

    @Override
    public void dir(Object dir) {
        this.dir(Collections.emptyMap(), dir);
    }

    @Override
    public void dir(Map<String, Object> options, Object dir) {
        this.dirs.from(new Object[]{dir});
        this.outputDirectories.from(new Object[]{dir});
        Object builtBy = options.get("builtBy");
        if (builtBy != null) {
            this.builtBy(builtBy);
            this.dirs.builtBy(new Object[]{builtBy});
        }
    }

    @Override
    public FileCollection getDirs() {
        return this.dirs;
    }

    public ConfigurableFileCollection getGeneratedSourcesDirs() {
        return this.generatedSourcesDirs;
    }

    public List<DirectoryContribution> getClassesContributors() {
        return new ArrayList<DirectoryContribution>(this.classesContributions);
    }

    @Nullable
    public DirectoryContribution getResourcesContribution() {
        return this.resourcesContributor;
    }

    public static class DirectoryContribution {
        private final Provider<File> directory;
        private final TaskProvider<?> task;

        public DirectoryContribution(Provider<File> directory, TaskProvider<?> task) {
            this.directory = directory;
            this.task = task;
        }

        public Provider<File> getDirectory() {
            return this.directory;
        }

        public TaskProvider<?> getTask() {
            return this.task;
        }
    }
}

