/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSetFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveVariantState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ArtifactSelector;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.util.internal.CollectionUtils;

public class DefaultArtifactSelector
implements ArtifactSelector {
    private final List<OriginArtifactSelector> selectors;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final ArtifactResolver artifactResolver;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public DefaultArtifactSelector(List<OriginArtifactSelector> selectors, ArtifactResolver artifactResolver, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.selectors = selectors;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactResolver = artifactResolver;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public ArtifactSet resolveArtifacts(LocalFileDependencyMetadata fileDependencyMetadata) {
        return new FileDependencyArtifactSet(fileDependencyMetadata, this.artifactTypeRegistry, this.calculatedValueContainerFactory);
    }

    @Override
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, Map<VariantResolveMetadata.Identifier, ResolvedVariant> resolvedVariantCache, Supplier<Set<? extends VariantResolveMetadata>> allVariants, Set<? extends VariantResolveMetadata> legacyVariants, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
        OriginArtifactSelector selector;
        ImmutableSet<ResolvedVariant> legacyResolvedVariants = this.buildResolvedVariants(component, legacyVariants, exclusions, resolvedVariantCache);
        ComponentArtifactResolveVariantState componentArtifactResolveVariantState = () -> this.buildResolvedVariants(component, (Set)allVariants.get(), exclusions, resolvedVariantCache);
        ArtifactSet artifacts = null;
        Iterator<OriginArtifactSelector> iterator = this.selectors.iterator();
        while (iterator.hasNext() && (artifacts = (selector = iterator.next()).resolveArtifacts(component, componentArtifactResolveVariantState, (Set<ResolvedVariant>)legacyResolvedVariants, exclusions, overriddenAttributes)) == null) {
        }
        if (artifacts == null) {
            throw new IllegalStateException("No artifacts selected.");
        }
        return artifacts;
    }

    private ImmutableSet<ResolvedVariant> buildResolvedVariants(ComponentResolveMetadata component, Set<? extends VariantResolveMetadata> allVariants, ExcludeSpec exclusions, Map<VariantResolveMetadata.Identifier, ResolvedVariant> resolvedVariantCache) {
        ImmutableSet.Builder resolvedVariantBuilder = ImmutableSet.builder();
        for (VariantResolveMetadata variantResolveMetadata : allVariants) {
            ResolvedVariant resolvedVariant = this.toResolvedVariant(variantResolveMetadata.getIdentifier(), variantResolveMetadata.asDescribable(), variantResolveMetadata.getAttributes(), variantResolveMetadata.getArtifacts(), variantResolveMetadata.getCapabilities(), exclusions, component.getModuleVersionId(), component.getSources(), resolvedVariantCache);
            resolvedVariantBuilder.add((Object)resolvedVariant);
        }
        return resolvedVariantBuilder.build();
    }

    private ResolvedVariant toResolvedVariant(VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes variantAttributes, ImmutableList<? extends ComponentArtifactMetadata> artifacts, CapabilitiesMetadata capabilities, ExcludeSpec exclusions, ModuleVersionIdentifier ownerId, ModuleSources moduleSources, Map<VariantResolveMetadata.Identifier, ResolvedVariant> resolvedVariantCache) {
        boolean hasExcludedArtifact;
        List artifactsToResolve = CollectionUtils.filter(artifacts, artifact -> !exclusions.excludesArtifact(ownerId.getModule(), artifact.getName()));
        boolean bl = hasExcludedArtifact = artifactsToResolve.size() < artifacts.size();
        if (hasExcludedArtifact) {
            return this.createResolvedVariant(null, displayName, variantAttributes, artifacts, capabilities, ownerId, moduleSources, artifactsToResolve);
        }
        return resolvedVariantCache.computeIfAbsent(identifier, id -> this.createResolvedVariant(identifier, displayName, variantAttributes, artifacts, capabilities, ownerId, moduleSources, artifactsToResolve));
    }

    private ResolvedVariant createResolvedVariant(VariantResolveMetadata.Identifier resolvedIdentifier, DisplayName displayName, ImmutableAttributes variantAttributes, ImmutableList<? extends ComponentArtifactMetadata> artifacts, CapabilitiesMetadata capabilities, ModuleVersionIdentifier ownerId, ModuleSources moduleSources, List<? extends ComponentArtifactMetadata> artifactsToResolve) {
        ImmutableAttributes attributes = this.artifactTypeRegistry.mapAttributesFor(variantAttributes, (Iterable<? extends ComponentArtifactMetadata>)artifacts);
        return ArtifactSetFactory.toResolvedVariant(resolvedIdentifier, displayName, attributes, artifactsToResolve, DefaultArtifactSelector.withImplicitCapability(capabilities.getCapabilities(), ownerId), ownerId, moduleSources, this.artifactResolver);
    }

    private static ImmutableCapabilities withImplicitCapability(Collection<? extends Capability> capabilities, ModuleVersionIdentifier identifier) {
        if (capabilities.isEmpty()) {
            return ImmutableCapabilities.of(ImmutableCapability.defaultCapabilityForComponent(identifier));
        }
        return ImmutableCapabilities.copyAsImmutable(capabilities);
    }

    @Override
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, Collection<? extends ComponentArtifactMetadata> artifacts, ImmutableAttributes overriddenAttributes) {
        ImmutableAttributes attributes = this.artifactTypeRegistry.mapAttributesFor(component.getAttributes(), artifacts);
        return ArtifactSetFactory.adHocVariant(component.getId(), component.getModuleVersionId(), artifacts, component.getSources(), component.getAttributesSchema(), this.artifactResolver, attributes, overriddenAttributes);
    }
}

