/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentMetadata>
implements LocalComponentGraphResolveState {
    private final ConcurrentMap<LocalConfigurationMetadata, DefaultLocalVariantArtifactResolveState> variants = new ConcurrentHashMap<LocalConfigurationMetadata, DefaultLocalVariantArtifactResolveState>();

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public LocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        return ((LocalComponentMetadata)this.getMetadata()).copy(componentIdentifier, artifacts);
    }

    public DefaultLocalComponentGraphResolveState(LocalComponentMetadata metadata) {
        super(metadata);
    }

    @Override
    public VariantArtifactGraphResolveMetadata resolveArtifactsFor(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationMetadata)variant);
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationMetadata)variant);
    }

    private DefaultLocalVariantArtifactResolveState stateFor(LocalConfigurationMetadata configuration) {
        return this.variants.computeIfAbsent(configuration, c -> new DefaultLocalVariantArtifactResolveState((LocalComponentMetadata)this.getMetadata(), configuration));
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final LocalComponentMetadata component;
        private final LocalConfigurationMetadata graphSelectedVariant;

        public DefaultLocalVariantArtifactResolveState(LocalComponentMetadata component, LocalConfigurationMetadata graphSelectedVariant) {
            this.component = component;
            this.graphSelectedVariant = graphSelectedVariant;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedVariant.getArtifacts();
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            this.graphSelectedVariant.prepareToResolveArtifacts();
            return this.graphSelectedVariant.artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            this.graphSelectedVariant.prepareToResolveArtifacts();
            return artifactSelector.resolveArtifacts(this.component, new HashMap<VariantResolveMetadata.Identifier, ResolvedVariant>(), () -> this.buildAllVariants(), this.graphSelectedVariant.getVariants(), exclusions, overriddenAttributes);
        }

        private Set<? extends VariantResolveMetadata> buildAllVariants() {
            Set<VariantResolveMetadata> allVariants = this.component.getVariantsForGraphTraversal().isPresent() ? ((List)this.component.getVariantsForGraphTraversal().get()).stream().map(LocalConfigurationMetadata.class::cast).filter(ConfigurationMetadata::isCanBeConsumed).peek(LocalConfigurationMetadata::prepareToResolveArtifacts).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet()) : this.graphSelectedVariant.getVariants();
            return allVariants;
        }
    }
}

