/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMinimalDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyBundleValueSource;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.DependencyValueSource;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.internal.catalog.PluginDependencyValueSource;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.plugin.use.PluginDependency;

public abstract class AbstractExternalDependencyFactory
implements ExternalModuleDependencyFactory {
    protected final DefaultVersionCatalog config;
    protected final ProviderFactory providers;
    protected final ObjectFactory objects;

    @Inject
    protected AbstractExternalDependencyFactory(DefaultVersionCatalog config, ProviderFactory providers, ObjectFactory objects) {
        this.config = config;
        this.providers = providers;
        this.objects = objects;
    }

    @Override
    public Provider<MinimalExternalModuleDependency> create(String alias) {
        return this.providers.of(DependencyValueSource.class, spec -> ((DependencyValueSource.Params)spec.getParameters()).getDependencyData().set((Object)this.config.getDependencyData(alias))).map(AbstractExternalDependencyFactory::createMinimalDependency);
    }

    private static DefaultMinimalDependency createMinimalDependency(DependencyModel data) {
        ImmutableVersionConstraint version = data.getVersion();
        return new DefaultMinimalDependency(DefaultModuleIdentifier.newId(data.getGroup(), data.getName()), new DefaultMutableVersionConstraint(version));
    }

    public static class PluginFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public PluginFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<PluginDependency> createPlugin(String name) {
            return this.providers.of(PluginDependencyValueSource.class, spec -> spec.parameters(params -> {
                params.getConfig().set((Object)this.config);
                params.getPluginName().set((Object)name);
            }));
        }
    }

    public static class BundleFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;
        protected final ObjectFactory objects;

        public BundleFactory(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config) {
            this.objects = objects;
            this.providers = providers;
            this.config = config;
        }

        protected Provider<ExternalModuleDependencyBundle> createBundle(String name) {
            Property property = this.objects.property(ExternalModuleDependencyBundle.class);
            property.convention(this.providers.of(DependencyBundleValueSource.class, spec -> spec.parameters(params -> {
                params.getConfig().set((Object)this.config);
                params.getBundleName().set((Object)name);
            })).map(dataList -> dataList.stream().map(x$0 -> AbstractExternalDependencyFactory.createMinimalDependency(x$0)).collect(Collectors.toCollection(() -> new DefaultBundle()))));
            return property;
        }

        private static class DefaultBundle
        extends ArrayList<MinimalExternalModuleDependency>
        implements ExternalModuleDependencyBundle {
            private DefaultBundle() {
            }
        }
    }

    public static class VersionFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public VersionFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<String> getVersion(String name) {
            return this.providers.provider(() -> this.doGetVersion(name));
        }

        private String doGetVersion(String name) {
            ImmutableVersionConstraint version = this.findVersionConstraint(name);
            String requiredVersion = version.getRequiredVersion();
            if (!requiredVersion.isEmpty()) {
                return requiredVersion;
            }
            String strictVersion = version.getStrictVersion();
            if (!strictVersion.isEmpty()) {
                return strictVersion;
            }
            return version.getPreferredVersion();
        }

        protected ImmutableVersionConstraint findVersionConstraint(String name) {
            return this.config.getVersion(name).getVersion();
        }
    }

    public static abstract class SubDependencyFactory
    implements ExternalModuleDependencyFactory {
        protected final AbstractExternalDependencyFactory owner;

        protected SubDependencyFactory(AbstractExternalDependencyFactory owner) {
            this.owner = owner;
        }

        @Override
        public Provider<MinimalExternalModuleDependency> create(String alias) {
            return this.owner.create(alias);
        }
    }
}

