/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.function.Predicate;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;

public class JavaToolchainMatcher
implements Predicate<JavaToolchain> {
    private final JavaToolchainSpec spec;

    public JavaToolchainMatcher(JavaToolchainSpec spec) {
        this.spec = spec;
    }

    @Override
    public boolean test(JavaToolchain toolchain) {
        return this.test(toolchain.getMetadata());
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        Predicate<? super JvmInstallationMetadata> predicate = this.languagePredicate().and(this.vendorPredicate()).and(this.implementationPredicate());
        return predicate.test((JvmInstallationMetadata)metadata);
    }

    private Predicate<JvmInstallationMetadata> languagePredicate() {
        return metadata -> {
            JavaLanguageVersion actualVersion = JavaToolchain.getJavaLanguageVersion(metadata);
            JavaLanguageVersion expectedVersion = (JavaLanguageVersion)this.spec.getLanguageVersion().get();
            return actualVersion.equals(expectedVersion);
        };
    }

    private Predicate<? super JvmInstallationMetadata> implementationPredicate() {
        return metadata -> {
            boolean isJ9Vm = metadata.hasCapability(JvmInstallationMetadata.JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            boolean j9Requested = this.spec.getImplementation().get() == JvmImplementation.J9;
            return j9Requested == isJ9Vm;
        };
    }

    private Predicate<? super JvmInstallationMetadata> vendorPredicate() {
        JvmVendorSpec vendorSpec = (JvmVendorSpec)this.spec.getVendor().get();
        return (Predicate)((Object)vendorSpec);
    }
}

